/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigParser;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.feed.FwBase;
import com.cisco.xdm.data.cbac.feed.FwData;
import com.cisco.xdm.data.cbac.feed.FwFeed;
import com.cisco.xdm.data.cbac.feed.FwGroup;
import com.cisco.xdm.data.cbac.feed.FwProtocol;
import com.cisco.xdm.data.systemproperties.PAMBaseEntry;
import com.cisco.xdm.data.systemproperties.PAMCommonEntry;
import com.cisco.xdm.data.systemproperties.PAMEntry;
import com.cisco.xdm.data.systemproperties.PAMEntryFactory;
import com.cisco.xdm.data.systemproperties.PAMGroupEntry;
import com.cisco.xdm.data.systemproperties.PAMRangeEntry;
import com.cisco.xdm.data.systemproperties.PAMSystemDefinedCollection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PAM
extends XDMObject {
    public static final String KEY_IP = "ip";
    public static final String KEY_PORTMAPPROT = "portmapprot";
    public static final String KEY_PORTNUMBER = "portnumber";
    public static final String KEY_PORTMAPLIST = "portmaplist";
    public static final String KEY_L4PROT = "l4prot";
    public static final String KEY_PORTFROM = "stPortNumber";
    public static final String KEY_PORTTO = "endPortNumber";
    public static final String KEY_PORTNOS = "portnumbers";
    public static final String KEY_DESCRIPTION = "desc";
    public static final String KEY_PORTMAP = "port-map";
    private Vector pamEntries = new Vector();
    private Vector pamGroupEntries = new Vector();
    Properties propPAMProtocolGroup = new Properties();
    FwFeed feed;
    PAMSystemDefinedCollection pSys;

    public PAM() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PAM(XDMObject parent) {
        super(parent);
    }

    public PAM(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
    }

    public void addPAMEntry(PAMBaseEntry pamEntry) {
        if (pamEntry == null) {
            return;
        }
        this.pamEntries.addElement(pamEntry);
        this.setModified();
    }

    public void addToGroup(PAMCommonEntry entry) {
        int groupIndex = -1;
        String protocolName = entry.getProtocol();
        String groupName = this.feed.getData().getGroupName(protocolName);
        if (entry.getProtocol().indexOf("user-") != -1) {
            groupName = "User Defined";
        }
        PAMGroupEntry groupEntry = new PAMGroupEntry(groupName);
        if (groupName != null) {
            groupIndex = this.pamGroupEntries.indexOf(groupEntry);
        }
        if (groupIndex == -1) {
            groupIndex = this.pamGroupEntries.indexOf(new PAMGroupEntry("miscellaneous"));
        }
        if (groupIndex != -1) {
            this.pamGroupEntries.insertElementAt(entry, groupIndex + 1);
        } else {
            this.pamGroupEntries.addElement(entry);
        }
    }

    public Object clone() {
        PAM cloneEntry = (PAM)super.clone();
        cloneEntry.pamEntries = (Vector)this.pamEntries.clone();
        int i = 0;
        while (i < cloneEntry.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            PAMBaseEntry dupEntry = (PAMBaseEntry)entry.clone();
            dupEntry.setParent(cloneEntry);
            cloneEntry.pamEntries.setElementAt(dupEntry, i);
            ++i;
        }
        cloneEntry.pamGroupEntries = (Vector)this.pamGroupEntries.clone();
        Log.getInstance().debug("PAM Cloned.");
        return cloneEntry;
    }

    public boolean contains(PAMBaseEntry entry) {
        if (this.pamEntries.size() == 0) {
            return false;
        }
        return this.pamEntries.contains(entry);
    }

    public boolean equals(PAM ids) {
        Log.getInstance().debug("PAM: equals starts.");
        Log.getInstance().debug("PAM: equals returns TRUE.");
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PAM)) {
            return false;
        }
        PAM pam = (PAM)o;
        return super.equals(pam) && MiscUtils.vectorEquals(this.pamEntries, pam.pamEntries);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        PAM oldPam = (PAM)backup;
        int i = 0;
        while (i < oldPam.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)oldPam.pamEntries.elementAt(i);
            if (!this.contains(entry)) {
                entry.generateDelta(null, values);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i2);
            if (!oldPam.contains(entry)) {
                entry.generateDelta(null, values);
            }
            ++i2;
        }
    }

    public Vector getEntries() {
        return this.pamEntries;
    }

    public Vector getEntriesWithinRange(String type, int stPort, int endPort) {
        return this.getEntriesWithinRange(type, stPort, endPort, null);
    }

    public Vector getEntriesWithinRange(String type, int stPort, int endPort, PAMBaseEntry editEntry) {
        Vector<PAMBaseEntry> entriesWithinRange = new Vector<PAMBaseEntry>();
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (!entry.equals(editEntry) && entry.getL4Protocol().equalsIgnoreCase(type)) {
                if (entry.isEntryWithRange()) {
                    if (((PAMRangeEntry)entry).getStartingPort() >= stPort && ((PAMRangeEntry)entry).getEndingPort() <= endPort) {
                        entriesWithinRange.addElement(entry);
                    }
                } else {
                    int[] ports = ((PAMEntry)entry).getPortNumbers();
                    int ii = 0;
                    while (ii < ports.length) {
                        if (ports[ii] >= stPort && ports[ii] <= endPort) {
                            entriesWithinRange.addElement(entry);
                        }
                        ++ii;
                    }
                }
            }
            ++i;
        }
        return entriesWithinRange;
    }

    public PAMBaseEntry getEntry(String protocol, String ports) {
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getProtocol().equals(protocol) && entry.getPorts().equals(ports)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public PAMBaseEntry getEntry(String protocol, String ports, int list) {
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getProtocol().equals(protocol) && entry.getPorts().equals(ports) && entry.getList() == list) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public PAMBaseEntry getEntry(String protocol, String l4Protocol, String ports) {
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getProtocol().equals(protocol) && entry.getL4Protocol().equalsIgnoreCase(l4Protocol) && entry.getPorts().equals(ports)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public PAMBaseEntry getEntry(String protocol, String l4Protocol, String ports, String list) {
        int iList = -1;
        try {
            iList = Integer.parseInt(list);
        }
        catch (NumberFormatException numberFormatException) {
            iList = -1;
        }
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getProtocol().equals(protocol) && entry.getL4Protocol().equalsIgnoreCase(l4Protocol) && entry.getPorts().equals(ports) && entry.getList() == iList) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public int getEntryCount() {
        return this.pamEntries.size();
    }

    public PAMBaseEntry getEntryForPort(String l4Protocol, String ports) {
        Object nonListEntry = null;
        PAMBaseEntry listEntry = null;
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getL4Protocol().equalsIgnoreCase(l4Protocol) && entry.getPorts().equals(ports)) {
                if (entry.getList() == -1) {
                    return entry;
                }
                listEntry = entry;
            }
            ++i;
        }
        if (listEntry != null) {
            return listEntry;
        }
        return null;
    }

    public PAMBaseEntry getEntryForPort(String l4Protocol, String ports, PAMBaseEntry exceptionEntry) {
        if (exceptionEntry == null) {
            return null;
        }
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getL4Protocol().equalsIgnoreCase(l4Protocol) && entry.getPorts().equals(ports) && !entry.equals(exceptionEntry)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public FwFeed getFeed() {
        return this.feed;
    }

    public Vector getGroupEntries() {
        return this.pamGroupEntries;
    }

    public PAMBaseEntry getPAMEntry(int port) {
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.isExists(port)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public PAMBaseEntry getPAMEntry(String l4Protocol, int port) {
        Object nonListEntry = null;
        PAMBaseEntry listEntry = null;
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getL4Protocol().equalsIgnoreCase(l4Protocol) && entry.isExists(port)) {
                if (entry.getList() == -1) {
                    return entry;
                }
                listEntry = entry;
            }
            ++i;
        }
        if (listEntry != null) {
            return listEntry;
        }
        return null;
    }

    public Vector getRangeEntriesWithPartialOverlap(String type, int stPort, int endPort) {
        return this.getRangeEntriesWithPartialOverlap(type, stPort, endPort, null);
    }

    public Vector getRangeEntriesWithPartialOverlap(String type, int stPort, int endPort, PAMBaseEntry editEntry) {
        Vector<PAMBaseEntry> entriesWithinRange = new Vector<PAMBaseEntry>();
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (!entry.equals(editEntry) && entry.getL4Protocol().equalsIgnoreCase(type) && entry.isEntryWithRange() && (stPort <= ((PAMRangeEntry)entry).getStartingPort() && endPort <= ((PAMRangeEntry)entry).getEndingPort() && endPort >= ((PAMRangeEntry)entry).getStartingPort() || stPort >= ((PAMRangeEntry)entry).getStartingPort() && stPort <= ((PAMRangeEntry)entry).getEndingPort() && endPort >= ((PAMRangeEntry)entry).getEndingPort())) {
                entriesWithinRange.addElement(entry);
            }
            ++i;
        }
        return entriesWithinRange;
    }

    public int getSysEntryCount() {
        if (this.pSys != null) {
            return this.pSys.getEntryCount();
        }
        return 0;
    }

    public PAMSystemDefinedCollection getSystemDefinedCollection() {
        return this.pSys;
    }

    public Vector getUserDefinedEntries() {
        Vector userDefinedEntries = new Vector();
        int i = 0;
        while (i < this.pamEntries.size()) {
            if (((PAMBaseEntry)this.pamEntries.elementAt(i)).getProtocol().indexOf("user-") == 0) {
                userDefinedEntries.addElement(this.pamEntries.elementAt(i));
            }
            ++i;
        }
        return userDefinedEntries;
    }

    public boolean isPortExist(String l4Protocol, int port) {
        return this.isPortExist(l4Protocol, port, null);
    }

    public boolean isPortExist(String l4Protocol, int port, PAMBaseEntry foundPamEntry) {
        int i = 0;
        while (i < this.pamEntries.size()) {
            PAMBaseEntry entry = (PAMBaseEntry)this.pamEntries.elementAt(i);
            if (entry.getL4Protocol().equalsIgnoreCase(l4Protocol) && entry.isExists(port)) {
                foundPamEntry = (PAMBaseEntry)entry.clone();
                return true;
            }
            ++i;
        }
        return false;
    }

    private void jbInit() throws Exception {
    }

    public void loadGroup() {
        this.pamGroupEntries.addElement(new PAMGroupEntry("User Defined"));
        Vector groups = this.feed.getData().getAllProtocolGroups();
        int i = 0;
        while (i < groups.size()) {
            String groupName = ((FwGroup)groups.elementAt(i)).getName();
            PAMGroupEntry entry = new PAMGroupEntry(groupName);
            if (!this.pamGroupEntries.contains(entry)) {
                this.pamGroupEntries.addElement(entry);
            }
            ++i;
        }
        this.pamGroupEntries.removeElement(new PAMGroupEntry("General"));
    }

    public void loadPAMGroup() {
        Object doc = null;
        this.feed = new FwFeed();
    }

    public void loadPAMProperties() {
        this.loadPAMGroup();
    }

    public static void main(String[] args) {
        String _version = "12.2(8)T";
        String _deviceType = "1700";
        try {
            Debug.setLogLevel(6);
            ConfigParser parser = new ConfigParser(_version, _deviceType, "D:/grammar/");
            ConfigValues configValues = parser.getConfigValues("D:/grammar/configfile.txt");
            ConfigValues configValuesnew = parser.getConfigValues("D:/grammar/configfilenew.txt");
            PAM pam = new PAM();
            pam.populate(configValues, null);
            System.out.println("=========================PAM CLIS========================");
            System.out.println(pam.toString());
            PAM pamNew = new PAM();
            pamNew.populate(configValuesnew, null);
            ConfigValues val = new ConfigValues();
            pam.generateDelta(pamNew, val);
        }
        catch (CliGPBException e) {
            e.printStackTrace();
        }
        catch (XDMException ex) {
            ex.printStackTrace();
        }
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getInstance().debug("PAM populate started...");
        this.pamGroupEntries.removeAllElements();
        this.loadPAMProperties();
        this.loadGroup();
        this.pSys = new PAMSystemDefinedCollection((DeviceBase)this.getDevice());
        this.pSys.populate();
        this.removeNonPresentElements();
        String l4Protocol = "";
        try {
            if (config == null) {
                return;
            }
            ConfigValues cv1 = config.getCmds(KEY_IP, KEY_PORTMAPPROT, ".*", false);
            if (cv1 == null || cv1.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < cv1.numCmds()) {
                CmdValues pamCmds = cv1.getCmdValues(i);
                if (pamCmds.isNoCmd()) {
                    Log.getInstance().debug("PAM no cmds ...");
                    Log.getInstance().debug(pamCmds.toString());
                } else {
                    if (pamCmds.containsKey(KEY_L4PROT)) {
                        l4Protocol = pamCmds.getValue(KEY_L4PROT);
                    }
                    String ports = null;
                    int nList = -1;
                    String description = null;
                    if (pamCmds.containsKey(KEY_PORTNUMBER)) {
                        try {
                            ports = pamCmds.getValue(KEY_PORTNUMBER);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    } else if (pamCmds.containsKey(KEY_PORTFROM)) {
                        String stPort = pamCmds.getValue(KEY_PORTFROM);
                        String endPort = pamCmds.getValue(KEY_PORTTO);
                        ports = String.valueOf(stPort) + "-" + endPort;
                    } else if (pamCmds.containsKey(KEY_PORTNOS)) {
                        ports = pamCmds.getValue(KEY_PORTNOS);
                    }
                    if (pamCmds.containsKey(KEY_PORTMAPLIST)) {
                        DeviceBase dev;
                        ACLCollection acls;
                        ACLBase aclPAMList;
                        try {
                            nList = Integer.parseInt(pamCmds.getValue(KEY_PORTMAPLIST));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        if (nList != -1 && (aclPAMList = (acls = (dev = (DeviceBase)this.getDevice()).getAcls()).getACL(Integer.toString(nList))) != null) {
                            aclPAMList.addToCategory(1);
                        }
                    }
                    if (pamCmds.containsKey(KEY_DESCRIPTION)) {
                        description = pamCmds.getValue(KEY_DESCRIPTION);
                    }
                    PAMBaseEntry pamEntry = PAMEntryFactory.createPAMEntries(this, pamCmds.getValue(KEY_PORTMAPPROT), l4Protocol, ports, nList);
                    if (description != null && description.length() > 0) {
                        pamEntry.setDescription(description);
                    }
                    this.pamEntries.addElement(pamEntry);
                    this.addToGroup(pamEntry);
                }
                ++i;
            }
        }
        catch (CliGPBException e) {
            e.printStackTrace();
        }
        Log.getInstance().debug("PAM populate finished.");
        Log.getInstance().debug("=========================PAM CLIS========================");
        Log.getInstance().debug(this.toString());
    }

    public void removeElementFromGroup(PAMBaseEntry entry) {
        this.pamGroupEntries.removeElement(entry);
    }

    public void removeNonPresentElements() {
        FwData fwData = this.feed.getData();
        Vector groups = fwData.getGroups();
        Enumeration e = groups.elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            Enumeration en = grp.getItems().elements();
            while (en.hasMoreElements()) {
                FwBase fwBase = (FwBase)en.nextElement();
                if (!(fwBase instanceof FwProtocol)) continue;
                FwProtocol fwProtocol = (FwProtocol)fwBase;
                if (this.getSystemDefinedCollection().getProtocolNames().contains(fwProtocol.getName())) continue;
                grp.removeProtocol(fwProtocol);
            }
        }
    }

    public void removePAMEntry(PAMBaseEntry pamEntry) {
        if (pamEntry == null) {
            return;
        }
        this.pamEntries.removeElement(pamEntry);
        this.setModified();
    }

    public void setModified() {
        super.setModified();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Enumeration en = this.pamEntries.elements();
        while (en.hasMoreElements()) {
            PAMBaseEntry entry = (PAMBaseEntry)en.nextElement();
            s.append(String.valueOf(entry.toString()) + "\n");
        }
        return s.toString();
    }
}

