/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.systemproperties.PAMCommonEntry;
import com.cisco.xdm.data.systemproperties.PAMEntry;
import com.cisco.xdm.data.systemproperties.PAMRangeEntry;

public abstract class PAMBaseEntry
extends XDMObject
implements PAMCommonEntry {
    String protocol;
    String layer4Protocol = "";
    int list = -1;
    String description = "";
    String subnet;
    XDMObject parent;
    int type = 1;
    public static final int USER_DEFINED = 1;
    public static final int SYS_DEFINED = 0;

    public PAMBaseEntry() {
    }

    public PAMBaseEntry(XDMObject parent) {
        super(parent);
    }

    public PAMBaseEntry(XDMObject parent, String protocol, String layer4Protocol, int list) {
        this.parent = parent;
        this.protocol = protocol;
        this.layer4Protocol = layer4Protocol;
        this.list = list;
    }

    public PAMBaseEntry(String protocol, String layer4Protocol, int list) {
        this.protocol = protocol;
        this.layer4Protocol = layer4Protocol;
        this.list = list;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PAMEntry || o instanceof PAMRangeEntry || o instanceof PAMBaseEntry)) {
            return false;
        }
        PAMBaseEntry entry = (PAMBaseEntry)o;
        boolean isEntryEqual = true;
        if (this.protocol != null) {
            boolean bl = isEntryEqual = isEntryEqual && this.protocol.equals(entry.getProtocol());
        }
        if (this.layer4Protocol != null) {
            boolean bl = isEntryEqual = isEntryEqual && this.layer4Protocol.equals(entry.getL4Protocol());
        }
        if (this.description != null) {
            isEntryEqual = isEntryEqual && this.description.equals(entry.getDescription());
        }
        isEntryEqual = isEntryEqual && this.list == entry.getList();
        return isEntryEqual;
    }

    public String getDescription() {
        return this.description;
    }

    public String getL4Protocol() {
        return this.layer4Protocol;
    }

    public int getList() {
        return this.list;
    }

    public abstract String getPorts();

    public String getProtocol() {
        return this.protocol;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public int getType() {
        return this.type;
    }

    public abstract boolean isEntryWithRange();

    public abstract boolean isExists(int var1);

    public boolean isGroup() {
        return false;
    }

    public boolean isReadOnly() {
        return super.isReadOnly();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
    }

    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        return String.valueOf(this.protocol) + ":" + this.layer4Protocol + ":" + this.list + ":" + ":" + this.description + ":";
    }
}

