/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.xdm.data.systemproperties.PAMSysDefinedEntry;

class PAMParse {
    public static final String DEF_MAPPING = "Default mapping:";
    static int protStIndex = "Default mapping:".length();
    static String line = "Default mapping:  orasrv               tcp port 1525...1529                system defined";

    private static String getLayer4Protocol(String line) {
        if (line == null) {
            return null;
        }
        int portIndex = line.lastIndexOf("port");
        return line.substring(portIndex - 5, portIndex).trim();
    }

    private static String getPort(String line) {
        if (line == null) {
            return null;
        }
        int portIndex = line.lastIndexOf("port");
        return line.substring(portIndex + 5, line.indexOf("system")).trim();
    }

    public static String getPortSequence(String detailOutput, String l4Protocol) {
        String portNumbers = "";
        int index = detailOutput.indexOf(l4Protocol.toLowerCase());
        if (index != -1) {
            int endIndex = detailOutput.indexOf(" ", (index += 4) + 1);
            portNumbers = detailOutput.substring(index, endIndex);
        }
        return portNumbers.trim();
    }

    private static String getProtocolName(String line) {
        if (line == null) {
            return null;
        }
        String protName = line.substring(protStIndex, line.lastIndexOf("port") - 5);
        return protName.trim();
    }

    public static void main(String[] ar) {
        PAMSysDefinedEntry entry = PAMParse.parseEntry(line);
        System.out.println(entry);
        System.out.println(String.valueOf(entry.getStartingPort()) + ".." + entry.getEndingPort());
        System.out.println(String.valueOf(entry.isEntryWithRange()) + ".." + entry.isEntryWithSequence());
    }

    public static PAMSysDefinedEntry parseEntry(String line) {
        if (line == null) {
            return null;
        }
        int portIndex = line.lastIndexOf("port");
        String protocolName = PAMParse.getProtocolName(line);
        String l4Prot = line.substring(portIndex - 5, portIndex).trim();
        String port = line.substring(portIndex + 5, line.indexOf("system")).trim();
        return new PAMSysDefinedEntry(protocolName, l4Prot, port, 0);
    }
}

