/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.systemproperties;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.systemproperties.PAMBaseEntry;

public class PAMRangeEntry
extends PAMBaseEntry {
    int stPort;
    int endPort;

    public PAMRangeEntry() {
    }

    PAMRangeEntry(XDMObject parent) {
        super(parent);
    }

    PAMRangeEntry(XDMObject parent, String protocol, String layer4Protocol, int stPort, int endPort) {
        super(parent, protocol, layer4Protocol, -1);
        this.stPort = stPort;
        this.endPort = endPort;
    }

    PAMRangeEntry(XDMObject parent, String protocol, String layer4Protocol, int stPort, int endPort, int list) {
        super(parent, protocol, layer4Protocol, list);
        this.stPort = stPort;
        this.endPort = endPort;
    }

    public CmdValues createPAMEntry() {
        CmdValues cmd = new CmdValues("ip");
        cmd.addValue("port-map", "port-map");
        cmd.addValue("portmapprot", this.getProtocol());
        cmd.addValue("port", "port");
        cmd.addValue("l4prot", this.getL4Protocol());
        cmd.addValue("from", "from");
        cmd.addValue("stPortNumber", Integer.toString(this.getStartingPort()));
        cmd.addValue("to", "to");
        cmd.addValue("endPortNumber", Integer.toString(this.getEndingPort()));
        if (this.list != -1) {
            cmd.addValue("list", "list");
            cmd.addValue("portmaplist", Integer.toString(this.getList()));
        }
        if (this.description != null && this.description.length() > 0) {
            cmd.addValue("description", "description");
            cmd.addValue("desc", this.getDescription());
        }
        return cmd;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PAMRangeEntry)) {
            return false;
        }
        PAMRangeEntry entry = (PAMRangeEntry)o;
        return this.stPort == entry.stPort && this.endPort == entry.endPort && super.equals(o);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd = this.createPAMEntry();
        if (this.isBackup()) {
            cmd.setAction(2);
        } else {
            cmd.setAction(1);
        }
        values.addCmdValues(cmd);
    }

    public int getEndingPort() {
        return this.endPort;
    }

    public String getPorts() {
        return String.valueOf(this.stPort) + "-" + this.endPort;
    }

    public int getStartingPort() {
        return this.stPort;
    }

    public boolean isEntryWithRange() {
        return true;
    }

    public boolean isExists(int port) {
        return port >= this.stPort && port <= this.endPort;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.stPort + ".." + this.endPort;
    }
}

