/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.vpdn;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.vpdn.VPDN;
import com.cisco.xdm.data.vpdn.VPDNGroup;
import java.util.Enumeration;

public class VPDNGroupCollection
extends XDMHashCollection {
    public VPDNGroupCollection() {
    }

    public VPDNGroupCollection(XDMObject parent) {
        super(parent);
    }

    public void addVPDNGroup(VPDNGroup vpdn) {
        vpdn.setParent(this);
        this.put(vpdn.getName(), vpdn);
    }

    public VPDNGroup createVPDNGroup() {
        int n = this.getNextGroupNo();
        return new VPDNGroup(n);
    }

    private int getNextGroupNo() {
        int nextGroup = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            VPDNGroup group = (VPDNGroup)e.nextElement();
            if (group.getGroupNo() <= nextGroup) continue;
            nextGroup = group.getGroupNo();
        }
        return nextGroup + 1;
    }

    public VPDNGroup getPPPOEVPDNGroup() {
        VPDNGroup vpdnGroup = null;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            VPDNGroup group = (VPDNGroup)e.nextElement();
            if (group.getProtocol() == null || !group.getProtocol().equals("pppoe") || group.isReadOnly()) continue;
            vpdnGroup = group;
            break;
        }
        return vpdnGroup;
    }

    public boolean isPPPOESet() {
        boolean pppoeSet = false;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            VPDNGroup group = (VPDNGroup)e.nextElement();
            if (group.getProtocol() == null || !group.getProtocol().equals("pppoe")) continue;
            pppoeSet = true;
            break;
        }
        if (this.getParent() != null && !((VPDN)this.getParent()).isVpdnEnabledSet()) {
            pppoeSet = false;
        }
        return pppoeSet;
    }

    public void populate(ConfigValues config, CmdValues cmdvals) throws XDMException, CliGPBException {
        ConfigValues groupCmds = config.getCmds("vpdn-group", ".*", ".*", false);
        if (groupCmds == null) {
            return;
        }
        int i = 0;
        while (i < groupCmds.numCmds()) {
            VPDNGroup vpdn = new VPDNGroup(this);
            vpdn.populate(config, groupCmds.getCmdValues(i));
            this._hashTable.put(vpdn.getName(), vpdn);
            ++i;
        }
    }

    public void removeVPDNGroup(VPDNGroup vpdn) {
        this.remove(vpdn.getName());
        this.setModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            sb.append(String.valueOf(e.nextElement().toString()) + "\n");
        }
        return sb.toString();
    }
}

