/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net;

import com.cisco.xdm.net.URL;
import com.cisco.xdm.net.URLFactoryDefault;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public class URLI
implements URL {
    public static final int UNKNOWN_PORT = -1;
    private static final String AT = "@";
    private static final String CLN = ":";
    private static final String FSL = "/";
    private static final String NULL = "";
    private String _scheme;
    private String _username;
    private String _password;
    private String _host;
    private int _port;
    private String _path;

    public URLI(URL url, String path) throws MalformedURLException {
        this._scheme = url.getScheme();
        this._username = url.getUsername();
        this._password = url.getPassword();
        this._host = url.getHost();
        this._port = url.getPort();
        this._path = path == null ? NULL : path;
    }

    public URLI(String url) throws MalformedURLException, UnknownHostException {
        URL u = URLFactoryDefault.getInstance().createURL(url);
        this._scheme = u.getScheme();
        this._username = u.getUsername();
        this._password = u.getPassword();
        this._host = u.getHost();
        this._port = u.getPort();
        this._path = u.getPath();
    }

    public URLI(String scheme, String host, int port, String path) throws MalformedURLException, UnknownHostException {
        this(scheme, null, null, host, port, path);
    }

    public URLI(String scheme, String username, String password, String host, int port, String path) throws MalformedURLException, UnknownHostException {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (this.hasReservedChars(scheme)) {
            throw new MalformedURLException("Reserved character(s): " + scheme);
        }
        this._scheme = scheme;
        this._username = username;
        this._password = password;
        if (host == null) {
            throw new UnknownHostException(host);
        }
        this._host = host;
        if (port <= 0) {
            this._port = -1;
        } else {
            if (port > 65535) {
                throw new IllegalArgumentException("port > 65535");
            }
            this._port = port;
        }
        this._path = path == null ? NULL : path;
    }

    public URLI(java.net.URL url) {
        this._scheme = url.getProtocol();
        this._username = null;
        this._password = null;
        this._host = url.getHost();
        this._port = url.getPort();
        this._path = String.valueOf(url.getFile()) + (url.getRef() != null ? "#" + url.getRef() : NULL);
    }

    public URLI(java.net.URL url, String path) throws MalformedURLException {
        this(new java.net.URL(url, path));
    }

    public boolean equals(Object o) {
        return o.toString().equals(this.toString());
    }

    public String getBase() {
        return this.toString(true);
    }

    public String getHost() {
        return this._host;
    }

    public String getPassword() {
        return this._password;
    }

    public String getPath() {
        return this._path;
    }

    public int getPort() {
        return this._port;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getUsername() {
        return this._username;
    }

    private boolean hasReservedChars(String s) {
        char[] chars = s.toCharArray();
        int ii = 0;
        while (ii < chars.length) {
            int jj = 0;
            while (jj < URL.RESERVED_CHARS.length) {
                if (chars[ii] == URL.RESERVED_CHARS[jj]) {
                    return true;
                }
                ++jj;
            }
            ++ii;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isInternetScheme() {
        return true;
    }

    public boolean isPasswordEmpty() {
        if (this._password == null) {
            return false;
        }
        return this._password.equals(NULL);
    }

    public boolean isUsernameEmpty() {
        if (this._username == null) {
            return false;
        }
        return this._username.equals(NULL);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean base_only) {
        StringBuffer sb = new StringBuffer();
        sb.append(this._scheme);
        sb.append(CLN);
        sb.append(FSL);
        sb.append(FSL);
        if (this._username != null) {
            sb.append(this._username);
            if (this._password != null) {
                sb.append(CLN);
                sb.append(this._password);
            }
            sb.append(AT);
        }
        sb.append(this._host);
        if (this._port > 0) {
            sb.append(CLN);
            sb.append(this._port);
        }
        if (!base_only && this._path != null) {
            if (!this._path.startsWith(FSL)) {
                sb.append(FSL);
            }
            sb.append(this._path);
        } else {
            sb.append(FSL);
        }
        return sb.toString();
    }

    public java.net.URL toURL() {
        java.net.URL url = null;
        try {
            StringBuffer sb = new StringBuffer(this._scheme);
            sb.append(CLN);
            sb.append(FSL);
            sb.append(FSL);
            sb.append(this._host);
            if (this._port > 0) {
                sb.append(CLN);
                sb.append(this._port);
            }
            if (this._path == null || !this._path.startsWith(FSL)) {
                sb.append(FSL);
            }
            if (this._path != null) {
                sb.append(this._path);
            }
            url = new java.net.URL(sb.toString());
        }
        catch (MalformedURLException x) {
            x.printStackTrace(System.out);
        }
        return url;
    }
}

