/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.lib.expect.TelnetProtocol;
import com.cisco.nm.lib.expect.TelnetSocket;
import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.gui.XDMConfirmDlg;
import com.cisco.xdm.gui.XDMFrame;
import com.cisco.xdm.gui.XDMMessageDialog;
import com.cisco.xdm.gui.vlan.ConsoleTelCredentialDlg;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import com.cisco.xdm.util.Env;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.net.Socket;

public class ConsoleIOSCmdService
extends IOSCmdServiceBase {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_TELNET_PORT = 23;
    public static final String CRLF = "\r\n";
    public static final int MAX_LOGIN_CYCLE = 10;
    private Socket _sock;
    private TelnetSocket _ts;
    private TelnetProtocol _tp;
    private TelnetBuffer _tb;
    static final String[] PROMPTS = new String[]{">", "#", "assw", ":", "(enable)", "%", "?", "]"};
    private String _execPrompt;
    private String _configPrompt;
    private Log log = Log.getLog();
    private boolean isConfigSWDM = false;
    final ConsoleTelCredentialDlg logDiag = new ConsoleTelCredentialDlg((Frame)((XDMFrame)Env.getMainFrame()), true);

    private void checkConnect() throws IOSCmdServiceException {
        this.log.debug("ConsoleIOSCmdService: checkConnect");
        try {
            this.sendControlled(CRLF);
            this.expect(this._execPrompt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.debug("ConsoleIOSCmdService: reconnecting");
            this.connect();
        }
    }

    public synchronized void close() throws IOSCmdServiceException {
        try {
            this._tp.close();
        }
        catch (IOException ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public synchronized IOSCmdResponse[] config(String[] cmds) throws IOSCmdServiceException {
        return this.config(cmds, null);
    }

    public synchronized IOSCmdResponse[] config(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        this.checkConnect();
        try {
            if (cmds.length < 1) {
                return new IOSCmdResponse[0];
            }
            if (this._execPrompt.indexOf(">") > -1) {
                this.sendControlled("enable\r\n");
                this.expect("#");
            }
            this.sendControlled("configure terminal\r\n");
            this.expect(this._configPrompt);
            IOSCmdResponse[] responses = this.execute(cmds, this._configPrompt, promptHandler);
            this.sendControlled("end\r\n");
            this.expect(this._execPrompt);
            return responses;
        }
        catch (IOException ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect() throws IOSCmdServiceException {
        try {
            this._sock = SgzApplet.createSocket(this._ipAddress, this._port);
            this._ts = new TelnetSocket(this._sock);
            this._tp = new TelnetProtocol(this._ts);
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
        if (!this._ts.isReady()) {
            throw this.processIOSCmdServiceException("Telnet socket not ready");
        }
        try {
            this._tb = new TelnetBuffer(this._tp);
            int nCycles = 0;
            while (nCycles++ < 10) {
                this.receiveUntilQuiet(2000);
                String r = this._tb.getCurrLine().toLowerCase();
                this.log.debug("the r = " + r);
                if (r.indexOf(">") > -1 || r.indexOf("#") > -1) break;
                if (r.indexOf("[yes/no]:") > -1) {
                    this.sendControlled("no\r\n");
                }
                if (r.indexOf("username") > -1) {
                    int dlgRetVal = this.logDiag.doModal();
                    if (dlgRetVal == 1) {
                        this.sendControlled(String.valueOf(this.logDiag.getUserName()) + CRLF);
                    } else if (dlgRetVal == 0 && this.isConfigSWDM) {
                        int nResult = XDMConfirmDlg.showConfirmDlg((Container)Env.getMainFrame(), (String)Env.getString((int)20101), (String)Env.getString((int)44262), (int)4, (String)Env.getString((int)40013), (String)Env.getString((int)40014), null, null, null);
                        if (nResult == 1) {
                            Log.getInstance().debug("ConsoleIOSCmdService: login session cancelled.");
                            throw this.processIOSCmdServiceException("canceled");
                        }
                        if (this.logDiag.doModal() != 1) {
                            Log.getInstance().debug("ConsoleIOSCmdService: login session cancelled.");
                            throw this.processIOSCmdServiceException("canceled");
                        }
                        this.sendControlled(String.valueOf(this.logDiag.getUserName()) + CRLF);
                    } else {
                        Log.getInstance().debug("ConsoleIOSCmdService: login session cancelled.");
                        throw this.processIOSCmdServiceException("canceled");
                    }
                    this._tb.newLine();
                } else {
                    if (r.indexOf("assw") > -1) {
                        this.sendUncontrolled(String.valueOf(this.logDiag.getPasswd()) + CRLF);
                        this._tb.newLine();
                        break;
                    }
                    this.sendControlled(CRLF);
                }
                Thread.sleep(100L);
            }
            if (nCycles >= 10) {
                throw this.processIOSCmdServiceException("login sequence");
            }
            this._tb.clear();
            this.learnPrompts();
            this.sendControlled("term length 0\r\n");
            this.expect(this._execPrompt);
            return;
        }
        catch (IOException iOException) {
            throw this.processIOSCmdServiceException("login sequence");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public synchronized void connect(String protocol, String ipAddress, int port, CredentialRepository credRep) throws IOSCmdServiceException {
        this._protocol = protocol;
        this._ipAddress = ipAddress;
        this._port = port < 0 ? 23 : port;
        this._credRep = credRep;
        this.connect();
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds) throws IOSCmdServiceException {
        return this.exec(cmds, null);
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        this.checkConnect();
        return this.execute(cmds, this._execPrompt, promptHandler);
    }

    private IOSCmdResponse[] execute(String[] cmds, String prompt, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        IOSCmdResponse[] responses = new IOSCmdResponse[cmds.length];
        int i = 0;
        while (i < cmds.length) {
            String cmd = cmds[i];
            if (cmd != null) {
                try {
                    boolean endsWithQM = cmd.endsWith("?");
                    if (endsWithQM) {
                        this.sendControlled(cmd);
                    } else {
                        this.sendControlled(String.valueOf(cmd) + CRLF);
                    }
                    this._tb.clear();
                    this.log.debug("ConsoleIOSCmdService: expecting " + StringUtils.quoted(prompt));
                    if (promptHandler == null) {
                        do {
                            this._tb.read();
                        } while (this._tb.getCurrLine().indexOf(prompt) <= -1);
                    } else {
                        boolean bPreviousNewline = false;
                        while (true) {
                            if (bPreviousNewline) {
                                this.log.debug("ConsoleIOSCmdService: seeking line of response");
                                this._tb.readln();
                                this._tb.read();
                            } else {
                                this.log.debug("ConsoleIOSCmdService: seeking any response");
                                this._tb.read();
                            }
                            String x = promptHandler.handle(this._tb.getAllLines());
                            this.log.debug("ConsoleIOSCmdService: received prompt handler <" + x + ">");
                            if (x != null) {
                                this.log.debug("ConsoleIOSCmdService: got interactive prompt " + StringUtils.quoted(this._tb.getCurrLine()));
                                this.sendUncontrolled(x);
                                bPreviousNewline = x.endsWith("\n");
                                continue;
                            }
                            this.log.debug("ConsoleIOSCmdService: current line <" + this._tb.getCurrLine());
                            if (this._tb.getCurrLine().indexOf(prompt) > -1) break;
                            bPreviousNewline = false;
                        }
                    }
                    responses[i] = new IOSCmdResponse(cmd, this._tb.getBufferedLines(), 0);
                    if (endsWithQM) {
                        this.sendUncontrolled("\u0015");
                    }
                }
                catch (IOException ex) {
                    throw this.processIOSCmdServiceException(String.valueOf(ex.getMessage()) + "\n" + this._tb.toString());
                }
            }
            ++i;
        }
        return responses;
    }

    private String expect(String s) throws IOException {
        this.log.debug("ConsoleIOSCmdService: expecting " + StringUtils.quoted(s));
        do {
            this._tb.read();
        } while (this._tb.getCurrLine().indexOf(s) <= -1);
        return this._tb.getBufferedLines();
    }

    public int getTimeout() throws IOSCmdServiceException {
        try {
            return this._sock.getSoTimeout();
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public boolean isSecure() {
        return false;
    }

    private String learnPrompt() throws IOException, IOSCmdServiceException {
        int[] pcount = new int[PROMPTS.length];
        int i = 0;
        while (i < 5) {
            this.sendControlled(CRLF);
            String r = this.receive(1).trim();
            this.log.debug("the r in learnPrompt = " + r);
            if (r.toLowerCase().indexOf("would") > -1) {
                this.sendControlled("no\r\n");
                break;
            }
            if (r.toLowerCase().indexOf("username") > -1 && this.isConfigSWDM) {
                XDMMessageDialog.showMessage((Container)Env.getMainFrame(), (String)Env.getString((int)44301), (int)1);
                throw this.processIOSCmdServiceException("unable to learn prompt");
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            int j = 0;
            while (j < PROMPTS.length) {
                if (r.indexOf(PROMPTS[j]) > -1) {
                    int n = j;
                    pcount[n] = pcount[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        int maxcount = -1;
        int maxidx = -1;
        int j = 0;
        while (j < PROMPTS.length) {
            if (pcount[j] > maxcount) {
                maxcount = pcount[j];
                maxidx = j;
            }
            ++j;
        }
        if (maxidx < 0) {
            throw this.processIOSCmdServiceException("unable to learn prompt");
        }
        this.log.debug("ConsoleIOSCmdService: learned prompt is " + StringUtils.quoted(PROMPTS[maxidx]));
        return PROMPTS[maxidx];
    }

    private void learnPrompts() throws IOException {
        this._execPrompt = this.learnPrompt();
        if (this._execPrompt.indexOf(">") > -1) {
            this.sendControlled("enable\r\n");
            this.expect("#");
            this._execPrompt = "#";
        }
        if (this._execPrompt.indexOf("#") > -1) {
            this.sendControlled("configure terminal\r\n");
            this.expect("#");
            this._configPrompt = "#";
            this.sendControlled("exit\r\n");
            this.expect(this._execPrompt);
        }
    }

    private String receive(int minLen) throws IOException {
        String s;
        while ((s = this._tp.readText()).length() < minLen) {
        }
        this.log.debug("ConsoleIOSCmdService: rcvd " + StringUtils.quoted(s));
        return s;
    }

    private void receiveUntilQuiet(int msecs) throws IOException {
        int oTimeout = this.getTimeout();
        this.setTimeout(msecs);
        try {
            while (true) {
                this._tb.read();
            }
        }
        catch (IOException ex) {
            this.setTimeout(oTimeout);
            return;
        }
    }

    private void sendControlled(String s) throws IOException {
        this.log.debug("ConsoleIOSCmdService: sending " + StringUtils.quoted(s));
        int i = 0;
        int n = s.length();
        while (i < n) {
            char rch;
            String chs = s.substring(i, i + 1);
            this._tp.writeString(chs);
            char ch = chs.charAt(0);
            while ((rch = this._tb.readChar()) != ch) {
            }
            ++i;
        }
    }

    private void sendUncontrolled(String s) throws IOException {
        this.log.debug("ConsoleIOSCmdService: sending " + StringUtils.quoted(s));
        this._tp.writeString(s);
    }

    public void setConfigFlag() {
        this.isConfigSWDM = true;
    }

    public void setTimeout(int msecs) throws IOSCmdServiceException {
        try {
            this.log.debug("ConsoleIOSCmdService: setting timeout to " + msecs);
            this._sock.setSoTimeout(msecs);
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public void usSetConfigFlag() {
        this.isConfigSWDM = false;
    }

    private class TelnetBuffer {
        private TelnetProtocol _tp;
        private int _crsX;
        private int _lineCount;
        private StringBuffer _bufferedLines;
        private StringBuffer _currLine;

        TelnetBuffer(TelnetProtocol tp) {
            this._tp = tp;
            this._bufferedLines = new StringBuffer();
            this._currLine = new StringBuffer();
        }

        void clear() {
            this._crsX = 0;
            this._currLine.setLength(0);
            this._bufferedLines.setLength(0);
        }

        String[] getAllLines() {
            return new String[]{this._bufferedLines.toString(), this._currLine.toString()};
        }

        String getBufferedLines() {
            String s = this._bufferedLines.toString();
            this._bufferedLines.setLength(0);
            return s;
        }

        String getCurrLine() {
            return this._currLine.toString();
        }

        void newLine() {
            this._bufferedLines.append(this._currLine);
            this._bufferedLines.append("\n");
            this._crsX = 0;
            this._currLine.setLength(0);
        }

        void print() {
            System.out.println(this.toString());
            System.out.println();
        }

        private void putCharIntoBuffer(char ch) {
            switch (ch) {
                case '\r': {
                    this._crsX = 0;
                    break;
                }
                case '\n': {
                    this._bufferedLines.append(this._currLine);
                    this._bufferedLines.append("\n");
                    this._currLine.setLength(0);
                    ++this._lineCount;
                    break;
                }
                default: {
                    if (this._crsX >= this._currLine.length()) {
                        this._currLine.setLength(this._crsX + 1);
                    }
                    this._currLine.setCharAt(this._crsX, ch);
                    ++this._crsX;
                }
            }
        }

        void read() throws IOException {
            String s = this._tp.readText();
            int i = 0;
            int n = s.length();
            while (i < n) {
                char ch = s.charAt(i);
                this.putCharIntoBuffer(ch);
                ++i;
            }
        }

        char readChar() throws IOException {
            char ch = (char)this._tp.readByte();
            this.putCharIntoBuffer(ch);
            return ch;
        }

        void readln() throws IOException {
            int lc = this._lineCount;
            do {
                this.read();
            } while (lc == this._lineCount);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("--------------------------------------------------\n");
            sb.append("|" + this._lineCount + ": " + StringUtils.quoted(this._bufferedLines.toString()) + "\n");
            sb.append("|" + this._crsX + "> " + StringUtils.quoted(this._currLine.toString()) + "\n");
            sb.append("--------------------------------------------------\n");
            return sb.toString();
        }
    }
}

