/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.nm.util.sgz.SgzApplet;
import com.cisco.xdm.net.cmdsvc.ConsoleIOSCmdService;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.FileIOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.PAIIOSCmdService;
import com.cisco.xdm.net.cmdsvc.SSHIOSCmdService;
import com.cisco.xdm.net.cmdsvc.TelnetIOSCmdService;
import java.applet.Applet;

public class IOSCmdServiceFactory {
    public static boolean _Trace = false;

    private IOSCmdServiceFactory() {
    }

    public static IOSCmdService create(String protocol, String host, int port, CredentialRepository credRep) throws IOSCmdServiceException {
        return IOSCmdServiceFactory.create(protocol, host, port, credRep, -1);
    }

    public static IOSCmdService create(String protocol, String host, int port, CredentialRepository credRep, int controlTimeout) throws IOSCmdServiceException {
        Applet a = SgzApplet.getEffectiveApplet();
        boolean sshDebug = false;
        if (a != null) {
            String cmdsvcProt = a.getParameter("cmdsvcProt");
            String cmdsvcPort = a.getParameter("cmdsvcPort");
            String cmdsvcHost = a.getParameter("cmdsvcHost");
            _Trace = Boolean.valueOf(a.getParameter("cmdsvcTrace"));
            sshDebug = Boolean.valueOf(a.getParameter("sshd"));
            if (cmdsvcProt != null) {
                protocol = cmdsvcProt;
            }
            if (cmdsvcPort != null) {
                port = Integer.parseInt(cmdsvcPort);
            }
            if (cmdsvcHost != null) {
                host = cmdsvcHost;
            }
            if (!protocol.equals("console")) {
                credRep = new CredentialRepository(credRep);
                credRep.setCredential(1, a.getParameter("cmdsvcUser"));
                credRep.setCredential(2, a.getParameter("cmdsvcPass"));
            } else if (credRep != null) {
                credRep = new CredentialRepository(credRep);
                credRep.setCredential(1, a.getParameter("cmdsvcUser"));
                credRep.setCredential(2, a.getParameter("cmdsvcPass"));
            }
        }
        if (_Trace) {
            System.out.println("IOSCmdServiceFactory.create: protocol=" + protocol + " host=" + host + " port=" + port + " user=" + credRep.getCredential(1) + " password=" + credRep.getCredential(2));
        }
        if (protocol != null) {
            IOSCmdServiceBase cmdSvc = null;
            if (protocol.startsWith("http")) {
                cmdSvc = new PAIIOSCmdService();
            } else if (protocol.equals("ssh")) {
                cmdSvc = new SSHIOSCmdService();
                ((SSHIOSCmdService)cmdSvc).setDebug(sshDebug);
            } else if (protocol.equals("telnet")) {
                cmdSvc = new TelnetIOSCmdService();
            } else if (protocol.equals("console")) {
                cmdSvc = new ConsoleIOSCmdService();
                if (credRep != null) {
                    ((ConsoleIOSCmdService)cmdSvc).setConfigFlag();
                } else {
                    ((ConsoleIOSCmdService)cmdSvc).usSetConfigFlag();
                }
            } else if (protocol.equals("file")) {
                cmdSvc = new FileIOSCmdService();
            }
            if (cmdSvc != null) {
                if (controlTimeout != -1) {
                    cmdSvc.setInternalTimeout(controlTimeout);
                }
                cmdSvc.connect(protocol, host, port, credRep);
                return cmdSvc;
            }
        }
        throw new IOSCmdServiceException("No IOS command service available (" + protocol + ")");
    }
}

