/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.net.cmdsvc;

import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.commonutils.StringUtils;
import com.cisco.xdm.net.cmdsvc.CredentialRepository;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceFactory;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import com.maverick.ssh.LicenseManager;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshSession;
import com.maverick.ssh1.Ssh1Context;
import com.sshtools.net.SocketTransport;
import com.sshtools.util.BufferedSession;
import java.io.IOException;

public class SSHIOSCmdService
extends IOSCmdServiceBase {
    private boolean _DEBUG = false;
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int DEFAULT_TIMEOUT = 120000;
    public static final int CHECK_TIMEOUT = 10000;
    public static final int IDLE_TIMEOUT = 1000;
    public static final int DEFAULT_INTERNAL_TIMEOUT = 100;
    public static final int DEFAULT_SECONDARY_INTERNAL_TIMEOUT = 250;
    static final String[] PROMPTS = new String[]{">", "#", "assw", ":", "(enable)", "%", "?", "]"};
    private String _execPrompt;
    private String _configPrompt;
    private int _timeout = 120000;
    private int _internalTimeout = 100;
    private int _secondaryInternalTimeout = 250;
    private SshClient ssh = null;
    private SshSession ssh_session = null;
    private StringBuffer sbread = null;
    private BufferedSession buf_session = null;
    private String cmd_sent = null;

    private void checkConnect() throws IOSCmdServiceException {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("SSHIOSCmdService: checkConnect");
        }
        int curTimeout = this.getTimeout();
        this.setTimeout(10000);
        try {
            this.send("\n");
            this.expect(this._execPrompt);
        }
        catch (Exception ex) {
            if (IOSCmdServiceFactory._Trace) {
                ex.printStackTrace();
            }
            if (IOSCmdServiceFactory._Trace) {
                System.out.println("SSHIOSCmdService: reconnecting");
            }
            this.connect_ssh();
        }
        this.setTimeout(curTimeout);
    }

    public synchronized void close() {
        block3: {
            if (IOSCmdServiceFactory._Trace) {
                System.out.println("SSHIOSCmdService: close");
            }
            try {
                this.buf_session.getOutputStream().write("exit\r\n".getBytes());
                this.buf_session.close();
                this.ssh_session.close();
                this.ssh.disconnect();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!IOSCmdServiceFactory._Trace) break block3;
                System.out.println("SSHIOSCmdService: cannot close");
            }
        }
    }

    public synchronized IOSCmdResponse[] config(String[] cmds) throws IOSCmdServiceException {
        return this.config(cmds, null);
    }

    public synchronized IOSCmdResponse[] config(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        this.checkConnect();
        this.exec(new String[]{"configure terminal"});
        IOSCmdResponse[] responses = this.execute(cmds, this._configPrompt, promptHandler);
        this.exec(new String[]{"end"});
        return responses;
    }

    public synchronized void connect(String protocol, String ipAddress, int port, CredentialRepository credRep) throws IOSCmdServiceException {
        this._protocol = protocol;
        this._ipAddress = ipAddress;
        this._port = port < 0 ? 22 : port;
        this._credRep = credRep;
        this.connect_ssh();
    }

    private void connect_ssh() throws IOSCmdServiceException {
        String username = this._credRep.getCredential(1);
        String password = this._credRep.getCredential(2);
        int ssh_auth = 0;
        if (username.equals("") && password.equals("")) {
            throw this.processIOSCmdServiceException("canceled");
        }
        try {
            this.license_ssh();
            SshConnector con = SshConnector.getInstance();
            try {
                this.ssh = con.connect(new SocketTransport(this._ipAddress, this._port), username);
            }
            catch (IOException ioe) {
                String exMsg = ioe.getMessage();
                if (exMsg != null && exMsg.toLowerCase().indexOf("cipher could not be agreed") != -1) {
                    Log.getLog().info("Retrying with DES...");
                    ((Ssh1Context)con.getContext(1)).setCipherType(2);
                    this.ssh = con.connect(new SocketTransport(this._ipAddress, this._port), username);
                }
                throw this.processIOSCmdServiceException(ioe);
            }
            PasswordAuthentication pwd = new PasswordAuthentication();
            pwd.setPassword(password);
            while ((ssh_auth = this.ssh.authenticate(pwd)) != 1 && this.ssh.isConnected()) {
            }
            this.ssh_session = this.ssh.openSessionChannel();
            this.buf_session = new BufferedSession(this.ssh_session);
            this.buf_session.startShell();
        }
        catch (Exception ex) {
            if (ssh_auth == 2) {
                throw this.processIOSCmdServiceException("credentials");
            }
            throw this.processIOSCmdServiceException(ex);
        }
        try {
            this.learnPrompts(this._credRep);
            this.exec(new String[]{"term length 0"});
        }
        catch (Exception ex) {
            throw this.processIOSCmdServiceException(ex);
        }
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds) throws IOSCmdServiceException {
        return this.exec(cmds, null);
    }

    public synchronized IOSCmdResponse[] exec(String[] cmds, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        this.checkConnect();
        return this.execute(cmds, this._execPrompt, promptHandler);
    }

    private IOSCmdResponse[] execute(String[] cmds, String prompt, PromptHandlerIf promptHandler) throws IOSCmdServiceException {
        IOSCmdResponse[] responses = new IOSCmdResponse[cmds.length];
        int i = 0;
        while (i < cmds.length) {
            String cmd = cmds[i];
            if (cmd != null) {
                try {
                    String cl;
                    int p;
                    String r;
                    boolean endsWithQM = cmd.endsWith("?");
                    if (endsWithQM) {
                        this.send(cmd);
                        Thread.sleep(500L);
                        this.send(String.valueOf(StringUtils.chrrep('\b', cmd.length() - 1)) + "\n");
                    } else {
                        this.send(String.valueOf(cmd) + "\n");
                    }
                    StringBuffer replySB = new StringBuffer();
                    if (IOSCmdServiceFactory._Trace) {
                        System.out.println("SSHIOSCmdService: expecting " + StringUtils.quoted(prompt));
                    }
                    if (promptHandler == null) {
                        while (true) {
                            r = null;
                            r = this.receive_ssh(this._internalTimeout);
                            if (replySB.length() == 0 && r.startsWith(String.valueOf(cmd) + "\n")) {
                                r = r.substring(cmd.length() + 1);
                            }
                            if ((p = r.lastIndexOf(10)) > -1) {
                                replySB.append(r.substring(0, p + 1));
                                cl = r.substring(p + 1);
                            } else {
                                cl = r;
                            }
                            if (cl.indexOf(prompt) <= -1) {
                                replySB.append(cl);
                                continue;
                            }
                            break;
                        }
                    } else {
                        while (true) {
                            r = null;
                            r = this.receive_ssh(this._internalTimeout);
                            p = r.lastIndexOf(10);
                            if (p > -1) {
                                replySB.append(r.substring(0, p + 1));
                                cl = r.substring(p + 1);
                            } else {
                                cl = r;
                            }
                            String x = promptHandler.handle(new String[]{r, cl});
                            if (x != null) {
                                replySB.append(cl);
                                if (IOSCmdServiceFactory._Trace) {
                                    System.out.println("SSHIOSCmdService: got interactive prompt " + StringUtils.quoted(cl));
                                }
                                while ((p = x.indexOf(13)) > 0) {
                                    x = String.valueOf(x.substring(0, p)) + x.substring(p + 1);
                                }
                                this.send(x);
                                continue;
                            }
                            if (cl.indexOf(prompt) > -1) break;
                            replySB.append(cl);
                        }
                    }
                    responses[i] = new IOSCmdResponse(cmd, replySB.toString(), 0);
                    if (IOSCmdServiceFactory._Trace) {
                        System.out.println("SSHIOSCmdService: rcvd " + StringUtils.quoted(responses[i].getOutput()));
                    }
                }
                catch (Exception ex) {
                    throw this.processIOSCmdServiceException(ex);
                }
            }
            ++i;
        }
        return responses;
    }

    private String expect(String s) throws Exception {
        String cl;
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("SSHIOSCmdService: expecting " + StringUtils.quoted(s));
        }
        StringBuffer sb = new StringBuffer();
        do {
            cl = null;
            cl = this.receive_ssh(this._internalTimeout);
            sb.append(cl);
        } while (cl.indexOf(s) <= -1);
        return sb.toString();
    }

    public int getInternalTimeout() {
        return this._internalTimeout;
    }

    public int getSecondaryInternalTimeout() {
        return this._secondaryInternalTimeout;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean isSecure() {
        return true;
    }

    private String learnPrompt() throws Exception {
        String rs = null;
        int[] pcount = new int[PROMPTS.length];
        int i = 0;
        while (i < 5) {
            this.send("!" + i + "\n");
            rs = this.receive_ssh(this._internalTimeout);
            String r = rs.trim();
            int j = 0;
            while (j < PROMPTS.length) {
                if (r.indexOf(PROMPTS[j]) > -1) {
                    int n = j;
                    pcount[n] = pcount[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        int maxcount = -1;
        int maxidx = -1;
        int j = 0;
        while (j < PROMPTS.length) {
            if (pcount[j] > maxcount) {
                maxcount = pcount[j];
                maxidx = j;
            }
            ++j;
        }
        if (maxidx < 0) {
            throw this.processIOSCmdServiceException("unable to learn prompt");
        }
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("SSHIOSCmdService: learned prompt is " + StringUtils.quoted(PROMPTS[maxidx]));
        }
        return PROMPTS[maxidx];
    }

    private void learnPrompts(CredentialRepository credRep) throws Exception {
        int p;
        String privStr = null;
        this._execPrompt = this.learnPrompt();
        this.send("show privilege\n");
        Thread.sleep(100L);
        privStr = this.receive_ssh(this._secondaryInternalTimeout);
        if (privStr.equals("")) {
            privStr = this.receive_ssh(this._secondaryInternalTimeout);
        }
        if ((p = privStr.lastIndexOf(10)) > -1) {
            privStr = privStr.substring(0, p);
        }
        if (!privStr.trim().endsWith("15") && !privStr.trim().endsWith("'root'")) {
            this.send("enable\n");
            this.receive_ssh(this._internalTimeout);
            this.send(String.valueOf(credRep.getCredential(2)) + "\n");
            this.receive_ssh(this._internalTimeout);
            this.send("show privilege\n");
            privStr = this.receive_ssh(this._secondaryInternalTimeout);
            p = privStr.lastIndexOf(10);
            if (p > -1) {
                privStr = privStr.substring(0, p);
            }
            if (!privStr.trim().endsWith("15")) {
                throw this.processIOSCmdServiceException("Insufficient privilege for user " + credRep.getCredential(1));
            }
            this._execPrompt = this.learnPrompt();
        }
        this.send("configure terminal\n");
        this.receive_ssh(this._internalTimeout);
        this._configPrompt = this.learnPrompt();
        this.send("exit\n");
        this.expect(this._execPrompt);
    }

    private void license_ssh() {
        LicenseManager.addLicense("----BEGIN 3SP LICENSE----\r\nProduct : J2SSH Maverick\r\nLicensee: Cisco Systems - Security Device Manager\r\nComments: Hari Mahesh\r\nType    : Enterprise\r\nCreated : 27 Mar 2004 15:57:52 GMT\r\n\r\n378721F2C9439FDBA600F3CF9CCEF4C84F017DABD8863355\r\n4455ED36EE203D610BCCEA3615E273D125660D90FD9DAA86\r\n722A73C4BE8BBD512D2B15C00C178FA71FB04A97D3E1A3DF\r\n9C655890769BC5BB2431924B5881E7B412E5DF440AD86411\r\n3DBE1B7D7653E8F84312AD6530B5E0EB0AD31649ACD5033E\r\n2F761BB681AB137F55B6DC7C44ADCFF114AD2FB292E6A868\r\n----END 3SP LICENSE----\r\n");
    }

    private String receive(String check, int delay) throws Exception {
        String s;
        block5: {
            s = null;
            int i = 0;
            long t = System.currentTimeMillis() + (long)this._timeout;
            int idleCounter = 0;
            do {
                if ((i = this.buf_session.getInputStream().available()) > 0) {
                    idleCounter = 0;
                    byte[] prompt = new byte[i];
                    int j = this.buf_session.getInputStream().read(prompt, 0, i);
                    String string_temp = new String(prompt, 0, i);
                    if ((s = s != null ? s.concat(string_temp) : string_temp).startsWith(this.cmd_sent)) {
                        s = s.substring(this.cmd_sent.length());
                    }
                    if (check == null || !s.endsWith(check)) continue;
                    break block5;
                }
                if (i == 0) {
                    Thread.sleep(100L);
                    if (++idleCounter * 100 <= delay) continue;
                    break block5;
                }
                throw this.processIOSCmdServiceException("SSH library or protocol error");
            } while (System.currentTimeMillis() <= t);
            Log.getLog().warn("TIMEOUT");
        }
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("   reading " + StringUtils.quoted(s));
        }
        return s;
    }

    private String receive_ssh() throws Exception {
        return this.receive_ssh(null, 1000);
    }

    private String receive_ssh(int delay) throws Exception {
        return this.receive_ssh(null, delay);
    }

    private String receive_ssh(String prompt) throws Exception {
        return this.receive_ssh(prompt, 1000);
    }

    private String receive_ssh(String prompt, int delay) throws Exception {
        String s = null;
        long t = System.currentTimeMillis() + (long)this._timeout;
        while ((s = this.receive(prompt, delay)) == null) {
            if (System.currentTimeMillis() <= t) continue;
            Log.getLog().warn("TIMEOUT");
            break;
        }
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("receiving " + StringUtils.quoted(s));
        }
        return s;
    }

    private void send(String s) {
        if (IOSCmdServiceFactory._Trace) {
            System.out.println("SSHIOSCmdService: sending " + StringUtils.quoted(s));
        }
        try {
            this.cmd_sent = s;
            int p = this.cmd_sent.lastIndexOf(10);
            if (p > -1) {
                this.cmd_sent = this.cmd_sent.substring(0, p);
            }
            this.buf_session.getOutputStream().write(s.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDebug(boolean dflag) {
        this._DEBUG = dflag;
    }

    public void setInternalTimeout(int msecs) {
        this._internalTimeout = msecs;
    }

    public void setSecondaryInternalTimeout(int msecs) {
        this._secondaryInternalTimeout = msecs;
    }

    public void setTimeout(int msecs) {
        this._timeout = msecs;
    }
}

