/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.xmlparser;

import com.cisco.xdm.data.discovery.XDMHWDictionaryHandler;
import com.cisco.xdm.xmlparser.Frame;
import com.cisco.xdm.xmlparser.XDMObjectHandler;
import com.cisco.xdm.xmlparser.XmlHandler;
import com.cisco.xdm.xmlparser.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;

public class XmlApp
implements XmlHandler {
    public boolean isApplet = false;
    public XmlParser parser;
    private Frame cf = null;
    private Stack frameStack = new Stack();
    private boolean dbg;
    private XDMObjectHandler handler;

    public XmlApp() {
        this.dbg = false;
    }

    public XmlApp(XDMObjectHandler objHandler) {
        this.handler = objHandler;
        this.dbg = false;
    }

    public void attribute(String name, String value, boolean isSpecified) {
        if (this.dbg) {
            System.out.println("attribute " + name + "=" + value);
        }
        if (this.cf == null) {
            this.cf = new Frame();
        }
        this.cf.attrs.put(name, value);
    }

    public void charData(char[] ch, int start, int length) {
    }

    public void doParse(InputStream in) throws Exception {
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        this.parser.parse(null, null, in, null);
    }

    public void doParse(String url) throws Exception {
        if (this.dbg) {
            System.out.println("url = " + url.toString());
        }
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        this.parser.parse(XmlApp.makeAbsoluteURL(url), (String)null, (String)null);
    }

    public void doctypeDecl(String name, String pubid, String sysid) {
    }

    public void endDocument() {
    }

    public void endElement(String name) {
        Frame parentFrame;
        if (this.dbg) {
            System.out.println("endElement begin for <" + name + ">");
        }
        this.cf = (Frame)this.frameStack.pop();
        if (this.dbg) {
            System.out.println("popped element = " + this.cf.name);
        }
        Frame frame = parentFrame = this.frameStack.empty() ? null : (Frame)this.frameStack.peek();
        if (this.dbg) {
            System.out.println("calling recieveXMLObject");
        }
        this.handler.recieveXMLObject(this.cf, parentFrame);
        this.cf = null;
    }

    public void endExternalEntity(String systemId) {
    }

    public void error(String message, String url, int line, int column) {
    }

    private String escape(char[] ch, int length) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < length) {
            switch (ch[i]) {
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                case '\n': {
                    out.append("\\n");
                    break;
                }
                case '\t': {
                    out.append("\\t");
                    break;
                }
                case '\r': {
                    out.append("\\r");
                    break;
                }
                case '\f': {
                    out.append("\\f");
                    break;
                }
                default: {
                    out.append(ch[i]);
                    break;
                }
            }
            ++i;
        }
        return out.toString();
    }

    public Stack getFrameStack() {
        return this.frameStack;
    }

    public XDMObjectHandler getXDMObjectHandler() {
        return this.handler;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public static void main(String[] args) throws IOException, Exception {
        XmlApp app = new XmlApp();
        XDMHWDictionaryHandler dictionaryHandler = new XDMHWDictionaryHandler();
        app.setXDMObjectHandler(dictionaryHandler);
        app.doParse(args[0]);
    }

    private static String makeAbsoluteURL(String url) throws MalformedURLException {
        String fileSep;
        String currentDirectory = System.getProperty("user.dir");
        String file = String.valueOf(currentDirectory.replace((fileSep = System.getProperty("file.separator")).charAt(0), '/')) + '/';
        if (file.charAt(0) != '/') {
            file = "/" + file;
        }
        URL baseURL = new URL("file", null, file);
        return new URL(baseURL, url).toString();
    }

    public void processingInstruction(String target, String data) {
    }

    public Object resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void setXDMObjectHandler(XDMObjectHandler objHandler) {
        this.handler = objHandler;
    }

    public void startDocument() {
        if (this.dbg) {
            System.out.println("Inside Start Document");
        }
        this.cf = null;
        this.frameStack.empty();
    }

    public void startElement(String name) {
        if (this.dbg) {
            System.out.println("startElement " + name);
        }
        if (this.cf == null) {
            this.cf = new Frame();
        }
        this.cf.name = name;
        if (this.dbg) {
            System.out.println("pushed element " + this.cf.name);
        }
        this.frameStack.push(this.cf);
        this.cf = null;
    }

    public void startExternalEntity(String systemId) {
    }
}

