/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.crypto.digests;

import com.maverick.ssh.crypto.digests.GeneralDigest;

public class SHA1Digest
extends GeneralDigest {
    private static final int d = 20;
    private int h;
    private int f;
    private int c;
    private int b;
    private int a;
    private int[] _ = new int[80];
    private int k;
    private static final int j = 1518500249;
    private static final int i = 1859775393;
    private static final int g = -1894007588;
    private static final int e = -899497514;

    public SHA1Digest() {
        this.reset();
    }

    public SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.h = sHA1Digest.h;
        this.f = sHA1Digest.f;
        this.c = sHA1Digest.c;
        this.b = sHA1Digest.b;
        this.a = sHA1Digest.a;
        System.arraycopy(sHA1Digest._, 0, this._, 0, sHA1Digest._.length);
        this.k = sHA1Digest.k;
    }

    public String getAlgorithmName() {
        return "SHA-1";
    }

    public int getDigestSize() {
        return 20;
    }

    protected void processWord(byte[] byArray, int n) {
        this._[this.k++] = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        if (this.k == 16) {
            this.processBlock();
        }
    }

    private void B(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    protected void processLength(long l) {
        if (this.k > 14) {
            this.processBlock();
        }
        this._[14] = (int)(l >>> 32);
        this._[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        this.B(this.h, byArray, n);
        this.B(this.f, byArray, n + 4);
        this.B(this.c, byArray, n + 8);
        this.B(this.b, byArray, n + 12);
        this.B(this.a, byArray, n + 16);
        this.reset();
        return 20;
    }

    public void reset() {
        super.reset();
        this.h = 1732584193;
        this.f = -271733879;
        this.c = -1732584194;
        this.b = 271733878;
        this.a = -1009589776;
        this.k = 0;
        for (int i = 0; i != this._.length; ++i) {
            this._[i] = 0;
        }
    }

    private int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int G(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int E(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private int B(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    protected void processBlock() {
        int n;
        int n2;
        int n3;
        for (n3 = 16; n3 <= 79; ++n3) {
            this._[n3] = this.B(this._[n3 - 3] ^ this._[n3 - 8] ^ this._[n3 - 14] ^ this._[n3 - 16], 1);
        }
        n3 = this.h;
        int n4 = this.f;
        int n5 = this.c;
        int n6 = this.b;
        int n7 = this.a;
        for (n2 = 0; n2 <= 19; ++n2) {
            n = this.B(n3, 5) + this.F(n4, n5, n6) + n7 + this._[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = this.B(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 <= 39; ++n2) {
            n = this.B(n3, 5) + this.G(n4, n5, n6) + n7 + this._[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = this.B(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 <= 59; ++n2) {
            n = this.B(n3, 5) + this.E(n4, n5, n6) + n7 + this._[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = this.B(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 <= 79; ++n2) {
            n = this.B(n3, 5) + this.G(n4, n5, n6) + n7 + this._[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = this.B(n4, 30);
            n4 = n3;
            n3 = n;
        }
        this.h += n3;
        this.f += n4;
        this.c += n5;
        this.b += n6;
        this.a += n7;
        this.k = 0;
        for (n2 = 0; n2 != this._.length; ++n2) {
            this._[n2] = 0;
        }
    }
}

