/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.crypto.macs;

import com.maverick.ssh.crypto.digests.GeneralDigest;

public class HMac {
    private static final int E = 64;
    private static final byte D = 54;
    private static final byte G = 92;
    private GeneralDigest F;
    private int B;
    private byte[] A = new byte[64];
    private byte[] C = new byte[64];

    public HMac(GeneralDigest generalDigest) {
        this.F = generalDigest;
        this.B = generalDigest.getDigestSize();
    }

    public String getAlgorithmName() {
        return this.F.getAlgorithmName() + "/HMAC";
    }

    public GeneralDigest getUnderlyingDigest() {
        return this.F;
    }

    public void init(byte[] byArray) {
        int n;
        this.F.reset();
        if (byArray.length > 64) {
            this.F.update(byArray, 0, byArray.length);
            this.F.doFinal(this.A, 0);
            for (n = this.B; n < this.A.length; ++n) {
                this.A[n] = 0;
            }
        } else {
            System.arraycopy(byArray, 0, this.A, 0, byArray.length);
            for (n = byArray.length; n < this.A.length; ++n) {
                this.A[n] = 0;
            }
        }
        this.C = new byte[this.A.length];
        System.arraycopy(this.A, 0, this.C, 0, this.A.length);
        n = 0;
        while (n < this.A.length) {
            int n2 = n++;
            this.A[n2] = (byte)(this.A[n2] ^ 0x36);
        }
        n = 0;
        while (n < this.C.length) {
            int n3 = n++;
            this.C[n3] = (byte)(this.C[n3] ^ 0x5C);
        }
        this.F.update(this.A, 0, this.A.length);
    }

    public int getMacSize() {
        return this.B;
    }

    public void update(byte by) {
        this.F.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.F.update(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.B];
        this.F.doFinal(byArray2, 0);
        this.F.update(this.C, 0, this.C.length);
        this.F.update(byArray2, 0, byArray2.length);
        int n2 = this.F.doFinal(byArray, n);
        this.reset();
        return n2;
    }

    public void reset() {
        this.F.reset();
        this.F.update(this.A, 0, this.A.length);
    }
}

