/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.io;

import com.maverick.ssh.io.ByteArrayReader;
import com.maverick.ssh.io.UnsignedInteger32;
import com.maverick.ssh.io.UnsignedInteger64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayWriter
extends ByteArrayOutputStream {
    public ByteArrayWriter() {
    }

    public ByteArrayWriter(int n) {
        super(n);
    }

    public byte[] array() {
        return this.buf;
    }

    public void move(int n) {
        this.count += n;
    }

    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeBoolean(boolean bl) {
        this.write(bl ? 1 : 0);
    }

    public void writeBinaryString(byte[] byArray) throws IOException {
        this.writeBinaryString(byArray, 0, byArray.length);
    }

    public void writeBinaryString(byte[] byArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        this.write(byArray, n, n2);
    }

    public void writeMPINT(BigInteger bigInteger) {
        short s = (short)((bigInteger.bitLength() + 7) / 8);
        byte[] byArray = bigInteger.toByteArray();
        this.writeShort((short)bigInteger.bitLength());
        if (byArray[0] == 0) {
            this.write(byArray, 1, s);
        } else {
            this.write(byArray, 0, s);
        }
    }

    public void writeShort(short s) {
        this.write(s >>> 8 & 0xFF);
        this.write(s >>> 0 & 0xFF);
    }

    public void writeInt(long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        this.write(byArray);
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        this.write(byArray);
    }

    public static byte[] encodeInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public void writeUINT32(UnsignedInteger32 unsignedInteger32) throws IOException {
        this.writeInt(unsignedInteger32.longValue());
    }

    public void writeUINT64(UnsignedInteger64 unsignedInteger64) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = unsignedInteger64.bigIntValue().toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        this.write(byArray);
    }

    public void writeUINT64(long l) throws IOException {
        this.writeUINT64(new UnsignedInteger64(l));
    }

    public void writeString(String string) throws IOException {
        this.writeString(string, ByteArrayReader.getCharsetEncoding());
    }

    public void writeString(String string, String string2) throws IOException {
        if (string == null) {
            this.writeInt(0);
        } else {
            this.writeInt(string.length());
            if (ByteArrayReader.encode) {
                this.write(string.getBytes(string2));
            } else {
                this.write(string.getBytes());
            }
        }
    }
}

