/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.message;

import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.message.SshChannelMessage;
import com.maverick.ssh.message.SshMessageRouter;
import com.maverick.ssh.message.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class SshAbstractChannel
implements SshChannel {
    public static final int CHANNEL_UNINITIALIZED = 1;
    public static final int CHANNEL_OPEN = 2;
    public static final int CHANNEL_CLOSED = 3;
    protected int channelid = -1;
    protected int state = 1;
    protected SshMessageRouter manager;
    protected SshMessageStore ms;

    protected SshMessageStore getMessageStore() throws IOException {
        if (this.ms == null) {
            throw new IOException("Channel is not initialized!");
        }
        return this.ms;
    }

    public int getChannelId() {
        return this.channelid;
    }

    protected void init(SshMessageRouter sshMessageRouter, int n) {
        this.channelid = n;
        this.manager = sshMessageRouter;
        this.ms = new SshMessageStore(sshMessageRouter, this);
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    protected abstract boolean processChannelMessage(SshChannelMessage var1) throws IOException;

    public abstract /* synthetic */ void addChannelEventListener(ChannelEventListener var1);

    public abstract /* synthetic */ void close();

    public abstract /* synthetic */ OutputStream getOutputStream() throws IOException;

    public abstract /* synthetic */ InputStream getInputStream() throws IOException;
}

