/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.publickey;

import com.maverick.ssh.crypto.digests.Hash;
import com.maverick.ssh.crypto.digests.SHA1Digest;
import com.maverick.ssh.publickey.Rsa;
import com.maverick.ssh.publickey.RsaKey;
import com.maverick.ssh.publickey.RsaPrivateKey;
import com.maverick.ssh.security.SecureRandom;
import java.io.IOException;
import java.math.BigInteger;

public class RsaPrivateCrtKey
extends RsaPrivateKey {
    protected BigInteger publicExponent;
    protected BigInteger primeP;
    protected BigInteger primeQ;
    protected BigInteger primeExponentP;
    protected BigInteger primeExponentQ;
    protected BigInteger crtCoefficient;

    public RsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        this(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, Rsa.getPrimeExponent(bigInteger3, bigInteger4), Rsa.getPrimeExponent(bigInteger3, bigInteger5), bigInteger6);
    }

    public RsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        super(bigInteger, bigInteger3);
        this.publicExponent = bigInteger2;
        this.primeP = bigInteger4;
        this.primeQ = bigInteger5;
        this.primeExponentP = bigInteger6;
        this.primeExponentQ = bigInteger7;
        this.crtCoefficient = bigInteger8;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public byte[] sign(byte[] byArray) throws IOException {
        Hash hash = new Hash(new SHA1Digest());
        hash.putBytes(byArray);
        byArray = hash.doFinal();
        byte[] byArray2 = new byte[byArray.length + RsaKey.ASN_SHA1.length];
        System.arraycopy(RsaKey.ASN_SHA1, 0, byArray2, 0, RsaKey.ASN_SHA1.length);
        System.arraycopy(byArray, 0, byArray2, RsaKey.ASN_SHA1.length, byArray.length);
        byArray = byArray2;
        BigInteger bigInteger = new BigInteger(1, byArray);
        int n = (this.getModulus().bitLength() + 7) / 8;
        bigInteger = Rsa.padPKCS1(bigInteger, 1, n, SecureRandom.getInstance());
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = this.getPrimeP();
        BigInteger bigInteger4 = this.getPrimeQ();
        BigInteger bigInteger5 = this.getPrimeExponentP();
        BigInteger bigInteger6 = this.getPrimeExponentQ();
        BigInteger bigInteger7 = this.getCrtCoefficient();
        bigInteger2 = Rsa.doPrivateCrt(bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
        byte[] byArray3 = RsaPrivateKey.unsignedBigIntToBytes(bigInteger2, n);
        return byArray3;
    }
}

