/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.publickey;

import com.maverick.ssh.SshPrivateKey;
import com.maverick.ssh.crypto.digests.Hash;
import com.maverick.ssh.crypto.digests.SHA1Digest;
import com.maverick.ssh.publickey.Rsa;
import com.maverick.ssh.publickey.RsaKey;
import com.maverick.ssh.security.SecureRandom;
import java.io.IOException;
import java.math.BigInteger;

public class RsaPrivateKey
extends RsaKey
implements SshPrivateKey {
    protected BigInteger privateExponent;

    public RsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger);
        this.privateExponent = bigInteger2;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public byte[] sign(byte[] byArray) throws IOException {
        Hash hash = new Hash(new SHA1Digest());
        hash.putBytes(byArray);
        byArray = hash.doFinal();
        byte[] byArray2 = new byte[byArray.length + RsaKey.ASN_SHA1.length];
        System.arraycopy(RsaKey.ASN_SHA1, 0, byArray2, 0, RsaKey.ASN_SHA1.length);
        System.arraycopy(byArray, 0, byArray2, RsaKey.ASN_SHA1.length, byArray.length);
        byArray = byArray2;
        BigInteger bigInteger = new BigInteger(1, byArray);
        int n = (this.getModulus().bitLength() + 7) / 8;
        bigInteger = Rsa.padPKCS1(bigInteger, 1, n, SecureRandom.getInstance());
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = this.getPrivateExponent();
        BigInteger bigInteger4 = this.getModulus();
        bigInteger2 = Rsa.doPrivate(bigInteger, bigInteger4, bigInteger3);
        byte[] byArray3 = RsaPrivateKey.unsignedBigIntToBytes(bigInteger2, n);
        return byArray3;
    }

    protected static byte[] unsignedBigIntToBytes(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else if (byArray.length < n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public boolean equals(Object object) {
        if (object instanceof RsaPrivateKey) {
            RsaPrivateKey rsaPrivateKey = (RsaPrivateKey)object;
            return rsaPrivateKey.getBitLength() == this.getBitLength() && rsaPrivateKey.getModulus().compareTo(this.getModulus()) == 0 && rsaPrivateKey.getPrivateExponent().compareTo(this.getPrivateExponent()) == 0;
        }
        return false;
    }
}

