/*
 * Copyright (c) 2002, 2003, 2004 by cisco Systems, Inc.
 * All rights reserved.
 */

function isGoodFilter(filterNb, filterDescription){
  var form = window.document.forms[0];
  var pattern, results, count = 0, text, defaultMask;
  var nextInput;

  
    defaultMask = "ffff.ffff.ffff";
  

  pattern = "access-list " + filterNb + " ((permit|deny) +(\\S+) +(\\S+))";
  results = form.showRun.value.match(pattern);

  while (results != null) {
    nextInput = results.input.substring(results[0].length + results.index);
    if (nextInput.search("access-list " + filterNb) != -1) {
	  //not the last element in the filter
      if (results[2] == "deny") {
        text = typeString + ": " + results[3] + " Mask: " + results[4] + " - Block";
      } else {
        text = typeString + ": " + results[3] + " Mask: " + results[4] + " - Forward";
      }
    } else {
      if (results[4] == defaultMask) {
        if (results[2] == "deny") {
          text = "Default - Block All";
        } else {
          text = "Default - Forward All";
        }
      } else {
        return false;
      }
    }
    filterDescription[count++] = new aclElementObject(text, results[1])
    results = results.input.substring(results[0].length + results.index).match(pattern);
  }
  
  if (count == 0) {
    return false;
  } else {
    return true;
  }
} 

function filterAclListName(name){
  var count = 1, i;
  var form = document.forms[0];
  var pattern, results;
  clearSelectList(form.filterList, 1, form.filterList.options.length);

  filterListStartup[0] = new aclObject("", new Array());

  
	pattern = /access-list (7\d\d) (permit|deny) +\S+ +\S+[\r\n]+/
  

  results = form.showRun.value.match(pattern);

  while (results != null) {
    var filterDescription = new Array();
	if (!count || filterListStartup[count-1].name != results[1]) {
      if (isGoodFilter(results[1], filterDescription)) {
        filterListStartup[count] = new aclObject(results[1], filterDescription);
        form.filterList.options[count++] = new Option(results[1], results[1]);
      }
	}
    delete filterDescription;
    results = results.input.substring(results[0].length  + results.index).match(pattern);
  }

  if (name != "") {
    for (i = 1; i < filterListStartup.length; i ++) {
      if (filterListStartup[i].name == name) {
        filterIndex = i;
        break;
      }
    }
  }

  return true;
}

function checkFilterIndex(){
  var form = document.forms[0];
  
  if (form.filterName.value.search(/\D/) != -1) {
    alert(warning189); //1198
    form.filterName.value = form.filterName.defaultValue;
    return false;
  }

  if ((form.filterName.value < minTypeNb) || (form.filterName.value > maxTypeNb)) {
    var replacableArrayVal = new Array(minTypeNb, maxTypeNb);
    var msgFormatedStr = replacedStringArr(chkFilterIndex,replacableArrayVal);
    alert(msgFormatedStr);
    //alert(warning190 + minTypeNb + warning191 + maxTypeNb + ".");// 1199 1200
    form.filterName.value = form.filterName.defaultValue;
    return false;
  }
  filterListRunning.name = form.filterName.value;
  form.filterName.defaultValue = form.filterName.value;
  return true;
}


function addFilterElement() {
  var form = document.forms[0];
  var pattern, lastIndex, index, text, command;
  
  if (checkElements() == false) {
    return false;
  }	

  lastIndex = filterListRunning.element.length;
  index = form.filterAction.selectedIndex;
  
  text =  typeString + ": " + form.filterFuturElement.value + " Mask: " + form.filterFuturMask.value + " - " + form.filterAction.options[index].text
  command = form.filterAction.options[index].value + " " + convertForIOS(form.filterFuturElement.value) + " " + convertForIOS(form.filterFuturMask.value);
  if (lastIndex != 0) {
    form.filterDescrList.options[lastIndex-1].text = filterListRunning.element[lastIndex-1].text = text;
    form.filterDescrList.options[lastIndex-1].value = filterListRunning.element[lastIndex-1].command = command;
  } else {
    filterListRunning.element[0] = new aclElementObject(text, command);
    form.filterDescrList.options[0] = new Option(text, command);  
    lastIndex++;
  }
  
  index = form.defaultAction.selectedIndex;
  filterListRunning.element[lastIndex] = new aclElementObject("Default - " + form.defaultAction.options[index].text, form.defaultAction.options[index].value);
  form.filterDescrList.options[lastIndex] = new Option("Default - " + form.defaultAction.options[index].text, form.defaultAction.options[index].value);
  form.filterDescrList.options[lastIndex-1].selected = true;
}

function initDefaultValue() {
  document.forms[0].filterFuturElement.defaultValue = document.forms[0].filterFuturElement.value = "";
}


function createFilterCmd() {
  var form = document.forms[0];
  var cmd = "", name;

  if (form.filterName.value == "") {
    alert(warning192); //1201
    return cmd;
  }

  if (filterListRunning.element.length == 0) {
    alert(warning193); //1202
    return cmd;
  }

  if ((form.filterList.selectedIndex == 0) || (form.filterName.value != filterListStartup[filterIndex].name)) {
    if (isACLExist(form.filterName.value)) {
      var msgFormatedStr = replacedString(chkACLListe,form.filterName.value);
      alert(msgFormatedStr);
      //alert(warning162 + form.filterName.value + warning194); //1173  1203
      return cmd;
    }
  }
  
  if  ((form.filterList.selectedIndex != 0) && isFilterUsed(filterListStartup[filterIndex].name) && (form.filterName.value != filterListStartup[filterIndex].name)) {
     var msgFormatedStr = replacedString(createFilterListe,filterListStartup[filterIndex].name);
     alert(msgFormatedStr);
     //alert(warning162 + filterListStartup[filterIndex].name + warning195); //1173 1204
     return cmd;
  }
  
  if (!checkFilterIndex()) {
      return cmd;
  }

  if ((filterListRunning.element.length == filterListStartup[filterIndex].element.length) && (form.filterName.value == filterListStartup[filterIndex].name)) {
    for (i=0; i < filterListRunning.element.length; i++) {
      if (filterListRunning.element[i].command != filterListStartup[filterIndex].element[i].command)
        break;
    }
    if (i == filterListRunning.element.length) {
      cmd ="";
      return cmd;
    }
  }

  if (form.filterList.selectedIndex != 0) {
    cmd += "no access-list " + filterListStartup[filterIndex].name + "[configure]\n";
  }

  for (i=0; i < filterListRunning.element.length; i++) {
    cmd += "access-list " +  form.filterName.value + " " + filterListRunning.element[i].command + "[configure]\n";
  }
  //alert("cmd is "+cmd);
  return cmd;
}

function deleteFilterCmd() {
  var form = document.forms[0];
  var i, cmd="";

  if (filterIndex == 0) {
    alert(warning164); //1175
    return cmd;
  }

  if (isFilterUsed(filterListStartup[filterIndex].name)) {
    alert(warning196); //1205
    return cmd;
  }

  cmd = "no access-list " + filterListStartup[filterIndex].name + "[configure]\n";
  
  return cmd;
}
