PROGRAM explanet;
(*-----------------------------------------------------------*)
CONST  planet:ARRAY(.1..5.) OF STRING(.8.)=
                  ('JUPITER','SATURNUS','URANUS','NEPTUNUS','PLUTO');
       interval:ARRAY(.1..5.) OF Integer=(160,320,800,1600,2400);             

TYPE
       arr=ARRAY(.-2..3.) OF Real;
       
VAR
       x,y,z:arr;
       radius,alpha,delta:arr;
       rad,alph,del,dt   :Real;
       xsol,ysol,zsol,jd:Real;
       julcent,jul0,p:Real;
       xplanet,yplanet,zplanet:Real;
       date,epsilon:Real;
       deleps,delfi,dx,dy,dz:Real;
       trueeps:Real;
       i,j   :Integer; 
       ch   :Char;
(*--------------------------------------------------*)
FUNCTION moddy(x,y:Real):Real;
VAR   z:Integer;
BEGIN
  z:=Trunc(x/y); IF x<0 THEN z:=z-1; 
  moddy:=x-y*z;
END;
(*--------------------------------------------------*)
FUNCTION julday:Real;
VAR
  year,month,day:Integer;
  century,excess:Integer;
  jul,hour:Real;
  ch:Char;

BEGIN
  Write('Calendar (julian (j), gregorian(g)'); Readln(ch);
  Writeln;
  Write('Year     : '); Readln(year);
  Write('Month    : '); Readln(month);
  Write('Day      : '); Readln(day);
  IF month<3 THEN
    BEGIN
      month:=month+9;
      year:=year-1;
    END
  ELSE
    month:=month-3;
  century:=year DIV 100;
  excess:=year MOD 100;
  jul:=INT(1461.0*excess/4.0)+INT((153.0*month+2.0)/5.0)+day;
  IF ch='g' THEN
    jul:=jul+INT(146097.0*century/4.0)-693901.5  (*1721118.5*)  
  ELSE  
    jul:=jul+INT(146100.0*century/4.0)-693903.5; (*1721116.5*)      
  IF year<0 THEN jul:=jul-1;
  Write('Hour (ET): ');Readln(hour);
  julday:=jul+hour/24.0;
END;
(*-----------------------------------------------------*)
PROCEDURE sol;
VAR 
  long,anomaly:Real;
  gt,gv,gm,gj,gs,omega,d:Real;  
  pix,c,cv,a,radius_vector:Real;
  bmoon,pimoon,pisol,moonanomaly,moonlom,moonlong,lat:Real;  
  gammap:Real;

BEGIN
  pix:=Pi/180.0;
  jd:=julday;
  julcent:=jd/36525.0;
  long:=279.696678+(36000.768925+3.025E-4*julcent)*julcent;
  anomaly:=358.475833+(35999.04975+julcent*(-1.5E-4-julcent*3.3E-6))*julcent;
  long:=moddy(long,360.0); anomaly:=moddy(anomaly,360.0);  
  gt:=anomaly*pix;
  gv:=(212.60+moddy(58517.804*julcent,360.0))*pix;
  gm:=(319.53+moddy(19139.859*julcent,360.0))*pix;
  gj:=(225.34+moddy( 3034.692*julcent,360.0))*pix;
  gs:=(175.48+moddy( 1221.553*julcent,360.0))*pix;
  omega:=((1266E-25*jd+432630E-20)*jd-1.47094228332E-4)*jd+0.71995354167;
  omega:=moddy(omega,1.0);    
  d:=((1077E-25*jd-299023E-20)*jd+0.033863192198393)*jd+0.97427079475;
  d:=moddy(d,1.0);
  moonlong:=(d*360.0+long);
  gammap:=334.329556+jd*(0.11140400803+jd*(-7.739E-12-jd*2.6E-19));
  gammap:=moddy(gammap,360.0); 
  moonanomaly:=(moonlong-gammap)*pix;
  moonlom:=(moonlong-omega*360.0)*pix;
  c:=Sin(gt)*(1.9194602-julcent*(4.789E-3+julcent*1.4E-5))+
     Sin(2*gt)*(2.0093E-2-julcent*1.003E-4)+
     Sin(3*gt)*2.928E-4;
  
  cv:=4.838*Cos(299.1*pix+gv-gt)+5.526*Cos(148.31*pix+2*(gv-gt))+
      2.497*Cos(315.94*pix+2*gv-3*gt)+1.559*Cos(345.25*pix+3*gv-4*gt)+
      1.024*Cos(318.15*pix+3*gv-5*gt)+2.043*Cos(343.89*pix-2*gm+2*gt)+
      1.770*Cos(200.40*pix-2*gm+  gt)+7.208*Cos(179.53*pix-  gj+  gt)+
      2.600*Cos(263.22*pix     -  gj)+2.731*Cos( 87.14*pix-2*gj+2*gt)+
      1.610*Cos(109.49*pix-2*gj+  gt);
  c:=c+cv/3600.0;
  a:=3057.0-15.0*julcent+Cos(gt)*(-727412.0+julcent*(1814.0+julcent*5.0))+
                       Cos(2*gt)*(-9138.0+julcent*46.0)+
                       Cos(3*gt)*(-145.0 +julcent)+
     235.9*Cos(209.10*pix+  gv-  gt)+ 16.0*Cos( 58.40*pix+2*gv-  gt)+
     684.2*Cos( 58.32*pix+2*gv-2*gt)+ 86.9*Cos(226.70*pix+2*gv-3*gt)+
     104.5*Cos( 87.57*pix+3*gv-3*gt)+149.7*Cos(255.25*pix+3*gv-4*gt)+
      19.4*Cos( 49.50*pix+3*gv-5*gt)+ 37.6*Cos(116.38*pix+4*gv-4*gt)+
      19.6*Cos(105.20*pix+4*gv-5*gt)+ 16.3*Cos(145.40*pix+5*gv-5*gt)+
      14.1*Cos(105.40*pix+5*gv-7*gt)+ 15.0*Cos(127.70*pix-  gm+  gt)+
     205.7*Cos(253.83*pix-2*gm+2*gt)+ 15.1*Cos(295.00*pix-2*gm+  gt)+
      16.8*Cos(203.50*pix-3*gm+3*gt)+ 21.5*Cos(249.00*pix-3*gm+2*gt)+
      47.8*Cos( 15.17*pix-4*gm+3*gt)+ 10.5*Cos( 65.90*pix-4*gm+2*gt)+
      10.7*Cos(324.60*pix-5*gm+4*gt)+ 13.9*Cos(137.30*pix-6*gm+4*gt)+
      20.8*Cos(112.0 *pix-  gj+2*gt)+706.7*Cos( 89.55*pix-  gj+  gt)+
      24.4*Cos(338.6 *pix-  gj     )+ 10.3*Cos(350.5 *pix-2*gj+3*gt)+
     145.9*Cos( 19.47*pix-2*gj+  gt)+402.6*Cos(357.11*pix-2*gj+2*gt)+
      28.1*Cos( 81.2 *pix-3*gj+3*gt)+ 80.3*Cos(352.56*pix-3*gj+2*gt)+ 
      17.4*Cos(  8.6 *pix-3*gj+  gt)+ 11.3*Cos(347.7 *pix-4*gj+2*gt)+
      42.9*Cos( 10.60*pix-  gs+  gt)+ 16.2*Cos(200.6 *pix-2*gs+2*gt)+
      11.2*Cos(203.1 *pix-2*gs+  gt); 
 
  bmoon:=5.15*Sin(moonlom)*pix;
  pimoon:=3423*(1.0+0.0549*Cos(moonanomaly));
  pisol :=8.8/Exp(a*1.0E-8*Ln(10));
  c:=c+6.454*Sin(2.0*Pi*d)/3600.0;
  a:=a+526732.0*pisol/pimoon*Cos(bmoon)*Cos(2.0*Pi*d);
  cv:=pix*(231.19+ 20.20*julcent);   c:=c+1.78E-3*Sin(cv);
  cv:=pix*( 57.24+150.27*julcent);   c:=c+(5.23E-4-4.4E-6*julcent)*Sin(cv);
  radius_vector:=Exp(a*1.0E-8*Ln(10));
  long:=long+c;
  lat:=2501.6*pisol/pimoon*Sin(bmoon)/3600.0*pix;
  xsol:=radius_vector*Cos(long*pix)*Cos(lat);
  ysol:=radius_vector*Sin(long*pix)*Cos(lat);
  zsol:=radius_vector*Sin(lat);
  deleps:=9.21*Cos(2*Pi*omega)/3600.0*Pi/180.0;
  delfi :=-17.23*Sin(2*Pi*omega)/3600.0*Pi/180.0;
END;  
(*-------------------------------------------------------*)
PROCEDURE xyztorad(x,y,z:Real;VAR r,a,d:Real);
BEGIN
  r:=Sqrt(x*x+y*y+z*z);
  d:=Arctan(z/Sqrt(x*x+y*y));
  IF x=0 THEN a:=Pi/2.0 ELSE a:=Arctan(y/x);
  IF a<0 THEN a:=a+Pi;
  IF y<0 THEN a:=a+Pi;
END;    
(*-------------------------------------------------------*)
PROCEDURE radtoxyz(r,a,d:Real; VAR x,y,z:Real);
BEGIN
  x:=r*Cos(a)*Cos(d);
  y:=r*Sin(a)*Cos(d);
  z:=r*Sin(d);
END;    
(*-------------------------------------------------------*)
PROCEDURE eclodate(date:Real;VAR x,y,z:Real);
VAR 
  dx,dy,dz:Real;
  d,xx,xy,xz,yx,yy,yz,zx,zy,zz:Real;
BEGIN
  d:=date/10000.0;
  xx:=(-2.0+d*(125.5+d*(-2226.6-0.3*d)))*1E-8;
  yx:=(17251+d*(-611903.6+d*(-51.1+4.5*d)))*1E-8;
  zx:=(7500+d*(-266040.8+d*(15.3+2.0*d)))*1E-8;
  xy:=(-18811.0+d*(667235.6+d*(40.8-4.9*d)))*1E-8;
  yy:=(-8256376.0+d*(2589.4+d*(-2041.5-0.3*d)))*1E-8;
  zy:=(39788279.0+d*(-5655.1-d*887.8))*1E-8;
  xz:=(-17+d*(608.4+d*7.1))*1E-8;
  yz:=(-39788279.0+d*(5705.2-1.7*d))*1E-8;
  zz:=(-8256375.0+d*(2474.4+d*(-0.9-0.1*d)))*1E-8;
  dx:=xx*x+yx*y+zx*z;
  dy:=xy*x+yy*y+zy*z;
  dz:=xz*x+yz*y+zz*z;
  x:=x+dx;  y:=y+dy;   z:=z+dz;
END;        
(*----------------------------------------------------*)
PROCEDURE rotate(angle:Real;VAR x,y,z:Real);
VAR temp:Real;
BEGIN
  temp:= y*Cos(angle)+z*Sin(angle);
  z   :=-y*Sin(angle)+z*Cos(angle);
  y   :=temp;
END;
(*----------------------------------------------------*)
FUNCTION product(x:Real;i:Integer):Real;
VAR temp:Real;
       j:Integer;
BEGIN
  temp:=1.0;
  FOR j:=-2 TO 3 DO
    IF j<>i THEN temp:=temp*(x-j);
  product:=temp;
END;    
(*-----------------------------------------------------*)
FUNCTION lagrange(x:Real;VAR a:arr):Real;
(*Lagrange 6 point interpolation*)
BEGIN
  lagrange:=-product(x,-2)*a(.-2.)/120+product(x,-1)*a(.-1.)/24
            -product(x,0) *a(. 0.)/12 +product(x, 1)*a(. 1.)/12
            -product(x, 2)*a(. 2.)/24 +product(x, 3)*a(. 3.)/120;
END;
(*----------------------------------------------------*)       
PROCEDURE indata;
BEGIN
  Writeln('Choose planet number:');
  FOR i:=1 TO 5 DO Writeln(planet(.i.):10,i:5);
  Readln(j); Write(Clrhom); Initturtle; Cursoron;
  sol; jd:=jd+2415020.0;
  dt:=24+julcent*(72.318+29.950*julcent);
  Write('ET-UT=',dt/60:4:0,' min');
  jul0:=INT(jd/interval(.j.))*interval(.j.)+0.5;
  Moveto(300,300); Charsize(5); Writestr(planet(.j.));
  IF j=1 THEN BEGIN
  x(.-2.):=-3.920312104; y(.-2.):=3.290630754; z(.-2.):=1.509022976;
  x(.-1.):=-4.648571490; y(.-1.):=2.443749790; z(.-1.):=1.163390277;
  x(.0.) :=-5.151291912; y(.0.) :=1.478083047; z(.0.) :=0.761218040;
  x(.1.) :=-5.408644672; y(.1.) :=0.441868412; z(.1.) :=0.322725948;
  x(.2.) :=-5.411611199; y(.2.):=-0.615210184; z(.2.):=-0.130979667;
  x(.3.) :=-5.161678984; y(.3.):=-1.643563296; z(.3.):=-0.578574623;END
  ELSE BEGIN
  x(.-2.):=-26.642175524; y(.-2.):=12.793359248; z(.-2.):=5.910898398;
  x(.-1.):=-28.633510677; y(.-1.):= 8.523783988; z(.-1.):=4.211809099;
  x(.0.) :=-29.838386119; y(.0.) := 4.035993381; z(.0.) :=2.403841198;
  x(.1.) :=-30.235402515; y(.1.) :=-0.573762427; z(.1.) :=0.525366258;
  x(.2.) :=-29.791019927; y(.2.) :=-5.166312218; z(.2.):=-1.367142026;
  x(.3.) :=-28.547416132; y(.3.) :=-9.609741998; z(.3.):=-3.218456876;END;
  Gotoxy(0,7);Write('  Jul day            X               Y               Z');
  FOR i:=-2 TO 3 DO
    BEGIN
      (*Gotoxy(0,10+i);Write((jul0+i*interval(.j.)):10:1); 
      Gotoxy(16,10+i); Read(x(.i.));
      Gotoxy(32,10+i); Read(y(.i.));
      Gotoxy(48,10+i); Read(z(.i.));*)
      xyztorad(x(.i.),y(.i.),z(.i.),radius(.i.),alpha(.i.),delta(.i.)); 
    END;
  FOR i:=-1 TO 3 DO
    IF alpha(.i.)<alpha(.i-1.) THEN alpha(.i.):=alpha(.i.)+2*Pi;
END;
(*-----------------------------------------------------*)
(*-------------      MAIN PROGRAM   -------------------*)
(*-----------------------------------------------------*)
BEGIN
  Write(Clrhom);
  indata;  
  Gotoxy(0,7);Write(Clreos);Gotoxy(0,8); 
  REPEAT
    p:=(jd-jul0)/interval(.j.);
    IF (p<-2) OR (p>3) THEN 
      Writeln('WARNING! Date outside interpolation limits');
    alph:=lagrange(p,alpha);
    del :=lagrange(p,delta);     
    rad :=lagrange(p,radius);
    radtoxyz(rad,alph,del,xplanet,yplanet,zplanet); 
    date:=jd-2433000.5;
    eclodate(date,xplanet,yplanet,zplanet);
    epsilon:=23.452294+julcent*(-0.01301+julcent*(-1.64E-6+julcent*5.03E-7));
    epsilon:=epsilon*Pi/180.0;
    xplanet:=xplanet+xsol;
    yplanet:=yplanet+ysol;
    zplanet:=zplanet+zsol;
    rotate(-epsilon,xplanet,yplanet,zplanet);
    trueeps:=epsilon+deleps;
    dx:=-(yplanet*Cos(trueeps)+zplanet*Sin(trueeps))*delfi;
    dy:=xplanet*Cos(trueeps)*delfi-zplanet*deleps;
    dz:=xplanet*Sin(trueeps)*delfi+yplanet*deleps;
    xplanet:=xplanet+dx; yplanet:=yplanet+dy; zplanet:=zplanet+dz;
    xyztorad(xplanet,yplanet,zplanet,rad,alph,del);
    Writeln('R A : ',alph*180.0/Pi:8:3,'  Dekl: ',del*180.0/Pi:8:3);
    dx:=Sqrt(Sqr(xplanet)+Sqr(yplanet)+Sqr(zplanet));
    Writeln('Distance :',dx:10:5);
    Write('Correction factor for aberration :',-dx*0.0057683:5:2);
    Writeln('*dayly motion');    
    Write('New date=');
    Read(KBD,ch); Writeln;
    IF ch<>'' THEN HALT;
    sol; jd:=jd+2415020.0;
  UNTIL False;
END.    
(****************************************************************)}3                      COMPIS SCANDIS/H1IS            PY                   E      J      