        
              (*  Betygsprogram V 2.5  1986-05-27 *)
              (*    Ivar H{ssler Tel 035/126338   *)
               
(*$C-*)
(* Kan ej avbrytas med <CTRL> 'C' *)

Program betyg;

  Type str8=String(.8.);                (* filnamn *)
       namnstr=String(.28.);            (* namn *)
       klassreg=Record
                  Namn:namnstr;
                  Prov:Array(.1..6.) Of String(.5.);
                End;

  Const Sk='Kattegattskolan';(* Aktuella namn och {mnen inpassas *)
        L='Ingvar Johansson';(* Gl|m ej att ange antal {mnen  *)
        antal_amnen=3;                (* B|rja med stor bokstav i {mnet *)
        am: Array(.1..antal_amnen.)Of namnstr=
                                    ('Matematik','Fysik','Datakunskap');

        enh='A:';(* Enhet (Volym) d{r du har dina datafiler. Om enh='' anv{nds
                    samma volym som du har n{r programmet BETYG k|rs.
                     
                    Ram-minnet enh='M:' ger snabb filhantering,
                    men varje g}ng du har slagit av str|mmen eller gjort reset
                    m}ste M: formateras. 
                    Du kan heller inte anv{nda ram-minnet om maskinen har 
                    mindre arbetsminne {n 256 kByte.
                    Du m}ste ocks} uppdatera disketten innan du avslutar *)

  Var  utfil         :Text;     (* f|r att kunna v{lja printer eller sk{rm *)
       ny_klass,                   
       printer,
       escape        :Boolean;  (* ESC avbryter *)
       ch,pr,mval    :Char;
       klassfil      :File Of klassreg;
       elev          :Array(.0..100.) Of klassreg;
       grens         :Array(.1..4,1..6.) Of Real; 
       klass         :Array(.1..6.)Of Str8;
       amnet         :Array(.1..6.)Of namnstr;  (* aktuellt {mnesval *)
       p_nr,k_nr,                               (* provnr, klassnr, elevnr *)
       e_nr,antal_e,
       i,j           :Integer;     
       bs,                                      (* back-space *)
       feton,fetoff,
       uon,uoff,
       stor,normal,                     (* text typer sk{rm eller printer *)
       elite,pica,liten,
       re_set        :String(.3.);
   Procedure utskriftsval;
     Begin     
       Write(ClrHom);
       GotoXY(20,12);Write(Rvson,'Printer J/N ? :');Read(Kbd,pr);
       If pr=@27 Then
         Begin
           escape:=True;
           Exit;
         End
       Else escape:=False;    
       GotoXY(20,12);Write('S{tt p} den d} !',Rvsoff);
       If pr In(.'J','j'.) Then 
         Begin
           Assign(utfil,'lst:');
           printer:=True;
           Writeln(lst);
           uon:=@27+'X'; uoff:=@27+'Y';
           liten:=@27+'Q'; stor:=@14;
           normal:=@15; re_set:=@27+'c1';
           bs:=@8;
         End
       Else     
         Begin
           Assign(utfil,'con:');
           printer:=False;
           uon:=Ulnon; uoff:=Ulnoff;
           liten:=Intoff; stor:=Inton;
           normal:=Intoff; re_set:=Intoff;
           bs:=@8;
         End;  
       Reset(utfil);
       Write(ClrHom);
     End;(* utskriftsval *)

   Procedure lasin(Var namn:str8);      (* Inl{sningsprocedur f|r filnamn *)
              Var ch  :Char;
              Begin
                escape:=False;              
                namn:='';
                Repeat              
                  Repeat
                    Read(Kbd,ch);
                  Until ch In(.'A'..'Z','a'..'z','0'..'9',@13,@8,@27.);
                  If ch=@27 Then
                    Begin
                      escape:=True;
                      Exit;
                    End;  
                  If ch=@8 Then
                    Begin
                      If len(namn)>0 Then 
                        Begin
                           Write(@8,' ',@8);
                           Delete(namn,len(namn),1);
                        End;
                    End    
                  Else If len(namn)<8 Then
                         Begin
                           Write(ch);  
                           namn:=namn+ch;
                         End;  
                Until (ch=@13) And (len(namn)>0);
                Delete(namn,len(namn),1);
              End; (* lasin *)    

   Procedure lastext(filnamn:namnstr);  (* Inl{sning av textfil *)
      Var infil       :Text;
         radnr,
         antal_rader :Integer;
         ch          :Char;
         rad         :Array(.1..200.) Of String(.80.);

     Procedure till; 
       Begin
         radnr:=radnr+1;
         GotoXY(80,23);
         Writeln;
         Writeln(rad(.radnr+22.),ClrEol);
         GotoXY(0,0);Write(Rvson,'Scrolla med pil-upp-ned b|rjan=s|k slutet=',
         @130,'. Avbryt med avbryt-tangent.',Rvsoff,ClrEol);
       End;(* till *)

     Procedure ny_sida(nr:Integer);
       Var i:Integer;
       Begin
         GotoXY(0,1);Write(ClrEos);
         For i:=nr To nr+22 Do Writeln(rad(.i.));
       End;
       
     Procedure init;
       Begin
         Assign(infil,filnamn);
         Reset(infil);
         radnr:=0;
         While Not Eof(infil) Do
           Begin
             radnr:=radnr+1;
             Readln(infil,rad(.radnr.));
           End;
         Close(infil);  
         antal_rader:=radnr;
         Write(ClrHom,Rvson,'Scrolla med pil-upp-ned b|rjan=s|k slutet=',@130,
         '. Avbryt med avbryt-tangent.',Rvsoff);
         radnr:=1;
         ny_sida(radnr);  
       End;(* Init *)  
     
     Procedure scrolla;
       Begin
         GotoXY(70,0);Write('<=');
         Read(Kbd,ch);
         Case ch Of  (* s|k= b|rjan *) @142  : If radnr>1 Then 
                                                 Begin
                                                   radnr:=1;
                                                   ny_sida(1);
                                                 End;  
                     (* ?= slutet *)   @130  :If radnr+22<antal_rader-1 Then
                                                 Begin
                                                   radnr:=antal_rader-22;
                                                   ny_sida(radnr);
                                                 End
                                              Else If radnr+22<antal_rader Then
                                                 till;
                          (* upp-pil *) @139 : If radnr>5 Then 
                                                 Begin
                                                   radnr:=radnr-5;
                                                   ny_sida(radnr);
                                                 End
                                               Else If radnr>1 Then
                                                      Begin  
                                                        radnr:=radnr-1;
                                                        ny_sida(radnr);
                                                      End;  
                               (* ned-pil *) @133 : If radnr+22<antal_rader 
                                                 Then till;
                      (* avbryt *)@27,@140 : Write(ClrHom);
                                   Otherwise Write(@7);
         End;(* Case *)
       End;(* scrolla *) 

  (*-------------------------------------------------------------------*)

            Begin(* lastext *)
              init;
              Repeat
                scrolla;
              Until(ch=@140)Or(ch=@27);  
            End;(* lastext *)
 
   (*------------------------------------------------------------------*)
   
   Procedure tecken(n:Integer;ch:Char);  (* Upprepning av tecken *)
    Var i:Integer;
    Begin
      For i:=1 To n Do Write(ch);
    End;
 
   Procedure h_meny;
    Begin
      Write(ClrHom);
      GotoXY(0,5);
      Writeln('                     ***********************************');
      Writeln('                     **                               **');
      Write('                     **           ',Ulnon,'Huvudmeny',Ulnoff);
      tecken(11,' ');Writeln('**');
      Writeln('                     **                               **');
      Writeln('                     **     E Elevnamn                **');
      Writeln('                     **                               **');
      Writeln('                     **     L Listanamn               **');
      Writeln('                     **                               **');
      Writeln('                     **     P Provpo{ng               **');
      Writeln('                     **                               **');
      Writeln('                     **     R Resultat                **');
      Writeln('                     **                               **');
      Writeln('                     **     H Hj{lp (Information)     **');
      Writeln('                     **                               **');
      Writeln('                     **     A Avsluta                 **');
      Writeln('                     **                               **');
      Writeln('                     ***********************************');
    End;(* h_meny *)
 
     Procedure g_klass_in;   (* Gammal klass in *)
       Begin
         ny_klass:=False;
         Write(ClrHom);
         k_nr:=1;
         Repeat
           GotoXY(20,15);Write('Klass :........');
           GotoXY(27,15);lasin(klass(.k_nr.));
           If escape Then Exit;
           Assign(klassfil,enh+klass(.k_nr.));
           (*$I- *)
           Reset(klassfil);
           (*$I+ *)
         Until Iores=0;
         For e_nr:=1 To 32 Do 
           With elev(.e_nr.) Do 
             Begin
              namn:='';
              For p_nr:=1 To 6 Do prov(.p_nr.):='';
             End; 
         e_nr:=0;
         Read(klassfil,elev(.0.));
         While Not Eof(klassfil) Do
           Begin
             e_nr:=e_nr+1;
             Read(klassfil,elev(.e_nr.));
           End;  
         antal_e:=e_nr;  
         Close(klassfil);
       End;(* g_klass_in *)
 
     Procedure elevnamn;
        Label gammal;(* Om man k|r ny klass av misstag *)
        
        Var ch       :Char;
            k,r,        (* kolumn och rad *)
            rad,        (* aktuell rad *)
            j,          (* r{knare f|r uppdatering av lista *)
            po          (* aktuell position i namn *)
                                        :Integer;
            a_namn(* aktuellt namn *)   :namnstr;
   
        Procedure skrivny(r,i:Integer);  (* skriver aktuellt namn *)
          Begin       
            If r<24 Then 
              Begin
                GotoXY(5,r);Write(i:2,' ............................');
                GotoXY(8,r);Write(a_namn);
              End;
          End;(* skrivny *)
   
         Procedure edit;
          Begin
            e_nr:=1;         
            skrivny(r,e_nr);
            GotoXY(k,r);
            Read(Kbd,ch);
            While Not((ch=@13)And(a_namn='')) Do
            Begin
                Case ch Of
                '@'..']','`'..'}','-',' ' :
                If po<=28 Then
                  Begin
                    Insert(ch,a_namn,po);
                    skrivny(r,e_nr);           
                    po:=po+1;
                    k:=k+1;
                    GotoXY(k,r);
                  End;(* Ins{ttning av tecken *)
   
                 (* Radertangent *)       @8 :
                If po>1 Then
                  Begin
                    k:=k-1;
                    po:=po-1;
                    Delete(a_namn,po,1);
                    skrivny(r,e_nr);
                    GotoXY(k,r);
                  End;(* Radertangent *)       
   
                 (* Return *)            @13 :
                Begin
                  If e_nr=antal_e+1 Then antal_e:=antal_e+1;(* antal namn *)
                  elev(.e_nr.).namn:=a_namn;
                  a_namn:='';k:=8;po:=1;
                  If antal_e<=15 Then 
                     Begin
                       If e_nr=antal_e+1 Then
                         Begin
                           r:=r+1;
                           skrivny(r,e_nr);
                         End
                       Else
                         Begin
                           e_nr:=antal_e+1;
                           r:=antal_e+8;
                           skrivny(r,e_nr);
                         End;  
                     End  
                   Else 
                     Begin
                       r:=8;e_nr:=antal_e+1;
                       For j:=e_nr-15 To e_nr-1 Do
                         Begin
                           a_namn:=elev(.j.).namn;
                           skrivny(r,j);
                           r:=r+1;
                         End;
                       a_namn:='';  
                       skrivny(r,e_nr);
                     End;  
                End;(* Return *)
   
                (* V{nster-pil *)      @135 :
               If po>1 Then
                 Begin
                   po:=po-1;
                   k:=k-1;
                   GotoXY(k,r)  
                 End;
   
                (* H|ger-pil *)        @137 :
               If po<len(a_namn)+1 Then
                 Begin
                   po:=po+1;
                   k:=k+1;          
                   GotoXY(k,r);
                 End;
   
                (* Upp-pil *)          @139 :
               If e_nr>1 Then
                 Begin
                   elev(.e_nr.).namn:=a_namn;
                   e_nr:=e_nr-1;
                   a_namn:=elev(.e_nr.).namn;
                   j:=e_nr;
                   r:=r-1;
                   k:=8;po:=1;
                   If r<8 Then
                     Begin  
                       r:=8;
                       While(r<=23)And(j<=antal_e) Do
                         Begin
                           a_namn:=elev(.j.).namn;
                           skrivny(r,j);
                           r:=r+1;j:=j+1;
                         End;
                       r:=8;
                       GotoXY(k,r);
                       a_namn:=elev(.e_nr.).namn;
                     End
                     Else GotoXY(k,r);
                   If (e_nr=antal_e+1) And (a_namn<>'') 
                     Then antal_e:=antal_e+1;  
                 End;(* Upp-pil *)    
   
                 (* Ned-pil *)          @133 :
                If e_nr<antal_e+1 Then
                  Begin
                    elev(.e_nr.).namn:=a_namn;
                    e_nr:=e_nr+1;r:=r+1;k:=8;po:=1;
                    If r>23 Then
                      Begin
                        r:=8;
                        For j:=e_nr-15 To e_nr-1 Do
                          Begin
                            a_namn:=elev(.j.).namn;
                            skrivny(r,j);
                            r:=r+1;
                          End;
                      End;
                    a_namn:=elev(.e_nr.).namn;
                    skrivny(r,e_nr);
                    GotoXY(k,r);
                  End;(* Ned pil *) 

                  (* Utpl}na *)          @143 :
                Begin
                  Delete(a_namn,po,1);
                  skrivny(r,e_nr);
                  GotoXY(k,r);
                End;

              (* In ny elev *)          @9:
                Begin
                  For j:=antal_e+1 Downto e_nr+1 Do elev(.j.):=elev(.j-1.);
                  For p_nr:=1 To 6 Do elev(.e_nr.).prov(.p_nr.):='';
                  antal_e:=antal_e+1;
                  rad:=r;k:=8;po:=1;
                  r:=r+1;j:=e_nr+1;
                  While (j<=antal_e) And (r<=23) Do
                    Begin
                      a_namn:=elev(.j.).namn;
                      skrivny(r,j);
                      r:=r+1;j:=j+1;
                    End;
                  a_namn:='';r:=rad;
                  skrivny(r,e_nr);
                  GotoXY(k,r);
                End;(* In ny elev *)      

              (* Bort elev *)           @2:
                Begin 
                  antal_e:=antal_e-1;
                  For j:=e_nr to antal_e Do elev(.j.):=elev(.j+1.); 
                  For p_nr:=1 To 6 Do elev(.antal_e+1.).prov(.p_nr.):='';
                  r:=8;k:=8;po:=1;
                  If antal_e>16 Then 
                    Begin
                      For j:=antal_e-14 To antal_e Do
                        Begin
                          a_namn:=elev(.j.).namn;
                          skrivny(r,j);
                          r:=r+1;
                        End;
                    End
                  Else
                    Begin
                      For j:=1 To antal_e Do
                        Begin
                          a_namn:=elev(.j.).namn;
                          skrivny(r,j);
                          r:=r+1;    
                        End;
                    End;      
                  e_nr:=antal_e+1;     
                  a_namn:='';  
                  skrivny(r,e_nr);
                End;(* bort elev *)
              Otherwise Write(@7); (* Tut om fel *)
              End;(* Case *)
            Read(Kbd,ch);
          End;(* While *) 
          If ny_klass Then
            Begin
              Reset(klassfil);
              Seek(klassfil,1);
              For j:=1 To antal_e Do Write(klassfil,elev(.j.));
            End
          Else
            Begin
              Rewrite(klassfil);
              For j:=0 To antal_e Do Write(klassfil,elev(.j.));
            End;      
          Close(klassfil);
        End;(* edit *)      

        Procedure namn_text;
          Begin
            Write(ClrHom);GotoXY(20,4);Write('     ',Ulnon,'Ny klass',Ulnoff);
            GotoXY(10,6);Write('Om Du har samma klass i flera {mnen, skapas',
                               ' en fil f|r varja {mne');
            GotoXY(10,7);Write('D} ska Du namnge klassen(filen) med {mnesbe',
                               'teckning t.ex. ');
            GotoXY(10,8);Write(Rvson,'13aMa',Rvsoff,' och ',Rvson,'13aFy',
                                Rvsoff);
          End;(* namn_text *)                                

        Procedure klasstest;
          Begin
            (*$I-*)
            Reset(klassfil);
            (*$I+*)
            If Iores=0 Then
              Begin
                GotoXY(10,11+k_nr);
                Write(Rvson,'Varning !',Rvsoff,' Klassen inlagd!');
                GotoXY(10,12+k_nr);
                Write('Skall denna klass raderas J/N ? :');
                Read(Kbd,ch);
                ny_klass:=(ch In(.'J','j'.));
              End
            Else ny_klass:=True;
          End;(* klasstest *)  

        Procedure klass_namn;
          Label avbryt;(* m}ste avbrytas om klass ej ska raderas *)
          Var am_nr  :1..antal_amnen;                           (* {mnes nr *)
              am_v   :Array(.1..antal_amnen.) Of Boolean;   (* ej valt=True *)
              finns  :Boolean;                           (* finns valt {mne *)
              
          Procedure amne;
            Begin
              If k_nr<antal_amnen Then
                Begin
                  GotoXY(10,10+k_nr);Write(ClrEos,'V{lj ');
                  For am_nr:=1 To antal_amnen Do 
                  If am_v(.am_nr.) Then Write(am(.am_nr.),' ');
                  For am_nr:=1 To antal_amnen Do
                  If am_v(.am_nr.) Then Write(am(.am_nr.)(.1.),'/');
                  Repeat
                    Read(Kbd,ch);
                    If ord(ch)>96 Then ch:=chr(ord(ch)-32);
                    For am_nr:=1 To antal_amnen Do If ch=am(.am_nr.)(.1.)
                                                      Then finns:=True;
                    If finns Then 
                      Begin
                        For am_nr:=1 To antal_amnen Do
                         If am(.am_nr.)(.1.)=ch Then 
                           Begin
                             amnet(.k_nr.):=am(.am_nr.);
                             am_v(.am_nr.):=False;
                           End;  
                      End
                    Else Write(@7);
                  Until finns;       
                End
              Else
                Begin
                  For am_nr:=1 To antal_amnen Do
                    If am_v(.am_nr.) Then amnet(.k_nr.):=am(.am_nr.);
                End;
              elev(.0.).namn:=amnet(.k_nr.);  
            End;(* amne *)   
            
            
          
          Begin
            k_nr:=1;
            finns:=False;
            For am_nr:=1 To antal_amnen Do am_v(.am_nr.):=True;
            Repeat
              amne;
              GotoXY(10,10+k_nr);Write(ClrEos,elev(.0.).namn);
              Repeat
                GotoXY(40,10+k_nr);Write('Klassbeteckning:........');
                GotoXY(56,10+k_nr);
                lasin(klass(.k_nr.));
                If escape Then Exit;
                Assign(klassfil,enh+klass(.k_nr.));
                klasstest;
                If ny_klass=False Then Goto avbryt;
                (*$I- *)
                Rewrite(klassfil);
                (*$I+ *)
              Until Iores=0;
              Write(klassfil,elev(.0.));
              Close(klassfil);
              k_nr:=k_nr+1;
              If k_nr<=antal_amnen Then
                Begin
                  GotoXY(10,10+k_nr);Write(ClrEos,'Fler {mnen med denna klass',
                                     ' J/N ? :');
                  Read(Kbd,ch);
                End;
            Until (k_nr>antal_amnen) Or (Not (ch In(.'J','j'.)));
            avbryt :;
          End;(* klass_namn *)

        Procedure klass_text;
          Begin      
            Write(ClrHom);
            Write('     Klass ');
            For i:=1 To k_nr-1 Do Write(klass(.i.),' ');Write('i ');
            For i:=1 To k_nr-1 Do Write(amnet(.i.),' ');Writeln;
            Write('Skriv efternamn f|rnamn tryck <RETN> f|r n{sta. Avsluta ');
            Writeln('med <RETN> p} ny rad');
            Writeln('Felskrivningar kan raderas eller editeras');
            Writeln('Till}tna tecken:pil-v{nster,-h|ger,-upp,-ned',
                    ' radertangent, utpl}na.');
            Writeln('<Ctrl>"I" Inpassa nytt namn (l{ggs f|re)',
            '        <Ctrl>"B" ta Bort namn');
          End;(* klass_text *)  

        Procedure init_ny_klass;(* Utg}ngsl{ge variabler *)
          Begin
            e_nr:=1;k:=8;r:=8;antal_e:=0;a_namn:='';po:=1;
            For j:=1 To 32 Do 
             With elev(.j.) Do
               Begin
                 namn:='';
                 For p_nr:=1 To 6 Do prov(.p_nr.):='';
               End;  
          End;(* init_ny_klass *)

        Procedure fler_amnen;  
          Begin
           For i:=1 To k_nr-2 Do
             Begin
               Assign(klassfil,enh+klass(.i.));
               Reset(klassfil);
               Seek(klassfil,1);
               For e_nr:=1 To antal_e Do Write(klassfil,elev(.e_nr.));
               Close(klassfil);
             End; 
         End;(* fler_amnen *)    

        Procedure g_klass_text;
          Begin
            Writeln(ClrHom,'       Klass ',klass(.k_nr.),' i ',elev(.0.).namn);
            Writeln;      
            Writeln('<RETN> ger till{gg av namn.Avsluta med <RETN> p} ny rad');
            Writeln;
            Writeln('Till}tna tecken:pil-v{nster,-h|ger,-upp,-ned',
                    ' radertangent, utpl}na.');
            Writeln('<Ctrl>"I" Inpassa nytt namn (l{ggs f|re)',
            '      <Ctrl>"B" ta Bort namn');
          End;(* g_klass_text *)  

        Procedure init_g_klass;
          Begin
            r:=8;k:=8;e_nr:=1;po:=1;
            If antal_e>=16 Then
              Begin
                For j:=1 To 16 Do
                  Begin
                    a_namn:=elev(.j.).namn;
                    skrivny(r,j);
                    r:=r+1;
                  End;  
              End
            Else
              For j:=1 To antal_e Do
                Begin
                  a_namn:=elev(.j.).namn;
                  skrivny(r,j);
                  r:=r+1;
                End;
            r:=8;
            a_namn:=elev(.1.).namn;
          End;(* init_g_klass *)        

          Procedure om_klass;
            Var ch         :Char;
                nytt_namn  :Str8;
            Begin
              Write(ClrHom);GotoXY(20,10);
              Write('    Vill du byta namn p} klassen (J/N) :');
              Read(Kbd,ch);
              If ch In (.'J','j'.) Then
                 Begin
                   Write('Ange nytt namn :');lasin(nytt_namn);
                   If escape Then Exit;
                   Rename(klassfil,nytt_namn);
                   klass(.k_nr.):=nytt_namn;
                 End;              
            End;(* om_klass *)     

   (*------------------------------------------------------------*)

      Begin(* elevnamn *)
        Write(ClrHom);GotoXY(20,12);
        Write(Rvson,'Ny klass J/N  ?:',Rvsoff);
        Read(Kbd,ch);
        If ch=@27 Then Exit;
        If ch In(.'J','j'.) Then
          Begin(* Ny klass *)
            namn_text;
            klass_namn;
            If escape Then Exit;
            If Not ny_klass Then Goto gammal;
            klass_text;
            init_ny_klass;
            edit;
            If k_nr>2 Then fler_amnen;
          End  
        Else
  gammal :Begin(* Gammal klass *)
            g_klass_in;
            If escape Then Exit;
            g_klass_text;
            init_g_klass;
            edit;
            om_klass;
          End;        
      End;(* elevnamn *)    

    (*----------------------------------------------------------*)
    
    (* Procedurerna prov och lista inkluderas *)
                  (*$IL.PAS*)
                  (*$IP.PAS*)
    (******************************************)   
    
  Procedure result;

  Var  st_x          :Array(.0..200.) Of Integer;
       medp,meds     :Array(.1..100.) Of Integer;(* medelpo{ng *)
       es            :Array(.1..100,1..6.) Of String(.8.);(* std-po{ng *)
       pnr           :String(.3.);(* provnummer a-b (fr}n a till b) *)
       hojd,
       antal_p,
       antal_hp,
       a,b,            (* minsta provnr=a st|rsta=b *)
       antal_k,        (* Antal klasser *)
       d_nr,           (* Deltagar_nr (i prov) *)
       fel1,fel2,      (* Fel i Val-instruktionen *)
       min_ms,max_ms,  (* Min & Max medelpo{ng *)
       min_mp,max_mp     :Integer;
       min,max,                                 (* max & min po{ng *)
       smin,smax     :Array(.1..6.) Of Integer; (* max & min stdpo{ng *)
       sum,ksum,                (* Summa vikt,kvadratsumma,po{ngsumma  *)
       psum,r,s,p    :Real;
       med,std,vikt  :Array(.1..6.) Of Real;(* medel,standardavvikelse,vikt *)

     Procedure en_klass_in; 
       Begin
         Write(ClrHom);
         Repeat
           Repeat
             GotoXY(20,15);Write('Klass ',k_nr:2,':........');
             GotoXY(29,15);lasin(klass(.k_nr.));
             If escape Then Exit;
             Assign(klassfil,enh+klass(.k_nr.));
             (*$I- *)
             Reset(klassfil);
             (*$I+ *)
           Until Iores=0;
           If k_nr=1 Then
             Begin
               Read(klassfil,elev(.0.));
               GotoXY(20,17);Write(elev(.0.).namn,'prov');
             End
           Else
             Begin
               Read(klassfil,elev(.e_nr+1.));
               If elev(.e_nr+1.).namn<>elev(.0.).namn Then 
                 Begin
                   GotoXY(20,18);Write(ClrEos);
                   Write('Klassen ',klass(.k_nr.),' har ej ',elev(.0.).namn,
                   ' utan ',elev(.e_nr+1.).namn);
                 End;
             End;(* Else *)    
           Close(klassfil);      
         Until (elev(.0.).namn=elev(.e_nr+1.).namn) Or (k_nr=1);              
         Reset(klassfil);Seek(klassfil,1);
         While Not Eof(klassfil) Do
           Begin
             e_nr:=e_nr+1;
             Read(klassfil,elev(.e_nr.));
           End;  
         Close(klassfil);
         antal_e:=e_nr;
       End;(* en_klass_in *)
     
      Procedure init;
       Begin
         Write(ClrHom);GotoXY(20,12);
         Write('Ange antal klasser (',Rvson,'Max 100 elever',Rvsoff,')');
         GotoXY(20,14);Write('Antal :');
         Repeat
           Write('   ');GotoXY(27,14);
           Read(Kbd,ch);
           If ch=@27 Then
             Begin
               escape:=True;
               Exit;
             End
           Else escape:=False;    
           Val(ch,antal_k,fel1);
         Until (fel1=0) And (antal_k>0);
         For e_nr:=0 To 100 Do With elev(.e_nr.) Do
           Begin
             namn:='';
             For p_nr:=1 To 6 Do prov(.p_nr.):='';
           End;  
         e_nr:=0;
         For k_nr:=1 To antal_k Do en_klass_in;
       End;(* init *)  
       
     Procedure stand;  
      Procedure summa; 
       Begin
          min(.p_nr.):=100;max(.p_nr.):=0;
          d_nr:=0;sum:=0;ksum:=0;
          For e_nr:=1 To antal_e Do
            Begin
              If (elev(.e_nr.).prov(.p_nr.)<>'-') 
              And (elev(.e_nr.).prov(.p_nr.)<>'') Then
                Begin
                  d_nr:=d_nr+1;
                  Val(elev(.e_nr.).prov(.p_nr.),p,j);
                  sum:=sum+p;
                  ksum:=ksum+p*p;
                  If p>max(.p_nr.) Then max(.p_nr.):=Round(p);
                  If p<min(.p_nr.) Then min(.p_nr.):=Round(p);
                End
              Else es(.e_nr,p_nr.):='-';    
            End;
            med(.p_nr.):=sum/d_nr;
            std(.p_nr.):=sqrt((ksum-med(.p_nr.)*med(.p_nr.)*d_nr)/(d_nr-1));
       End;(* summa *)
      
      Procedure spoeng;
       Begin
         smax(.p_nr.):=0;smin(.p_nr.):=100;
         For e_nr:=1 To antal_e Do
          Begin   
            If (elev(.e_nr.).prov(.p_nr.)<>'-') 
            And (elev(.e_nr.).prov(.p_nr.)<>'') Then
              Begin
                Val(elev(.e_nr.).prov(.p_nr.),p,fel1);
                s:=(p-med(.p_nr.))*20/std(.p_nr.)+50;
                Str(s:3:3,es(.e_nr,p_nr.));
                If smax(.p_nr.)<s Then smax(.p_nr.):=Round(s);
                If smin(.p_nr.)>s Then smin(.p_nr.):=Round(s);
              End;
          End;(* For e_nr *)
       End;(* spoeng *) 
     
     Procedure grenser;
       Var g,n  :Integer;
       Begin
         g:=20;
         For n:=1 To 4 Do
           Begin 
             grens(.n,p_nr.):=med(.p_nr.)+std(.p_nr.)/20*(g-50);
             g:=g+20;
           End;
       End;(* grenser *)                  
      
      Begin(* stand *)
        For p_nr:=a To b Do
        Begin
          summa;
          spoeng;
          grenser;
        End;
      End;(* stand *)    
    
    Procedure antal_prov;
      
      Procedure prov_nr_in;
        Begin
          pnr:='';
          Repeat
            Repeat
              Read(Kbd,ch);
              If Not(ch In(.'1'..'6','-',@13,@27,@8.)) Then Write(@7);  
            Until ch In(.'1'..'6','-',@13,@27,@8.);  
            If ch=@27 Then
              Begin
                escape:=True;
                Exit;
              End
            Else escape:=False;
            If ch=@8 Then
              Begin
                If Len(pnr)>=1 Then
                  Begin              
                    Write(@8,' ',@8);
                    Delete(pnr,Len(pnr),1);
                  End;  
              End
            Else
              Begin
                If ch<>@13 Then
                  Begin
                    Write(ch);
                    pnr:=pnr+ch;
                   End;  
              End;     
          Until ch=@13;
        End;(* prov_nr_in *)  
      Begin
        Write(ClrHom);
        GotoXY(20,8);Write(Ulnon,'Ange vilka prov som skall r{knas.',Ulnoff);
        GotoXY(10,10);Write('Skriv t.ex.',
        ' Prov nr :',Rvson,5,Rvsoff,' eller Prov nr :',Rvson,'1-3',Rvsoff);
        GotoXY(10,11);Write('Om du inte vill att prov 2 ska r{knas kan du',
        ' vikta prov 2 med 0!');
        GotoXY(10,12);Write('Prov nr :');
        Repeat
          GotoXY(19,12);Write('     ');
          GotoXY(19,12);
          prov_nr_in;
          If escape Then Exit;
          Val(pnr(.1.),a,fel1);
          If len(pnr)>2 Then Val(pnr(.3.),b,fel2) Else Val(pnr,b,fel2);   
          If (fel1=0) And (fel2=0) And (a>0) And (b<7) Then
            For p_nr:=a To b Do
              Begin
                Val(elev(.1.).prov(.p_nr.),s,fel1);
                If fel1<>0 Then fel2:=1;
                If (Not(elev(.1.).prov(.p_nr.)(.1.) In(.'.','-','0'..'9'.)))
                 Then fel2:=1;
              End;  
        Until (fel1=0) And (fel2=0) And (a<6) And (b<6);
      End;(* antal_prov *)
    
    Procedure medel;
      Begin
        Write(ClrHom);GotoXY(10,12);
        Write('\nskas viktning J/N ? :');Read(Kbd,ch);
        Writeln;
        If ch In(.'J','j'.) Then
          Begin
            For p_nr:=a To b Do
              Begin
                Write('          Viktfaktor f|r prov ',p_nr,'=:');  
                Readln(vikt(.p_nr.));
              End;
          End
        Else For p_nr:=a To b Do vikt(.p_nr.):=1;        
        min_mp:=100;min_ms:=100;max_mp:=0;max_ms:=0;
        For e_nr:=1 To antal_e Do
          Begin
            psum:=0;sum:=0;ksum:=0;
            With elev(.e_nr.) Do
              Begin
                For p_nr:=a To b Do
                  If (elev(.e_nr.).prov(.p_nr.)<>'-') 
                  And (elev(.e_nr.).prov(.p_nr.)<>'') Then
                    Begin
                      Val(prov(.p_nr.),p,fel1);
                      Val(es(.e_nr,p_nr.),s,fel1);
                      psum:=psum+vikt(.p_nr.)*p;
                      ksum:=ksum+vikt(.p_nr.)*s;
                      sum:=sum+vikt(.p_nr.);                             
                    End;
                If sum=0 Then 
                  Begin
                    medp(.e_nr.):=0;
                    meds(.e_nr.):=0;
                  End      
                Else 
                  Begin
                    medp(.e_nr.):=Round(psum/sum);
                    meds(.e_nr.):=Round(ksum/sum);
                  End;  
              End;(* With elev *)
            If min_ms>meds(.e_nr.) Then min_ms:=meds(.e_nr.);  
            If min_mp>medp(.e_nr.) Then min_mp:=medp(.e_nr.);  
            If max_ms<meds(.e_nr.) Then max_ms:=meds(.e_nr.);  
            If max_mp<medp(.e_nr.) Then max_mp:=medp(.e_nr.);  
          End;(* For e_nr *)           
        End;(* medel *)              
        
     
        
     Procedure resultat_meny;
       Begin
         Write(ClrHom);
         GotoXY(12,1);Write(Ulnon,elev(.0.).namn,'prov nr ');
         If a<b Then Write(a,'-',b,' ') Else Write(a,' ');
         For k_nr:=1 To antal_k Do Write(klass(.k_nr.));
         Write(Ulnoff);
         GotoXY(10,3);Write('********************************************');
         GotoXY(10,4);Write('**                                        **');
         GotoXY(10,5);Write('**           ',Ulnon,'Resultat-meny',
         Ulnoff,'                **');
         GotoXY(10,6);Write('**                                        **'); 
         GotoXY(10,7);Write('** R Resultatlista (namn,po{ng och STP)   **');
         GotoXY(10,8);Write('**                                        **'); 
         GotoXY(10,9);Write('** X X-lista (r}po{ng)                    **');
         GotoXY(10,10);Write('**                                        **');
         GotoXY(10,11);Write('** O Ordningslista (namn,STP)             **');
         GotoXY(10,12);Write('**                                        **');
         GotoXY(10,13);Write('** S X-lista (STP)                        **');
         GotoXY(10,14);Write('**                                        **');
         GotoXY(10,15);Write('** V ny Viktning (om flera prov r{knas)   **');
         GotoXY(10,16);Write('**                                        **');
         GotoXY(10,17);Write('** I Information om standardpo{ng (STP)   **');
         GotoXY(10,18);Write('**                                        **');
         GotoXY(10,19);Write('** A Avbryt Resultat                      **');
         GotoXY(10,20);Write('**                                        **');
         GotoXY(10,21);Writeln('********************************************');
       End;(* resultat_meny *)  

    Procedure resultat;
      Var rad   :Integer; (* Radr{knare *)

      Procedure rubrik;
        Begin
          Writeln(utfil,stor,Sk);Writeln(utfil);
          Writeln(utfil,liten,elev(.0.).namn,'prov');
          Write(utfil,re_set);
          If b-a>4 Then Write(utfil,liten);
          Write(utfil,uon,'Klass ');
          For k_nr:=1 To antal_k Do Write(utfil,klass(.k_nr.):5);
          If a<b Then 
            Begin
              Write(utfil,' ':19-antal_k*5);Write(utfil,'Vikt');
              For p_nr:=a To b Do Write(utfil,vikt(.p_nr.):9:2);
              Writeln(utfil,'Medel':8);
            End
          Else Writeln(utfil);
          Write(utfil,uoff);
        End;(* rubrik *)
  
      Procedure tabell;    
        Begin
          rad:=1;
          For e_nr:= 1 To antal_e Do
            With elev(.e_nr.) Do 
              Begin
                rad:=rad+1;
                If (rad=23) And Not(printer) Then 
                  Begin 
                    rad:=1;
                    Read(Kbd,ch);
                  End;
                Write(utfil,namn,' ');
                For j:=len(namn)+1 To 28 Do Write(utfil,'.');
                For p_nr:=a To b Do
                  Begin
                     Write(utfil,prov(.p_nr.):5);
                     Val(es(.e_nr,p_nr.),s,fel1);
                     If prov(.p_nr.)='-' Then Write(utfil,'-':4)
                                Else Write(utfil,Round(s):4);
                  End;(* For p_nr *)
                If a<b Then Write(utfil,medp(.e_nr.):4,meds(.e_nr.):4);  
                Writeln(utfil);  
              End;(* For e_nr *)
            Writeln(utfil);  
            Writeln(utfil,liten,stor,
            'Prov nr    Medel       Standardavvikelse',
            '     =>2    =>3    =>4    =>5');
            For p_nr:=a To b Do 
              Begin
                Write(utfil,p_nr:6,med(.p_nr.):10:2,std(.p_nr.):15:2,'':10);
                For i:=1 To 4 Do Write(utfil,grens(.i,p_nr.):7:1);
                Writeln(utfil);
              End;
            If (Not printer) Then 
              Begin
               Write('Tryck tangent !');
               Read(Kbd,ch);
             End;
            Write(utfil,re_set);
            Close(utfil);
        End;(* tabell *)

    (*----------------------------------------------------------------*)

              Begin (* resultat *)
                utskriftsval;
                If escape Then Exit;
                rubrik;
                tabell;
              End; (* resultat *)    
    
    (*---------------------------------------------------------------*)

       Procedure x_lista;
         Var minsta,
             storsta   :Integer; (* minsta och st|rsta po{ng *)
             halvp     :Boolean; (* finns halvpo{ng som provresultat *)

       Procedure halvpoeng;
           Begin
             halvp:=False;
             If a=b Then 
               For e_nr:=1 To antal_e Do
                 With elev(.e_nr.) Do
                     Begin
                       Val(prov(.a.),s,fel1);
                       If prov(.a.)<>'-' Then 
                         If s<>Int(s) Then halvp:=True;
                     End;
           End;(* halvpoeng *)            

         Procedure flera_prov;
           Begin
             For e_nr:=1 To antal_e Do 
               st_x(.medp(.e_nr.).):=st_x(.medp(.e_nr.).)+1;
             antal_p:=max_mp-min_mp+1;
             minsta:=min_mp;storsta:=max_mp;  
           End;    

         Procedure ett_prov_helpoeng;
           Begin
             For e_nr:=1 To antal_e Do
               With elev(.e_nr.) Do
                 Begin
                   Val(prov(.a.),i,fel1);
                   If prov(.a.)<>'-' Then st_x(.i.):=st_x(.i.)+1;
                 End;
             antal_p:=max(.a.)-min(.a.)+1;       
             minsta:=min(.a.);storsta:=max(.a.);
           End;(* ett prov helpoeng *)

         Procedure ett_prov_halvpoeng;
           Begin (* Ett prov, halvpo{ng *)      
             s:=min(.a.);i:=1;
             While s<=max(.a.) Do
              Begin 
               For e_nr:=1 To antal_e Do
                With elev(.e_nr.) Do 
                 Begin
                   Val(prov(.a.),r,fel1);
                   If prov(.a.)<>'-' Then
                     If r=s Then st_x(.i.):=st_x(.i.)+1;
                 End;
               s:=s+0.5;
               i:=i+1;      
             End;(* While *)
             antal_hp:=i-1;
             minsta:=1;storsta:=i-1;
         End; (* ett prov halvpoeng *)            

         Procedure skriv_x_lista(mi,ma:Integer);
           Var hojd, (* diagramh|jd *)
                  k  :Integer;  

           Procedure halv;
             Begin
               hojd:=0;
               For i:=mi To ma Do If hojd<st_x(.i.) Then hojd:=st_x(.i.);
               For i:=hojd Downto 1 Do
                 Begin
                   For k:=mi To ma Do
                     If st_x(.k.)>=i Then Write(utfil,'*') 
                       Else Write(utfil,' ');
                   Writeln(utfil,'');
                 End;         
               Write(utfil,uon);
               s:=min(.a.);
               For k:=mi To ma Do
                 Begin
                   If (s/5)=Int(s/5) Then Write(utfil,'I') 
                   Else If s<>Int(s) Then Write(utfil,':') 
                        Else Write(utfil,'i');
                   s:=s+0.5;
                 End;
               Writeln(utfil,uoff);
               s:=min(.a.);
               If printer Then 
                 Write(lst,@27,'[');(* skriver ett tecken i taget *)
               For k:=mi To ma Do
                 Begin
                   If (s/5)=Int(s/5) Then Write(utfil,bs,s:2:0) 
                   Else Write(utfil,' ');
                   s:=s+0.5;
                 End;
             End;(* halv *)
 
            Procedure hel;
             Begin
               hojd:=0;
               For i:=mi To ma Do If hojd<st_x(.i.) Then hojd:=st_x(.i.);
               For i:=hojd Downto 1 Do
                 Begin
                   For k:=mi To ma Do
                     If st_x(.k.)>=i Then Write(utfil,'*') 
                     Else Write(utfil,' ');
                   Writeln(utfil,'');
                 End;
               Write(utfil,uon);
               For k:=mi To ma Do 
                 If ((k Mod 5)=0) Then Write(utfil,'I') Else Write(utfil,':');
               Writeln(utfil,uoff);
               If printer Then Write(lst,@27,'[');(* ett tecken i taget *)
               For k:=mi To ma Do 
                 If ((k Mod 5)=0) And (k>mi) Then
                         Write(utfil,bs,k:2) Else Write(utfil,' ');
               Writeln(utfil);
             End;(* hel *)  
          (*----------------------------------------------------------*)
 
           Begin(* skriv_x_lista *)
             utskriftsval;
             If escape Then Exit;
             Writeln(utfil,stor,Sk);Writeln(utfil);
             Write(utfil,liten,'Prov nr :');
             If a<b Then Write(utfil,a,'-',b) Else Write(utfil,a);
             Write(utfil,' i ',elev(.0.).namn,' klass ');
             For k_nr:=1 To antal_k Do Write(utfil,klass(.k_nr.),' ');
             Writeln(utfil,re_set);
             If a<b Then 
               Begin
                 Write(utfil,' Viktning ');
                 For p_nr:=a To b Do Write(utfil,vikt(.p_nr.):2:2,' ');
               End;  
             Writeln(utfil);
             If a=b Then Writeln(utfil,'Medelv{rde=',med(.a.):2:2,
                                 '     Standardavvikelse=',std(.a.):2:2);
             Writeln(utfil);Writeln(utfil);
             If printer Then Write(lst,@27,'[');(* ett tecken i taget *)
              If halvp Then 
                Begin
                  If antal_hp<=80 Then halv 
                  Else 
                    Begin
                      If (antal_hp>136) Or(Not printer) Then 
                        Begin
                          Write(ClrHom,'F}r ej plats ! >80 tecken.',
                          ' Anv{nd printern');
                          printer:=False;
                        End  
                      Else 
                        Begin
                          Write(utfil,liten);
                          halv;
                        End;  
                    End;    
                End
              Else If antal_p<=80 Then 
                     hel 
                   Else 
                     Begin
                       If (antal_p>136) Or (Not printer) Then 
                         Begin
                           Write(ClrHom,'F}r ej plats ! >80 tecken.',
                           'Anv{nd printern');
                           printer:=False;
                         End  
                       Else
                         Begin
                           Write(utfil,liten);
                           hel;    
                         End;  
                     End;    
              Writeln;
              If (Not printer) Then 
                Begin
                 Write('Tryck tangent !');
                 Read(Kbd,ch);
                End;
              Writeln(utfil,re_set);
              Close(utfil);
            End;(* skriv_x_lista *)
 
        (***********************************************************)
 
         Begin (* x_lista *)
           For i:=1 To 100 Do st_x(.i.):=0;(* Nollst{ll x-r{knare *)  
           halvpoeng;
           If a<b Then flera_prov 
           Else 
             If halvp Then ett_prov_halvpoeng Else ett_prov_helpoeng;
           skriv_x_lista(minsta,storsta);                
         End;(* x_lista *)
 
        (***********************************************************)  
 
        Procedure ordn_lista;
         Var p,                 (* R{knare *)
             pn,                (* Avrundad po{ng *)
             rad,kol,
             bredd        :Integer;
             ch           :Char;       
         Procedure flera_prov;
           Begin
             Writeln(utfil,liten,stor,Sk);
             Write(utfil,'Prov nr :',a,'-',b,' i ',elev(.0.).namn,' F|r ');
             For k_nr:=1 To antal_k Do Write(utfil,klass(.k_nr.),' ');
             Write(utfil,' Vikt :');
             For p_nr:=a To b Do Write(utfil,vikt(.p_nr.):4:2,' ');
             Writeln(utfil,normal);
             If printer Then Write(lst,@27,'B');(* radavst}nd 1/8" *)
             rad:=1;
             For p:=max_ms Downto min_ms Do
               Begin
                 rad:=rad+1;
                 If (rad=24) And (Not printer) Then 
                   Begin 
                     Read(Kbd,ch);
                     rad:=0;
                   End;
                 If (p Mod 5)=0 Then Write(utfil,p:2,' -') 
                                Else Write(utfil,'   -');
                 kol:=5;               
                 For e_nr:=1 To antal_e Do 
                     If meds(.e_nr.)=p Then 
                       Begin
                         kol:=kol+len(elev(.e_nr.).namn)+1;
                         If kol<=bredd Then Write(utfil,elev(.e_nr.).namn,'.')
                         Else 
                           Begin 
                             Writeln(utfil);
                             Write(utfil,elev(.e_nr.).namn,'.');
                             kol:=len(elev(.e_nr.).namn)+1;
                           End;
                       End;    
                 Writeln(utfil); 
               End;
           End;(* flera_prov *)
 
          Procedure ett_prov;
           Begin
             Write(utfil,liten,stor,Sk);Writeln(utfil);
             Write(utfil,'Prov nr :',a,' i ',elev(.0.).namn,' F|r ');
             For k_nr:=1 To antal_k Do Write(utfil,klass(.k_nr.),' ');
             Writeln(utfil,normal);
             If printer Then Write(lst,@27,'B');(* radavst}nd 1/8" *)
             rad:=1;
             For p:=smax(.p_nr.)+1 Downto smin(.p_nr.) Do
               Begin
                 rad:=rad+1;
                 If (rad=24) And (Not printer) Then 
                   Begin 
                     Read(Kbd,ch);
                     rad:=0;
                   End;
                 If (p Mod 5)=0 Then 
                 Write(utfil,p:2,' -') Else Write(utfil,'   -');
                 kol:=5;
                 For e_nr:=1 To antal_e Do 
                 If es(.e_nr,a.)<>'-'Then
                   Begin
                     Val(es(.e_nr,a.),s,fel1);
                     pn:=Round(s);
                     If p=pn Then 
                       Begin
                         kol:=kol+len(elev(.e_nr.).namn)+1;
                         If kol<=bredd Then Write(utfil,elev(.e_nr.).namn,'.')
                         Else 
                           Begin 
                             Writeln(utfil);
                             Write(utfil,elev(.e_nr.).namn,'.');
                             kol:=len(elev(.e_nr.).namn)+1;
                           End;
                       End;                    
                   End;  
                 Writeln(utfil); 
               End;            
           End;(* ett_prov *)
     
     (*-------------------------------------------------------------------*)
 
          Begin(* ordn_lista *)
           utskriftsval;
           If escape Then Exit;
           If printer Then bredd:=136 Else bredd:=80;
           If a<b Then flera_prov Else ett_prov;
           Writeln(utfil,re_set);
           If (Not printer) Then 
             Begin
               Write('Tryck tangent !');
               Read(Kbd,ch);
             End;
           Close(utfil);
         End;(* ordn_lista *)  
 
      (*-------------------------------------------------------------------*)
 
        Procedure sx_lista;
         Var k  :Integer;
         
         Procedure rubrik;
           Begin
             Writeln(utfil,stor,Sk);
             Writeln(utfil);
             Write(utfil,liten,'Prov nr:');
             If a<b Then Write(utfil,a,'-',b) Else Write(utfil,a);
             Write(utfil,' i ',elev(.0.).namn,' Klass ');
             For k_nr:=1 To antal_k Do Write(utfil,klass(.k_nr.),' ');
             Writeln(utfil,re_set);
           End;(* rubrik *)  
         
         Procedure skrivprov(min,max:Integer);
           Begin
             hojd:=0;
             For i:=1 To antal_p Do If hojd<st_x(.i.) Then hojd:=st_x(.i.);
             For i:=hojd Downto 1 Do
               Begin
                 For k:= 1 To antal_p Do
                   If st_x(.k.)>=i Then Write(utfil,'*') Else Write(utfil,' ');
                 Writeln(utfil);
               End;
             Write(utfil,uon);
             For k:=min To max Do
               If k Mod 5=0 Then Write(utfil,'I') Else Write(utfil,':');      
             Writeln(utfil,uoff);
             Write(utfil,' ');
             If printer Then Write(lst,@27,'[');(* ett tecken i taget *)
             For k:=min+1 To max Do
               Begin
                 If k Mod 5=0 Then 
                   Begin
                     Write(utfil,bs);
                     If k>=100 Then Write(utfil,bs);
                     Write(utfil,k:2);
                   End
                 Else Write(utfil,' ');
               End;(* For k *)
             Writeln(utfil,re_set);
           End;(* skrivprov *)
         Procedure ett_prov;
           Begin
             Writeln(utfil);
             Writeln(utfil,'Medel=',med(.a.):2:2,
                       ' Standardavvikelse=',std(.a.):2:2);
             Writeln(utfil);
             For i:=1 To 120 Do st_x(.i.):=0;
             For e_nr:=1 To antal_e Do
               If es(.e_nr,a.)<>'-' Then
                 Begin
                   Val(es(.e_nr,a.),r,fel1);
                   i:=Round(r)-smin(.a.)+1;
                   st_x(.i.):=st_x(.i.)+1;
                 End;
             antal_p:=smax(.a.)-smin(.a.)+1;      
             If antal_p>80 Then 
               Begin
                 If printer Then
                   Begin
                     Write(lst,liten);
                     skrivprov(smin(.a.),smax(.a.));
                   End
                 Else Write(ClrHom,'F}r ej plats ! >80 tecken.',
                 ' Anv{nd printern');
               End  
             Else skrivprov(smin(.a.),smax(.a.));
           End;(* ett_prov *)

         Procedure flera_prov;
           Begin
             Write(utfil,'Viktning ');
             For p_nr:=a To b Do Write(utfil,vikt(.p_nr.):2:2,' ');
             Writeln(utfil);Writeln(utfil);
             For i:=1 To 120 Do st_x(.i.):=0;
             For e_nr:=1 To antal_e Do
               Begin
                 i:=meds(.e_nr.)-min_ms+1;
                 st_x(.i.):=st_x(.i.)+1;
               End;
             antal_p:=max_ms-min_ms+1;
             If antal_p>80 Then 
               Begin
                 If printer Then
                   Begin
                     Write(lst,liten);
                     skrivprov(min_ms,max_ms);
                   End
                 Else Write(ClrHom,'F}r ej plats ! >80 tecken.',
                 ' Anv{nd printern');
               End  
             Else skrivprov(min_ms,max_ms);
           End;(* flera prov *)          

       (*--------------------------------------------------------------*)

         Begin(* sx_lista *)
           utskriftsval;
           If escape Then Exit;
           rubrik;
           If a<b Then flera_prov Else ett_prov;
           If (Not printer) Then 
             Begin
               Write('Tryck tangent !');
               Read(Kbd,ch);
             End;  
         End;(* sx_lista *)              

    (*----------------------------------------------------------------*)

      Begin(* Result *)
        init;
        If escape Then Exit;   
        antal_prov;
        If escape Then Exit;
        stand;
        If a<b Then medel;
        Repeat
          resultat_meny;
          Write('          V{lj R,X,O,S,V,I,A :');Read(Kbd,ch);
          Case ch Of 'R','r' :resultat;
                     'X','x' :x_lista;
                     'O','o' :ordn_lista;        
                     'S','s' :sx_lista;
                     'V','v' :If a<b Then medel;
                     'I','i' :lastext('STAND.TXT');
                 @27,'A','a' :;
                 Otherwise Write(@7);             
            End;(* Case *)           
        Until ch In(.'A','a',@27.)    
      End;(* Result *)  

     (***********************************************************************)

    Begin(* huvudprogram BETYG *)
        Repeat
          h_meny;
          Write('                        V{lj E,L,P,R,H,A  :');
          Repeat
            Read(Kbd,mval);
            If Not (mval In(.'E','e','L','l','P','p','R','r','H','h','A','a'.))
              Then Write(@7);
          Until mval In (.'E','e','L','l','P','p','R','r','H','h','A','a'.);
          Case mval OF
            'E','e' :elevnamn;
            'L','l' :lista;
            'P','p' :prov;
            'R','r' :result;
            'H','h' :lastext('INFO.TXT');
            'A','a' :Write(ClrHom);
          End;(* Case *)
        Until (mval='A') Or (mval='a');
    End.
ej plats ! >80 tecken.',
                 '