PROGRAM dator_emulering;
(*$C-*)
CONST 
    normal_delay=2000;   no_delay=0;      long_delay=4000;
    empty:ARRAY(.0..7.) OF Byte=($00,$00,$00,$00,$00,$00,$00,$00);    
    checkstate=False;
TYPE
    instr=String(.9.); twostr=String(.2.); fourstring=String(.4.);
    strg=String(.80.);
VAR 
    filen:Text;
    instruction:instr;         num,i,org,org0,recty,delay:Integer;
    wormx,wormy:ARRAY (.0..4.) OF Integer; 
    inrad,utrad:ARRAY(.1..4.) OF String(.4.);
    memory:ARRAY(.0..31.) OF String(.4.);
    stackpointer,areg,breg,ireg,ccc:String(.4.);
    pc,adress:twostr; flag:String(.1.);
    c,choice,interrupt,old:Char; 
    haltflag:Boolean;

PROCEDURE inmat(VAR s:fourstring);
VAR    c:Char;  i:Integer;
BEGIN
  Gotoxy(3,3);
  s:='';
  REPEAT
    Read(Kbd,c); 
    IF Ord(c)=8 THEN 
       s:=Copy(s,1,Len(s)-1) 
    ELSE
      IF (c in (.'0'..'9'.)) THEN s:=s+c;
    Gotoxy(3,3); Write(s);
    FOR i:=1 TO 4-Len(s) DO Write(' ');
    Gotoxy(Len(s)+3,3);
  UNTIL (Ord(c)=13) AND (Len(s)=4);  
END;  
      
PROCEDURE wait(x:Integer);
VAR i,j:Integer;
BEGIN
  FOR i:=1 TO x DO;
    FOR j:=1 TO delay DO ;
END;
  
PROCEDURE decode(a:strg; VAR b:strg);
VAR i,j,cd:Integer; codekey:strg;
BEGIN
  codekey:='!&/()=%FATSGHJUFHGHX$!%&Y()=SKJ?GJHSJGC';
  b:='';
  IF checkstate THEN cd:=1 ELSE cd:=-1;
  FOR i:=1 TO Len(a) DO
    BEGIN
      j:=Ord(a(.i.))-32+cd*(Ord(codekey(.i.))-32);
      j:=j MOD 95; IF j<0 THEN j:=j+95;
      b:=b+Char(j+32);
    END;
END;    
  
PROCEDURE startbild;
VAR netname,netnamer:strg;  i:Integer;
BEGIN
  Initturtle; 
  Assign(filen,'NAMEFILE.DAT'); Reset(filen); Read(filen,netname);
  Charsize(4); Moveto(200,200); Writestr('EMULA');
  decode(netname,netnamer); 
  Gotoxy(30,17); Write('N{tverkslicens f|r ',netnamer);
  Gotoxy(35,19); Write('Copyright LARS GISLN');
  IF checkstate THEN HALT;
  delay:=long_delay;
  FOR i:=1 TO 20 DO wait(10000);
END;  
PROCEDURE mark(x,y,l,b:Integer);
BEGIN
  Penmode(Reverse); Rectfill(x,y,l,b);
END;
  
PROCEDURE purge(x,y,l,b:Integer);
BEGIN
  Penmode(Setbit);Rectfill(x,y,l,b); wait(10000);
  Penmode(Reverse);Rectfill(x,y,l,b);
END;  

PROCEDURE screen(screentype:Integer);
VAR i,j:Integer;
BEGIN
  Initturtle; 
  Moveto(272,370); Charsize(2); Writestr('CPU'); interrupt:=' ';
  FOR i:=0 TO 3 DO
      BEGIN
        FOR j:=0 TO 7 DO
          BEGIN
            IF screentype=0 THEN memory(.i*8+j.):='0000';
            Rect(i*144+103,239-j*32,47,18);
            Gotoxy(14+i*18,9+j*2); Write(memory(.i*8+j.));
            Gotoxy(i*18+6,9+j*2); 
            IF j+8*i<10 THEN Write('0'); Write(j+i*8);
            Moveto(i*144+103,247-j*32); Lineto(i*144+80,247-j*32);
          END;  
        Moveto(i*144+80,280); Lineto(i*144+80,23);
      END;    
  Moveto(110,280); Lineto(110,295); Moveto(500,280); Lineto(500,295);
  Charsize(1);
  Moveto(147,382); Writestr('LOAD');Rect(144,381,36,18);
  Moveto(147,364); Writestr('STEP');
  Moveto(147,346); Writestr('RUN');
  Moveto(147,328); Writestr('CLR');
  Moveto(147,310); Writestr('NEW');
  Moveto(80,280); Lineto(512,280); (*IN OUT*)
  Moveto(199,317); Writestr('A'); Rect(179,300,47,18);
  areg:='0000'; Moveto(187,301); Writestr(areg);
  Moveto(330,317); Writestr('IR'); Rect(315,300,47,18);
  ireg:='0000'; Moveto(323,301); Writestr(ireg);
  Moveto(338,357); Writestr('ADR'); Rect(336,340,26,18);
  adress:='00'; Moveto(342,341); Writestr(adress);
  Moveto(287,357); Writestr('PC'); Rect(282,340,24,18); 
  pc:='00'; Moveto(287,341); Writestr(pc); org0:=0;
  Moveto(200,357); Writestr('Flag'); Rect(207,340,15,18);
  flag:='Z'; Moveto(211,341); Writestr(flag); 
  Rect(363,300,74,18); 
  Moveto(395,357); Writestr('SP'); Rect(390,340,24,18);
  stackpointer:='31'; Moveto(396,341); Writestr(stackpointer);
  mark(480,15,16,16); Penmode(Setbit);
  Moveto(214,332); Lineto(349,332);
  Moveto(214,318); Lineto(214,332); (*A*)
  Moveto(349,318); Lineto(349,332); (*IR*)
  Moveto(294,332); Lineto(294,340); (*PC*)
  Moveto(306,349); Lineto(336,349); (*PCARD*)
  Moveto(306,280); Lineto(306,332); (*Memory*)
  Turnto(90); Moveto(470,305); Lineto(470,385); Arc(-90,5);
  Lineto(595,390); Arc(-90,5);
  Lineto(600,305); Arc(-90,5);
  Lineto(475,300); Arc(-90,5);  
  FOR i:=0 TO 13 DO Rect(25+i*7,323,5,5);
  FOR i:=0 TO 12 DO Rect(29+i*7,316,5,5);
  FOR i:=0 TO 11 DO Rect(32+i*7,309,5,5);
  FOR i:=0 TO 10 DO Rect(36+i*7,302,5,5);
  Rect(42,295,62,5);
  Linetype($5555); 
  Rect(140,291,320,109); 
  Rect(10,291,125,109);
  Rect(465,291,145,109);
  Rect(10,0,600,289);
  Moveto(353,318); Lineto(353,340);
  FOR i:=1 TO 4 DO 
    BEGIN
      inrad(.i.):='    ';
      utrad(.i.):='    ';
    END;  
  Linetype($FFFF);
END;

PROCEDURE load(instruction:instr; VAR num:Integer);
VAR temp1,temp2:String(.4.); c,c1,c2,x,felpos:Integer;
BEGIN
  c1:=Pos(',',instruction);
  IF c1=0 THEN num:=0
  ELSE
    BEGIN
      temp1:=Copy(instruction,4,c1-4);
      temp2:=Copy(instruction,c1+1,Len(instruction));
        IF (temp1<>'A') AND (temp2<>'A') THEN num:=0
        ELSE
          BEGIN
            IF temp1='A' THEN 
              BEGIN
                IF Pos('(',temp2)<>0 THEN 
                  BEGIN
                    Delete(temp2,1,1); 
                    Delete(temp2,Len(temp2),1);
                    num:=num+100;
                    Val(temp2,x,felpos); x:=x MOD 32
                  END
                ELSE 
                  BEGIN
                    Val(temp2,x,felpos); x:=x MOD 100;
                  END;
              END
            ELSE
              IF temp2='A' THEN
                BEGIN  
                  num:=num+200; 
                  IF Pos('(',temp1)<>0 THEN 
                    BEGIN
                      Delete(temp1,1,1); 
                      Delete(temp1,Len(temp1),1);
                    END
                  ELSE temp1:=temp1+'****';
                  Val(temp1,x,felpos); x:=x MOD 32;
                 END
                ELSE felpos:=1;
            IF felpos=0 THEN num:=num+x ELSE num:=0;  
                
          END;    
    END;              
END;

PROCEDURE adr(i:Integer;instruction:instr; VAR num:Integer);
VAR temp:String(.4.); c,x,felpos:Integer;
BEGIN
  x:=0; temp:=Copy(instruction,i,Len(instruction));
  IF (Copy(temp,1,1)='(') AND 
            (Copy(temp,Len(temp),1)=')') THEN
    BEGIN
      Delete(temp,1,1); Delete(temp,Len(temp),1);
      num:=num+100;
      x:=1;
    END;  
  IF x=0 THEN c:=32 ELSE c:=100;
  Val(temp,x,felpos); x:=x MOD 32;
  IF felpos=0 THEN num:=num+x ELSE num:=0;
END;    

PROCEDURE jp(i:Integer;instruction:instr;VAR num:Integer);
VAR temp:String(.4.); c,x,felpos:Integer;
BEGIN
  temp:=Copy(instruction,i,1);
  c:=Pos(temp,'ZNP');
  num:=num+c*100;
  IF c=0 THEN
    BEGIN
      temp:=Copy(instruction,i,2);
      Val(temp,x,felpos); x:=x MOD 32;
      IF felpos=0 THEN num:=num+x ELSE num:=0;
    END
  ELSE
    BEGIN
      c:=Pos(',',instruction);
      IF c=0 THEN num:=0 ELSE
        BEGIN
          temp:=Copy(instruction,c+1,2);
          Val(temp,x,felpos); x:=x MOD 32;
          IF felpos=0 THEN num:=num+x ELSE num:=0;
        END;
    END;
END;             

PROCEDURE assemble(instruction:instr;VAR num:Integer);
VAR temp:String(.4.); c:Integer;
BEGIN
  temp:=Copy(instruction,1,3);
  WHILE Len(temp)<4 DO temp:=temp+' ';
  c:=Pos(temp,'LD  ADD SUB CP  CAL JP  ORG ');
  num:=(c div 4+1)*1000;
  IF c=0 THEN 
    BEGIN
      temp:=Copy(instruction,1,4);
      WHILE Len(temp)<4 DO temp:=temp+' ';
      c:=Pos(temp,'NOP IN  OUT RET POP PUSHDEC INC NEG SL  SR  HALT') DIV 4;
      num:=c*50;
      IF Len(temp)<>4 THEN c:=0;
    END;
  IF c=0 THEN num:=0;
  CASE num OF
    1000     :load(instruction,num);
    2000,3000:adr(5,instruction,num);
    4000     :adr(4,instruction,num);
    5000     :jp(6,instruction,num);
    6000     :jp(4,instruction,num);
    7000     :jp(5,instruction,num);
  END;
END;      
    
FUNCTION twodigit(x:Integer):twostr;         
VAR a:twostr;
BEGIN
  Str(x,a);
  WHILE Len(a)<2 DO a:='0'+a;
  twodigit:=a;
END;
  
PROCEDURE extra0(VAR i:instr; x,y:Integer);
BEGIN
  CASE x OF
    0:i:=i+'A,'+twodigit(y);
    1:BEGIN  
        i:=i+'A,('+twodigit(y)+')';
        IF y>32 THEN haltflag:=TRUE;
      END;  
    2:BEGIN
        i:=i+'('+twodigit(y)+'),A';
        IF y>31 THEN haltflag:=TRUE;
      END;  
    OTHERWISE i:='NOP'
  END;
END;     
    
PROCEDURE extra1(VAR i:instr; x,y:Integer);
BEGIN
  CASE x OF
    0:i:=i+twodigit(y);
    1:BEGIN
        i:=i+'('+twodigit(y)+')';
        IF y>31 THEN haltflag:=TRUE;
      END;  
    OTHERWISE i:='NOP';
  END;
END;

PROCEDURE extra2(VAR i:instr; x,y:Integer);    
BEGIN
  CASE x OF
    0:i:=i+twodigit(y);
    1:i:=i+'Z,'+twodigit(y);
    2:i:=i+'N,'+twodigit(y);
    3:i:=i+'P,'+twodigit(y);
    OTHERWISE i:='NOP';
  END;
    IF y>31 THEN haltflag:=TRUE;
END;
    
PROCEDURE disassemble(num:Integer; VAR i:instr);  
VAR temp1,temp2,temp3:Integer;
BEGIN
  temp1:=num DIV 1000; temp2:=(num-temp1*1000) DIV 100;
  temp3:=num MOD 100;
  CASE temp1 OF
    0:IF (temp3 MOD 50)=0 THEN
        CASE (num MOD 1000) DIV 50 OF
          0:i:='NOP';
          1:i:='IN';
          2:i:='OUT';
          3:i:='RET';
          4:i:='POP';
          5:i:='PUSH';
          6:i:='DEC';
          7:i:='INC';
          8:i:='NEG';
          9:i:='SL';
         10:i:='SR';
         11:i:='HALT';
        END
      ELSE i:='NOP';             
    1:BEGIN
        i:='LD ';
        extra0(i,temp2,temp3);
      END;  
    2:BEGIN 
        i:='ADD ';
        extra1(i,temp2,temp3);
      END;    
    3:BEGIN 
        i:='SUB ';
        extra1(i,temp2,temp3);
      END;    
    4:BEGIN 
        i:='CP ';
        extra1(i,temp2,temp3);
      END;    
    5:BEGIN
        i:='CALL ';
        extra2(i,temp2,temp3);
      END;    
    6:BEGIN
        i:='JP ';
        extra2(i,temp2,temp3);
      END;  
    7:BEGIN
        i:='ORG ';
        extra2(i,temp2,temp3);
      END;  
  END;
END;    

PROCEDURE move_worm(startx,starty,endx,endy:Integer);
VAR  number_of_steps,stepx,stepy,k,l,i:Integer;
BEGIN
  Penmode(Reverse);
  number_of_steps:=Abs(endx+endy-startx-starty);
  IF number_of_steps<>0 THEN
    BEGIN
      
      stepx:=(endx-startx) DIV number_of_steps;
      stepy:=(endy-starty) DIV number_of_steps;
      Penmode(Reverse); wormx(.0.):=startx; wormy(.0.):=starty;
      FOR k:=1 TO number_of_steps-1 DO
      BEGIN
        wait(1);
        IF Keypress THEN Read(Kbd,interrupt);     
        Gotoxy(55,1); 
        IF Ord(interrupt)>90 THEN interrupt:=Char(Ord(interrupt)-32);
        IF interrupt IN (.'I','B','H','L','N'.) THEN Write(interrupt);
        Buflen:=1;
        IF (wormx(.0.)<>0) AND (wormy(.0.)<>0) THEN 
          Plot(wormx(.0.),wormy(.0.));
        IF (wormx(.4.)<>0) AND (wormy(.4.)<>0) THEN 
          Plot(wormx(.4.),wormy(.4.)); 
        startx:=startx+stepx; starty:=starty+stepy;
        FOR l:=4 DOWNTO 1 DO 
          BEGIN 
            wormx(.l.):=wormx(.l-1.);
            wormy(.l.):=wormy(.l-1.);
          END;
        wormx(.0.):=startx; wormy(.0.):=starty;
      END;
    END; 
END;
        
PROCEDURE internal_transfer(startx,starty,endx,endy:Integer);
VAR i,j:Integer;
BEGIN
  move_worm(startx,starty,startx,332); move_worm(startx,332,endx,332);
  move_worm(endx,332,endx,endy);
  IF endy>332THEN
    FOR j:=endy-5 TO endy-2 DO
      BEGIN
        wait(100);
        Plot(endx,j);
      END
  ELSE 
    FOR j:=endy+5 DOWNTO endy+2 DO
      BEGIN
        wait(100);
        Plot(endx,j);
      END;
END;

PROCEDURE pc_to_adr;
VAR i,j:Integer;
BEGIN
  mark(283,341,22,16);
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END; 
  move_worm(306,349,336,349);
  FOR j:=331 TO 334 DO
    BEGIN
      wait(100);
      Plot(j,349);
    END;
  purge(337,341,24,16);
  adress:=pc; Moveto(342,341); Writestr(pc);
  mark(283,341,22,16);
END; 
 
PROCEDURE fetch;
VAR i,j,i1,j1,x,felpos:Integer; 
BEGIN
  purge(364,301,72,16);  
  mark(200,383,56,16); Moveto(200,383); Writestr(' FETCH '); 
  wait(20000);  pc_to_adr; mark(337,341,24,16);
  wait(20000); Val(pc,x,felpos);
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  i:=(x DIV 8)*144+103;  j:=247-(x MOD 8)*32;
  i1:=(x DIV 8)*144+80;  mark(i+1,j-7,45,16);
  move_worm(i,j,i1,j);
  move_worm(i1,j,i1,280);
  move_worm(i1,280,306,280);
  move_worm(306,280,306,300);
  internal_transfer(306,301,349,318); mark(337,341,24,16);
  purge(316,301,45,16); ireg:=memory(.x.);
  Moveto(323,301); Writestr(ireg); 
  wait(30000);
  Val(ireg,num,felpos); 
  disassemble(num,instruction); 
  Moveto(365,301); Writestr(instruction); 
  mark(i+1,j-7,45,16); wait(30000);
  Str((x+1) MOD 32,pc); WHILE Len(pc)<2 DO pc:='0'+pc; 
  purge(283,341,22,16); 
  wait(30000);
  Moveto(287,341); Writestr(pc);
  wait(30000);  
END;  

PROCEDURE load_a(x:Integer);
VAR i,j,i1,j1:Integer; 
BEGIN
  mark(337,341,24,16);
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  i:=(x DIV 8)*144+103;  j:=247-(x MOD 8)*32;
  i1:=(x DIV 8)*144+80;  mark(i+1,j-7,45,16);
  move_worm(i,j,i1,j);
  move_worm(i1,j,i1,280);
  move_worm(i1,280,306,280);
  internal_transfer(306,280,214,318);
  mark(337,341,24,16);
  mark(i+1,j-7,45,16); purge(180,301,45,16);
  areg:=memory(.x.); Moveto(187,301); Writestr(areg); 
END;

PROCEDURE a_to_memory(x:Integer);
VAR i,j,i1,j1:Integer; 
BEGIN
  mark(337,341,24,16);
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  i:=(x DIV 8)*144+104;  j:=247-(x MOD 8)*32;
  i1:=(x DIV 8)*144+80;  mark(180,301,45,16);
  internal_transfer(214,318,306,280);
  FOR j1:=282 TO 285 DO Plot(306,j1);
  move_worm(306,280,i1,280);
  move_worm(i1,280,i1,j);
  move_worm(i1,j,i,j);
  FOR i1:=i-5 TO i-2 DO
    BEGIN
      wait(100);
      Plot(i1,j);
    END;
  mark(337,341,24,16);
  mark(180,301,45,16); purge(i,j-7,45,16);
  memory(.x.):=areg; Moveto(i+8,j-7); Writestr(areg); 
END;  

PROCEDURE jumpload(x:Integer);
VAR i:Integer;
BEGIN
  IF (x MOD 1000) DIV 100>0 THEN 
    BEGIN
      purge(208,341,13,16); Moveto(211,341); Writestr(flag);
    END;  
  x:=(x MOD 100) MOD 32; 
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  mark(338,301,22,16); internal_transfer(349,318,294,340);
  mark(338,301,22,16); Str(x,pc);
  WHILE Len(pc)<2 DO pc:='0'+pc; purge(283,341,22,16);
  Moveto(287,341); Writestr(pc);
END;  

PROCEDURE ir_to_adr;
VAR i:Integer;
BEGIN
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  mark(338,301,22,16); internal_transfer(353,318,353,340);
  mark(338,301,22,16); Str(num MOD 100,adress);
  WHILE Len(adress)<2 DO adress:='0'+adress; purge(337,341,24,16);
  Moveto(342,341); Writestr(adress);
END;  

PROCEDURE pc_to_stack(num:Integer);
VAR i,j,i1,j1,x,felpos:Integer; 
BEGIN
  Val(stackpointer,x,felpos); 
  
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  i:=(x DIV 8)*144+103;  j:=247-(x MOD 8)*32;
  i1:=(x DIV 8)*144+80;  mark(283,341,22,16);
  internal_transfer(294,340,306,280);
  FOR j1:=282 TO 285 DO Plot(306,j1);
  move_worm(306,280,i1,280);
  move_worm(i1,280,i1,j);
  move_worm(i1,j,i,j);
  FOR i1:=i-5 TO i-2 DO
    BEGIN
      wait(100);
      Plot(i1,j);
    END;
  mark(283,341,22,16); purge(i+1,j-7,45,16);
  memory(.x.):='00'+pc; Moveto(i+9,j-7); Writestr('00'+pc); 
  mark(144*(x DIV 8)+48,239-(x MOD 8)*32,16,16);  
  x:=x-1;  IF x<0 THEN x:=31;
  Str(x,stackpointer); WHILE Len(stackpointer)<2 DO
                          stackpointer:='0'+stackpointer;
  purge(391,341,22,16); Moveto(396,341); Writestr(stackpointer);
  mark(144*(x DIV 8)+48,239-(x MOD 8)*32,16,16);  
  jumpload(num);
END;  

PROCEDURE stack_to_pc;
VAR i,j,i1,j1,x,felpos:Integer; 
BEGIN
  Val(stackpointer,x,felpos);  
  mark(144*(x DIV 8)+48,239-(x MOD 8)*32,16,16);  
  x:=(x+1) MOD 32;  Str(x,stackpointer);
  WHILE Len(stackpointer)<2 DO
                          stackpointer:='0'+stackpointer;
  purge(391,341,22,16); Moveto(396,341); Writestr(stackpointer);             
  mark(144*(x DIV 8)+48,239-(x MOD 8)*32,16,16);  
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  i:=(x DIV 8)*144+103;  j:=247-(x MOD 8)*32;
  i1:=(x DIV 8)*144+80;  mark(283,341,22,16);
  mark(i+1,j-7,45,16);
  move_worm(i,j,i1,j); move_worm(i1,j,i1,280);
  move_worm(i1,280,306,280);
  internal_transfer(306,280,294,340);
  mark(i+1,j-7,45,16); purge(283,341,22,16);
  Val(memory(.x.),i,felpos); i:=i MOD 100;
  IF i>32 THEN haltflag:=TRUE;
  Str(i,pc); WHILE Len(pc)<2 DO pc:='0'+pc;
  Moveto(287,341); Writestr(pc); 

END;  

PROCEDURE a_to_out;
VAR i,j,i1,j1:Integer; 
BEGIN
  mark(180,301,45,16); Cursoroff;
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  internal_transfer(214,318,306,280);
  FOR j1:=282 TO 285 DO Plot(306,j1);
  move_worm(306,280,500,280);
  move_worm(500,280,500,295);
  FOR j1:=290 TO 293 DO
    BEGIN
      wait(100);
      Plot(500,j1);
    END;
  mark(180,301,45,16);
  FOR i:=1 TO 3 DO utrad(.i.):=utrad(.i+1.);
  utrad(.4.):=areg; 
  FOR i:=1 TO 4 DO
    BEGIN
      Gotoxy(70,i);
      Write(utrad(.i.));
    END;
END;  

PROCEDURE in_to_a;
VAR i,j,i1,j1:Integer; 
BEGIN
  FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
  move_worm(110,295,110,280);
  move_worm(110,280,306,280);
  internal_transfer(306,280,214,318);
  purge(180,301,45,16); areg:=inrad(.3.); 
  WHILE Len(areg)<4 DO areg:='0'+areg;
  Moveto(187,301); Writestr(areg);
END;  

 
PROCEDURE flagset(x:Integer);
BEGIN
  IF x=0 THEN flag:='Z'; 
  IF (x<0) OR (x>4999) THEN flag:='N';
  IF (x>0) AND (x<5000) THEN flag:='P';
  purge(208,341,13,16); Moveto(211,341); Writestr(flag);
END;
    
PROCEDURE zeroinstr(x:Integer);
VAR i,felpos:Integer;
BEGIN
  CASE x OF
    0:wait(20000);
   50:BEGIN
        Gotoxy(3,3); Cursoron;
        FOR i:=1 TO 2 DO inrad(.i.):=inrad(.i+1.);
        inmat(inrad(.3.));
        Gotoxy(3,3); Write('            ');
        FOR i:=3 DOWNTO 2 DO
          BEGIN
            Gotoxy(3,i-1);
            Write(inrad(.i.),'        ');
          END;    
        Cursoroff; in_to_a;
      END;  
  100:BEGIN
        a_to_out;
      END;   
  150:stack_to_pc;
        
  200:BEGIN
        Val(stackpointer,i,felpos); 
        mark(144*(i DIV 8)+48,239-(i MOD 8)*32,16,16);
        i:=(i+1) MOD 32; Str(i,stackpointer); 
        WHILE Len(stackpointer)>2 DO
                                stackpointer:='0'+stackpointer;
        purge(391,341,22,16); Moveto(396,341); Writestr(stackpointer);
        mark(144*(i DIV 8)+48,239-(i MOD 8)*32,16,16);  
        load_a(i);    
      END;  
  250:BEGIN
        Val(stackpointer,i,felpos);
        a_to_memory(i);
        mark(144*(i DIV 8)+48,239-(i MOD 8)*32,16,16);  
        i:=i-1; IF i<0 THEN i:=31;
        Str(i,stackpointer); WHILE Len(stackpointer)>2 DO
                                stackpointer:='0'+stackpointer;
        purge(391,341,22,16); Moveto(396,341); Writestr(stackpointer);
        mark(144*(i DIV 8)+48,239-(i MOD 8)*32,16,16);
      END;  
  300:BEGIN
        Val(areg,i,felpos); i:=i-1;
        IF i<0 THEN i:=i+10000;
        flagset(i);
        Str(i,areg); purge(180,301,45,16);
        WHILE Len(areg)<4 DO areg:='0'+areg;
        Moveto(187,301); Writestr(areg);
      END;  
  350:BEGIN
        Val(areg,i,felpos); i:=(i+1) MOD 10000;
        flagset(i);
        Str(i,areg); purge(180,301,45,16);
        WHILE Len(areg)<4 DO areg:='0'+areg;
        Moveto(187,301); Writestr(areg);
      END;  
  400:BEGIN
        Val(areg,i,felpos); i:=(10000-i) MOD 10000;
        Str(i,areg); purge(180,301,45,16);
        WHILE Len(areg)<4 DO areg:='0'+areg;
        Moveto(187,301); Writestr(areg);
      END;   
  450:BEGIN
        areg:=Copy(areg,2,Len(areg))+'0';
        purge(180,301,45,16);
        Moveto(187,301); Writestr(areg);
      END;  
  500:BEGIN
        areg:='0'+Copy(areg,1,len(areg)-1);
        purge(180,301,45,16);
        Moveto(187,301); Writestr(areg);
      END;  
  END;
END;
    
PROCEDURE execute(num:Integer);
VAR slask,slaska,felpos,i:Integer;
BEGIN

  CASE num DIV 1000 OF
    0:zeroinstr(num MOD 1000);
    1: CASE (num MOD 1000) DIV 100 OF
         0:BEGIN
             Str(num MOD 100,areg);
             WHILE Len(areg)<4 DO areg:='0'+areg;
             purge(180,301,45,16); Moveto(187,301); Writestr(areg);  
           END;
         1:BEGIN
             ir_to_adr;
             load_a((num MOD 100) MOD 32);
           END;  
         2:BEGIN
             ir_to_adr;
             a_to_memory((num MOD 100) MOD 32);
           END;  
       END;
    2,3,4:BEGIN
            Val(areg,slask,felpos);   
            IF (num MOD 1000) DIV 100=1 THEN 
              BEGIN
                Val(memory(.(num MOD 100) MOD 32.),slaska,felpos);          
                ir_to_adr;
                load_a((num MOD 100) MOD 32);
              END
            ELSE slaska:=num MOD 100;    
            CASE num DIV 1000 OF
              2:BEGIN
                  slask:=(slask+slaska) MOD 10000;
                  flagset(slask);
                END;  
              3:BEGIN
                  slask:=(slask-slaska);
                  WHILE slask<0 DO slask:=slask+10000;
                  flagset(slask);
                END;
              4:flagset(slask-slaska);
            END;
            Str(slask,areg); WHILE Len(areg)<4 DO areg:='0'+areg;
            purge(180,301,45,16); Moveto(187,301); Writestr(areg);
          END;       
    5: CASE (num MOD 1000) DIV 100 OF
         0:pc_to_stack(num);
         1:IF flag='Z' THEN pc_to_stack(num);
         2:IF flag='N' THEN pc_to_stack(num);
         3:IF flag='P' THEN pc_to_stack(num);    
       END;
    6: CASE (num MOD 1000) DIV 100 OF
         0:jumpload(num);
         1:IF flag='Z' THEN jumpload(num);
         2:IF flag='N' THEN jumpload(num);
         3:IF flag='P' THEN jumpload(num);    
       END;
  END;     
END;

PROCEDURE load_program;
VAR c:Char;  i,j,i1,j1,felpos:Integer; 
    s,stest:String(.9.); numerical:Boolean;
    inrad:ARRAY(.1..3.) OF String(.9.); mem:ARRAY(.1..3.) OF String(.2.);
BEGIN
 org:=0;  org0:=0; Penmode(Reverse); Rect(47,239,18,18);
 FOR i:=1 TO 3 DO BEGIN inrad(.i.):=''; mem(.i.):='' END;
 REPEAT
  REPEAT
    Gotoxy(3,3); Str(org,s); WHILE Len(s)<2 DO s:='0'+s; Write(s);
    Write('          ');Gotoxy(6,3);Cursoron; mem(.3.):=s;
    s:=''; inrad(.3.):='';
    REPEAT
      Read(Kbd,c); IF (Ord(c)>96) AND (Ord(c)<123) THEN c:=Char(Ord(c)-32);
      IF Ord(c)=8 THEN 
         s:=Copy(s,1,Len(s)-1) 
      ELSE
        IF Ord(c)<>13 THEN s:=s+c;
      Gotoxy(6,3); Write(s);
      FOR i:=1 TO 9-Len(s) DO Write(' ');
      Gotoxy(Len(s)+6,3);
    UNTIL Ord(c)=13;
    inrad(.3.):=s;
    IF Len(s)=4 THEN
      BEGIN
        numerical:=TRUE;
        FOR i:=1 TO 4 DO IF NOT(s(.i.) IN (.'0'..'9'.)) THEN
          numerical:=FALSE; 
      END    
    ELSE numerical:=FALSE;
    IF numerical THEN BEGIN stest:=s; Val(stest,num,felpos) END
    ELSE
      BEGIN
         assemble(s,num);   disassemble(num,stest);
      END;   
    IF (s<>stest) AND (s<>'END') THEN 
      BEGIN 
        Gotoxy(6,3); Write(Rvson);Write('  ERROR  '); wait(32000);
        Write(Rvsoff); Gotoxy(6,3);Write('         ');
      END;
    IF (num DIV 1000=7) AND (s=stest) THEN
      BEGIN
        i:=(org DIV 8)*144+47;  j:=239-(org MOD 8)*32; Rect(i,j,18,18);
        org:=num MOD 100; org0:=org;
        purge(283,341,22,16);
        Str(org0,pc); WHILE Len(pc)<2 DO pc:='0'+pc; 
        Moveto(287,341); Writestr(pc); 
        i:=(org DIV 8)*144+47;  j:=239-(org MOD 8)*32;
        Rect(i,j,18,18);
      END;  
  UNTIL ((s=stest) AND (num DIV 1000 <> 7)) OR (s='END');
  IF s<>'END' THEN
    BEGIN
      Cursoroff;
      FOR i:=1 TO 2 DO 
        BEGIN inrad(.i.):=inrad(.i+1.); mem(.i.):=mem(.i+1.) END;
      FOR i:=1 TO 2 DO
        BEGIN
          Gotoxy(6,i); Write('         ');   
          Gotoxy(3,i); Write(mem(.i.)); 
          Gotoxy(6,i); Write(inrad(.i.));
        END;         
      Gotoxy(3,3); Write('            ');
      FOR i:=0 TO 4 DO BEGIN wormx(.i.):=0; wormy(.i.):=0; END;
      i:=(org DIV 8)*144+104;  j:=247-(org MOD 8)*32;
      i1:=(org DIV 8)*144+80;
      move_worm(110,295,110,280);  
      move_worm(110,280,i1,280);
      move_worm(i1,280,i1,j);
      move_worm(i1,j,i,j);
      FOR i1:=i-5 TO i-2 DO
        BEGIN
          wait(100);
          Plot(i1,j);
        END;
      Str(num,stest); WHILE Len(stest)<4 DO stest:='0'+stest;
      purge(i,j-7,45,16);  memory(.org.):=stest; 
      Moveto(i+8,j-7); Writestr(stest); 
  END;

  i:=(org DIV 8)*144+47;  j:=239-(org MOD 8)*32; Rect(i,j,18,18);
  org:=org+1; i:=(org DIV 8)*144+47;  j:=239-(org MOD 8)*32;
  Rect(i,j,18,18);
 UNTIL s='END';   
 Gotoxy(3,3); Write('            '); Cursoroff;
 i:=(org DIV 8)*144+47;  j:=239-(org MOD 8)*32; Rect(i,j,18,18); 

END;  
  
PROCEDURE reset(i:Integer);
BEGIN
  screen(i); recty:=381; Penmode(Reverse); 
  delay:=normal_delay;
END;
  
(********************************************************************)
(*****************    M A I N    P R O G R A M    *******************)
(********************************************************************)
(*   Lars Gisln 0413-320 43.  Version 8701 ************************)
BEGIN
  startbild;
  reset(0);
  REPEAT
    Read(Kbd,choice);
    CASE choice OF
      '':BEGIN
            Rect(144,recty,36,18);
            recty:=recty+18;
            IF recty>381 THEN recty:=381;  
            Rect(144,recty,36,18);  
          END;
      '':BEGIN     
            Rect(144,recty,36,18);
            recty:=recty-18;
            IF recty<327 THEN recty:=309;
            Rect(144,recty,36,18);
          END;  
      '':BEGIN
            mark(144,recty,36,18);
            CASE recty OF
             309:reset(0);
             327:reset(1);
             381:BEGIN load_program; mark(144,recty,36,18) END;
             363,345:
               BEGIN
                 Gotoxy(60,2); Write('         ');
                 Gotoxy(60,3); Write('         ');
                 interrupt:=' ';
                 Str(org0,pc); WHILE Len(pc)<2 DO pc:='0'+pc;
                 purge(283,341,22,16);
                 Moveto(287,341); Writestr(pc); 
                 REPEAT
                   haltflag:=FALSE; 
                   Cursoroff;
                   fetch;
                   IF recty=363 THEN Read(Kbd,c);(*Pause if STEP*)
                   purge(200,383,56,16);  wait(20000);
                   mark(330,383,56,16); 
                   Moveto(330,383); Writestr('EXECUTE'); 
                   wait(30000);
                   IF NOT haltflag THEN
                     execute(num);
                   IF haltflag THEN
                     BEGIN
                        Gotoxy(60,2);Write(Rvson,'EXECUTION');
                        Gotoxy(60,3);      Write('  ERROR  ',Rvsoff);
                     END;   
                   IF recty=363 THEN Read(Kbd,c);
                   IF interrupt<>' ' THEN mark(440,368,8,16); 
                   CASE interrupt OF
                     'b','B':BEGIN
                               purge(364,301,72,16); Moveto(364,301);
                               Writestr('BREAK');
                               Read(Kbd,c);
                               IF (c='s') OR (c='S') THEN 
                                 BEGIN
                                   haltflag:=TRUE;
                                   purge(364,301,72,16); Moveto(364,301);
                                   Writestr('STOP');
                                 END;  
                             END;
                     'i','I':BEGIN
                               purge(364,301,72,16); Moveto(364,301);
                               Writestr('INTERRUPT');
                               interrupt:=' '; execute(5020);
                              END;
                     'h','H':delay:=no_delay;
                     'l','L':delay:=long_delay;
                     'n','N':delay:=normal_delay;
                   END;
                   interrupt:=' ';
                   purge(330,383,56,16); Gotoxy(55,1); Write(interrupt);
                 UNTIL (instruction='HALT') OR haltflag;
                 mark(144,recty,36,18);
               END;       
            END;        
          END;  
    END;
  UNTIL choice='';
  Penmode(Clearbit);
  FOR i:=0 TO 320 DO
    Rect(i,(i*5) DIV 8,640-2*i,400-(i*5) DIV 4); Gotoxy(0,0);
  Penmode(Replace);
  FOR i:=1 TO 50 DO 
    BEGIN
      Circle(310,200,i*4); Circle(330,200,i*4);
    END;  
  Pattern(empty);
  Rectfill(200,190,235,20); 
  Moveto(205,192); Writestr(' Lars Gisln / Version 8709');
END.        

CE}3                      COMPIS SCANDIS/H1IS            PY      