program moon;


VAR y,m,day  :Integer;
    h      :Real;
    ll,lp,lf,ld,om:Real;
    jul,addl,long:Real;
    facl,facp,facf:Real;
    ss, bigc,lat,px:Real; 
    alpha,delta:Real;
    
(**********************************************************************)
FUNCTION julday(y,m,d:Integer;h:Real):Real;
VAR
century,excess :Integer;
temp           :Real; 
BEGIN
  IF m>2 THEN
    m:=m-3
  ELSE
  BEGIN
    m:=m+9;
    y:=y-1;
  END;
  century:=y div 100;
  excess:=y-century*100;
  temp:=Int(1461.0*excess/4)+Int((153.0*m+2)/5)+d;
  temp:=temp+Int(146097.0*century/4)+1721118.5+h/24;
  julday:=temp-2415020.0;
END;      

(********************************************************************)
FUNCTION mlong(j:Real):Real;
VAR  temp:Real;
BEGIN
  temp:=((1077E-25*j-235980E-20)*j+0.036601101463356)*j;
  temp:=temp+0.75120601080;  
  mlong:=Frac(temp);
END;  

(*******************************************************************)
FUNCTION omega(j:Real):Real;
VAR  temp:Real;
BEGIN
  temp:=((1266E-25*j+432630E-20)*j-1.47094228332E-4)*j;
  temp:=temp+0.71995354167;
  omega:=Frac(temp);
END;  

(******************************************************************)
FUNCTION l(j:Real):Real;
VAR  temp:Real;
BEGIN
  temp:=((8203E-25*j+1913865E-20)*j+0.036291645684716)*j;
  temp:=temp+0.82251280093;
  l:=Frac(temp);
END;

(*******************************************************************)
FUNCTION d(j:Real):Real;
VAR  temp:Real;
BEGIN
  temp:=((1077E-25*j-299023E-20)*j+0.033863192198393)*j;
  temp:=temp+0.97427079475;
  d:=Frac(temp);
END;   

(******************************************************************)
FUNCTION p(j:Real):Real;
VAR  temp:Real;
BEGIN
  temp:=((-1900E-25*j-31233E-20)*j+0.002737778519279)*j;
  temp:=temp+0.99576620370;
  p:=Frac(temp);
END;   

(*****************************************************************)
FUNCTION f(j:Real):Real;
VAR  temp:Real;
BEGIN
  temp:=((-190E-25*j-668609E-20)*j+0.036748195691688)*j;
  temp:=temp+0.03125246914;
  f:=Frac(temp);
END;  

(*******************************************************************)
FUNCTION t(j:Real):Real;
BEGIN
  t:=0.27499653549+2.737803094025E-3*j;
END;

(*****************************************************************)
FUNCTION v(j:Real):Real;
BEGIN
  v:=0.95019202160+4.450362451095E-3*j;
END;

(******************************************************************)
FUNCTION jup(j:Real):Real;
BEGIN
  jup:=0.65931199845+2.30808970898E-4*j;
END;

(*****************************************************************)  
FUNCTION planlong(j:Real):Real;
VAR  tt,vv,jj:Real;    
BEGIN
  tt:=t(j);  vv:=v(j);  jj:=jup(j);
  planlong:=0.822*Sin((tt-vv)*2*Pi)+0.662*Sin((-ll+2*ld-3*tt+3*vv)*2*Pi+Pi/2)
            +0.643*Sin((-tt+vv)*2*Pi+Pi/2)
            +1.137*Sin((-ll+2*ld+2*tt-2*jj)*2*Pi+Pi/2);
END;

(*******************************************************************)          
FUNCTION addlong(j:Real):Real;
VAR  temp,arg:Real;
BEGIN
  arg:=(191E-16*j-10104982E-12)*j+0.53733431;
  temp:=11010802E-12*Sin(2*Pi*arg);
  temp:=temp+5602623E-12*Sin(2*Pi*omega(j));

  arg:=1536238E-12*j+0.14222222;
  temp:=temp+648148E-12*Sin(2*Pi*arg);
  arg:=1232723E-12*j+0.23363774;
  temp:=temp+239197E-12*Sin(2*Pi*arg);
  arg:=-147269147E-12*j+0.48398132;
  temp:=temp+217592E-12*Sin(2*Pi*arg);
  arg:=-11459387E-12*j+0.84536324;
  temp:=temp+182870E-12*Sin(2*Pi*arg);
  arg:=-21488317E-12*j+0.40353088;
  temp:=temp+83333E-12*Sin(2*Pi*arg);
  arg:=-78645335E-12*j+0.65544893;
  addlong:=temp+97222E-12*Sin(2*Pi*arg);
END;  

(**********************************************************)
FUNCTION addomega(j:Real):Real;
VAR  temp,arg:Real;
BEGIN
  temp:=74043210E-12*Sin(2*Pi*omega(j));
  arg:=(43E-16*j-147269147E-12)*j+0.48398132;
  temp:=temp+12021605E-12*Sin(2*Pi*arg);
  arg:=(43E-16*j-147162675E-12)*j+0.52453688;
  addomega:=temp+1435185E-12*Sin(2*Pi*arg);
END;

(************************************************************)
FUNCTION gamma(j:Real):Real;
BEGIN
  gamma:=-3331790E-12*Cos(2*Pi*omega(j));
END;  

(***********************************************************)
FUNCTION s(i,j,k,r:Integer):Real;
BEGIN
  s:=Sin((ll*i+lp*j+lf*k+ld*r)*2*Pi)*Exp(i*facl+j*facp+k*facf);
END;  

(************************************************************)
FUNCTION c(i,j,k,r:Integer):Real;
BEGIN
  c:=Cos((ll*i+lp*j+lf*k+ld*r)*2*Pi)*Exp(i*facl+j*facp+k*facf);
END; 

(*************************************************************)
FUNCTION bigs:Real;
BEGIN
  bigs:= -112.79*s(0,0,0,1) +2373.36*s(0,0,0,2)   -4.01*s(0,0,0,3)
          +14.06*s(0,0,0,4)    +6.98*s(1,0,0,4) +192.72*s(1,0,0,2)
          -13.51*s(1,0,0,1)+22609.07*s(1,0,0,0)   +3.59*s(1,0,0,-1)
        -4578.13*s(1,0,0,-2)   +5.44*s(1,0,0,-3) -38.64*s(1,0,0,-4)
           -1.43*s(1,0,0,-6)   +1.02*s(2,0,0,4)  +14.78*s(2,0,0,2)
           -1.20*s(2,0,0,1)  +767.96*s(2,0,0,0)   +2.01*s(2,0,0,-1)
         -152.53*s(2,0,0,-2)  -34.07*s(2,0,0,-4)  -1.40*s(2,0,0,-6)
           +2.96*s(3,0,0,2)   +50.64*s(3,0,0,0)  -16.40*s(3,0,0,-2)
           +3.60*s(4,0,0,0)    -1.58*s(4,0,0,-2)  -1.59*s(0,1,0,4)
          -25.10*s(0,1,0,2)   +17.93*s(0,1,0,1) -126.98*s(0,1,0,0)
         -165.06*s(0,1,0,-2)   -6.46*s(0,1,0,-4)  -1.68*s(0,2,0,2)
          -16.35*s(0,2,0,-2)  -11.75*s(1,1,0,2)   +1.52*s(1,1,0,1)
         -115.18*s(1,1,0,0)  -182.36*s(1,1,0,-2)  -9.66*s(1,1,0,-4)
           -2.27*s(-1,1,0,4)  -23.59*s(-1,1,0,2)-138.76*s(-1,1,0,0)
          -31.70*s(-1,1,0,-2)  -1.53*s(-1,1,0,-4) -1.45*s(2,1,0,2)
          -10.56*s(2,1,0,0)    -7.59*s(2,1,0,-2)  -2.54*s(2,1,0,-4)
           +3.32*s(2,-1,0,2)  +11.67*s(2,-1,0,0)  -1.17*s(2,-1,0,-2)
           -1.25*s(1,2,0,0)    -6.12*s(1,2,0,-2)  -2.40*s(-1,2,0,2)
           -2.32*s(-1,2,0,0)   -1.82*s(-1,2,0,-2)-52.14*s(0,0,2,-2)
           -1.67*s(0,0,2,-4)   -9.52*s(1,0,2,-2) -85.13*s(-1,0,2,0)
           +3.37*s(-1,0,2,-2)  -1.14*s(-2,0,2,2)  -2.26*s(0,1,2,-2)
           +1.30*s(0,-1,2,-2);
END;        

(*****************************************************************)
FUNCTION gammac:Real;
BEGIN
  gammac:=-0.725*c(0,0,0,1) +0.601*c(0,0,0,2)  +0.394*c(0,0,0,3)
          -0.445*c(1,0,0,4) +0.445*c(1,0,0,1)  +0.192*c(1,0,0,-3)
          +0.107*c(2,0,0,0) +5.679*c(2,0,0,-2) -0.308*c(2,0,0,-4)
          -0.166*c(3,0,0,2) -1.3  *c(3,0,0,0)  +0.258*c(3,0,0,-2)
          -0.145*c(4,0,0,0) +0.123*c(0,1,0,4)  -1.302*c(0,1,0,0)
          -0.416*c(0,1,0,-4)+0.131*c(0,2,0,2)  -0.74 *c(0,2,0,-2)
          +0.787*c(1,1,0,2) +0.461*c(1,1,0,0)  +2.056*c(1,1,0,-2)
          -0.471*c(1,1,0,-4)+0.146*c(-1,1,0,4) -0.443*c(-1,1,0,2)
          +0.679*c(-1,1,0,0)-1.54 *c(-1,1,0,-2)-0.111*c(-1,1,0,-4)
          +0.116*c(2,1,0,2) +0.259*c(2,1,0,0)  -0.212*c(2,-1,0,2)
          -0.151*c(2,-1,0,0)+0.117*c(1,2,0,-2) -0.105*c(-1,2,0,-2);
END;          

(****************************************************************) 
FUNCTION n:Real;
BEGIN
  n:=-526.069*s(0,0,1,-2) -3.352*s(0,0,1,-4) +44.297*s(1,0,1,-2)
       -6.0  *s(1,0,1,-4)+20.599*s(-1,0,1,0) -30.598*s(-1,0,1,-2)
      -24.649*s(-2,0,1,0) -2.0  *s(-2,0,1,-2)-22.571*s(0,1,1,-2)
      +10.985*s(0,-1,1,-2);
END;

(*****************************************************************)      
FUNCTION parallax:Real;
BEGIN
  parallax:=0.2607*c(0,0,0,4) +28.2333*c(0,0,0,2)+3422.7
           +0.0433*c(1,0,0,4)  +3.0861*c(1,0,0,2) +186.5398*c(1,0,0,0)
          +34.3117*c(1,0,0,-2) +0.6008*c(1,0,0,-4)  -0.3000*c(0,1,0,2)
           -0.3997*c(0,1,0,0)  +1.9178*c(0,1,0,-2)  +0.0339*c(0,1,0,-4)
           -0.9781*c(0,0,0,1)  +0.2833*c(2,0,0,2)  +10.1657*c(2,0,0,0)
           -0.3039*c(2,0,0,-2) +0.3722*c(2,0,0,-4)  +0.0109*c(2,0,0,-6)
           -0.0484*c(1,1,0,2)  -0.9490*c(1,1,0,0)   +1.4437*c(1,1,0,-2)
           +0.0673*c(1,1,0,-4) +0.2302*c(1,-1,0,2)  +1.1528*c(1,-1,0,0)
           -0.2257*c(1,-1,0,-2)-0.0102*c(1,-1,0,-4) +0.0918*c(0,2,0,-2)
           -0.0124*c(0,0,2,0)  -0.1052*c(0,0,2,-2)  -0.1093*c(1,0,0,1)
           +0.0118*c(1,0,0,-1) -0.0386*c(1,0,0,-3)  +0.1494*c(0,1,0,1)
           +0.0243*c(3,0,0,2)  +0.6215*c(3,0,0,0)   -0.1187*c(3,0,0,-2)
           -0.1038*c(2,1,0,0)  -0.0192*c(2,1,0,-2)  +0.0324*c(2,1,0,-4)
           +0.0213*c(2,-1,0,2) +0.1268*c(2,-1,0,0)  -0.0106*c(1,2,0,0)
           +0.0484*c(1,2,0,-2) +0.0112*c(1,-2,0,2)  +0.0196*c(1,-2,0,0)
           -0.0212*c(1,-2,0,-2)-0.0833*c(1,0,2,-2)  -0.0481*c(1,0,-2,2)
           -0.7136*c(1,0,-2,0) -0.0112*c(1,0,-2,-2) -0.0100*c(2,0,0,1)
           +0.0155*c(2,0,0,-1) +0.0164*c(1,1,0,1)   +0.0401*c(4,0,0,0)
           -0.0130*c(4,0,0,-2) +0.0115*c(3,-1,0,0)  -0.0141*c(2,0,-2,-2);
END;           

(************************************************************************)

FUNCTION nutation:Real;
VAR year,om:Real;
BEGIN
  year:=jul/36525.0;
  om:=omega(jul);
  nutation:=(-17.2327-0.0173*year)*Sin(2*Pi*om)+
            (-1.2729-0.00013*year)*Sin((2*om+2*lf-2*ld)*2*Pi);
END;

(***********************************************************************)
FUNCTION obliquity:Real;
VAR year,om:Real;
BEGIN
  year:=jul/36525.0;
  om:=omega(jul);
  obliquity:=(9.21+0.00091*year)*cos(2*Pi*om);
END;  

(*******************************************************************)
FUNCTION mobliquity:Real;
VAR year:Real;
BEGIN
  year:=jul/36525.0;
  mobliquity:=((5.03E-7*year-1.64E-6)*year-0.01301)*year+23.452294;
END;

(******************************************************************)
FUNCTION longcorr:Real;  
BEGIN
  longcorr:=13.902*s(0,0,0,4) +2369.912*s(0,0,0,2)   +1.979*s(1,0,0,4)
          +191.953*s(1,0,0,2)+22639.500*s(1,0,0,0)-4586.465*s(1,0,0,-2)
           -38.428*s(1,0,0,-4)  -24.42 *s(0,1,0,2) -668.146*s(0,1,0,0)
          -165.145*s(0,1,0,-2)   -1.877*s(0,1,0,-4)-125.154*s(0,0,0,1) 
           +14.387*s(2,0,0,2)  +769.016*s(2,0,0,0) -211.656*s(2,0,0,-2)
           -30.773*s(2,0,0,-4)   -0.57 *s(2,0,0,-6)  -2.921*s(1,1,0,2)
          -109.673*s(1,1,0,0)  -205.962*s(1,1,0,-2)  -4.391*s(1,1,0,-4)
           +14.577*s(1,-1,0,2) +147.687*s(1,-1,0,0) +28.475*s(1,-1,0,-2)
            +0.636*s(1,-1,0,-4)  -7.486*s(0,2,0,0)   -8.096*s(0,2,0,-2)
            -5.741*s(0,0,2,2)  -411.608*s(0,0,2,0)  -55.173*s(0,0,2,-2)
            -8.466*s(1,0,0,1)   +18.609*s(1,0,0,-1)  +3.215*s(1,0,0,-3)
           +18.023*s(0,1,0,1)    +0.56 *s(0,1,0,-1)+  1.06 *s(3,0,0,2)
           +36.124*s(3,0,0,0)   -13.193*s(3,0,0,-2)  -1.187*s(3,0,0,-4)
            -7.649*s(2,1,0,0)    -8.627*s(2,1,0,-2)  -2.74 *s(2,1,0,-4)
            +1.181*s(2,-1,0,2)   +9.703*s(2,-1,0,0)  -2.494*s(2,-1,0,-2)
            -1.167*s(1,2,0,0)    -7.412*s(1,2,0,-2)  +0.757*s(1,-2,0,2)
            +2.58 *s(1,-2,0,0)   +2.533*s(1,-2,0,-2) -0.992*s(1,0,2,2)
           -45.099*s(1,0,2,0)    -6.382*s(1,0,-2,2) +39.528*s(1,0,-2,0)
            +9.366*s(1,0,-2,-2)  -2.152*s(0,1,2,-2)  -1.44 *s(0,1,-2,2)
            -0.586*s(2,0,0,1)    +1.75 *s(2,0,0,-1)  +1.225*s(2,0,0,-3)
            +1.267*s(1,1,0,1)    -1.089*s(1,-1,0,-1) +0.584*s(0,0,2,-1)
            +1.938*s(4,0,0,0)    -0.952*s(4,0,0,-2)  -0.551*s(3,1,0,0)
            +0.681*s(3,-1,0,0)   -3.996*s(2,0,2,0)   +0.557*s(2,0,2,-2)
            -1.372*s(2,0,-2,0)   +0.538*s(2,0,-2,-2) +0.127*s(0,0,0,6)
            -0.393*s(1,0,0,-6)   -0.289*s(0,1,0,4)   +0.403*s(0,0,0,3)
            +0.213*s(2,0,0,4)    +0.283*s(1,-1,0,4)  -0.189*s(0,2,0,2)
            -0.151*s(0,2,0,-4)   +0.15 *s(0,1,0,3)   -0.293*s(3,0,0,-6)
            -0.29* s(2,1,0,2)    +0.36 *s(2,-1,0,-4) -0.311*s(1,2,0,-4)
            -0.103*s(0,3,0,0)    -0.344*s(0,3,0,-2)  -0.179*s(1,0,2,-2)
            -0.301*s(1,0,2,-4)   +0.202*s(1,0,-2,-4) +0.415*s(0,1,2,0)
            +0.384*s(0,1,-2,-2)  +0.137*s(1,1,0,-1)  +0.233*s(1,1,0,-3)
            -0.122*s(1,-1,0,1)   -0.276*s(1,-1,0,-3) +0.255*s(0,0,2,1)
            +0.254*s(0,0,2,-3)   -0.482*s(3,1,0,-2)  -0.1  *s(3,1,0,-4)
            -0.183*s(3,-1,0,-2)  -0.297*s(2,2,0,-2)  -0.161*s(2,2,0,-4)
            +0.197*s(2,-2,0,0)   +0.254*s(2,-2,0,-2) -0.25 *s(1,3,0,-2)
            -0.123*s(2,0,2,2)    -0.459*s(2,0,-2,2)  +0.173*s(2,0,-2,-4)
            +0.263*s(1,1,2,0)    +0.426*s(1,1,-2,-2) -0.304*s(1,-1,2,0)
            -0.372*s(1,-1,-2,2)  +0.418*s(0,0,4,0)   +0.130*s(3,0,0,-1)
            -0.352*s(2,-1,0,-1)  +0.113*s(5,0,0,0)   -0.33 *s(3,0,2,0);
END;

(********************************************************************)
PROCEDURE convert(long,lat:Real);
VAR  cdca,cdsa,sd,epsilon:Real;
BEGIN
  epsilon:=(mobliquity+obliquity/3600)*Pi/180;
  cdca:=Cos(lat)*Cos(long);
  cdsa:=Cos(lat)*Sin(long)*Cos(epsilon)-Sin(lat)*Sin(epsilon);
  sd:=Cos(lat)*Sin(long)*sin(epsilon)+Sin(lat)*Cos(epsilon);
  alpha:=Arctan(cdsa/cdca);
  delta:=Arctan(sd/Sqrt(Sqr(cdsa)+Sqr(cdca)));
  IF cdca<0 THEN alpha:=alpha+Pi;
  IF alpha<0 THEN alpha:=alpha+2*Pi;
END;

(************************************************************************)
(*******************   M A I N    P R O G R A M  ************************)
(************************************************************************)

BEGIN
  Initturtle;
  Charsize(5); Moveto(250,320);Writestr('MOON');
  Charsize(2); Moveto(150,300);Writestr('Geocentric ecliptic system');
  Charsize(1); Moveto(150,280);Writestr('Ecliptic of date');  
  Gotoxy(0,10);
  Write('Year ');Readln(y);
  Write('Month ');Readln(m);
  Write('Day ');Readln(day);
  Write('Hour (ET) ');Readln(h);

  jul:=julday(y,m,day,h);
  addl:=addlong(jul);

  long:=mlong(jul)+addl;
  ll:=l(jul)+addl;
  lf:=f(jul)+addl-addomega(jul);
  ld:=d(jul)+addl;
  lp:=p(jul);

  facl:=Ln(1.0+2.208E-6);
  facp:=Ln(1.0-6.832E-8*jul);
  facf:=Ln(1+2.708E-6+139.978*gamma(jul));
    
  ss:=lf*2*Pi+bigs*Pi/648E3; bigc:=gammac/18519.7;
  lat:=(1.0+bigc)*(18519.7*Sin(ss)*Exp(facf)-6.241*sin(3*ss)
       *Exp(3*facf)+n);
  lat:=lat/3600;           

  long:=360*long+longcorr/3600+planlong(jul)/3600+nutation/3600;

  px:=parallax;
  px:=px*(0.999953253+3.9168e-12*Sqr(px));

  Writeln('Parallax ',px:6:2);

  long:=long*Pi/180;  lat:=lat*Pi/180;
  convert(long,lat);

  Writeln('Alpha ',alpha*180/Pi:5:5);
  Writeln('Delta ',delta*180/Pi:5:5);
  
END.
(******************************************************************)
(******************************************************************)      }3  