PROGRAM planet;
CONST
  mlong0:ARRAY(.0..5.) OF Real=(279.6968,
              178.1791,342.7671,293.7476,238.0497,266.565);
  period:ARRAY(.0..5.) OF Real=(365.2422,
              87.96843,224.6954,686.9297,4330.596,10746.94);
  mlong2:ARRAY(.0..5.) OF Real=(6.869E-4,
              2.02E-3,9.81E-4,3.11E-4,3E-4,3E-4);
  perih0:ARRAY(.0..5.) OF Real=(281.2206,
              75.8997,130.1638,334.2182,12.7208,91.0972);
  perih1:ARRAY(.0..5.) OF Real=(1.71777,
              1.555489,1.408036,1.840758,1.6094,1.9575);
  perih2:ARRAY(.0..5.) OF Real=(4.47E-4,
              2.95E-4,-9.76E-4,1.3E-4,0.0,0.0);
  perih3:ARRAY(.0..5.) OF Real=(2.78E-6,
              0.0,0.0,0.0,0.0,0.0);
  omega0:ARRAY(.1..5.) OF Real=(47.14594,75.7796,48.7864,99.4417,112.7889);
  omega1:ARRAY(.1..5.) OF Real=(1.185208,0.89985,0.770992,1.0103,0.8725);
  omega2:ARRAY(.1..5.) OF Real=(1.739E-4,4.1E-4,0.0,0.0,0.0);
  incl0 :ARRAY(.1..5.) OF Real=(7.002881,3.39363,1.85033,1.3086,2.4925);
  incl1 :ARRAY(.1..5.) OF Real=(1.86E-3,1.006E-3,-6.75E-4,-5.56E-3,-3.89E-3);
  ecc0  :ARRAY(.0..5.) OF Real=(0.01675,
         0.20561,0.00682,0.0933129,0.048335,0.055892);
  ecc1  :ARRAY(.0..5.) OF Real=(-4.18E-5,
         2.046E-5,4.774E-5,9.206E-5,1.64E-4,3.45E-4);
  laxis :ARRAY(.0..5.) OF Real=(1.000,
         0.3870987,0.72333,1.52369,5.2028,9.5388);
  name  :ARRAY(.0..6.) OF String(.10.)=('Solen     ','Merkurius ',
               'Venus     ','Mars      ','Jupiter   ','Saturnus  ',
               'M}nen     ');
  mag   :ARRAY(.1..5,0..3.) OF Real=((0.0,1.04,0.3358,0.0),
                                    (-4.0,0.7574,0.0,0.07988),
                                   ( -1.3,0.8514,0.0,0.0),
                                    (-8.93,0.0,0.0,0.0),
                                    (-8.68,2.5,-2.6,1.25));
  gap  :SET OF 0..30=(.5,8,11,14,17,18,23,25,29.);
  signpos:SET OF 0..30=(.0,19,26.);
  offsetx=4;  offsety=1;
  mlength:ARRAY(.0..12.) OF Integer=(31,31,28,31,30,31,30,31,31,30,31,30,31); 
  rens='Rensa '; tstr='t=Tabell '; hstr='h=Horisontsystem ';
  estr='e=Ekvatorialsystem '; rstr='r=Rymdvy '; gstr='g=Gradn{t av/p} ';
       
TYPE str31=String(.31.);
VAR 
  t,jd,sidtime,x,y,z,x0,y0,z0,glatitude,glongitude,hour:Real;
  longitude,latitude,ra,del,azimuth,elevation,magn:Real;
  dfi,savelong,savera,phase:Real;
  l,p:ARRAY(.0..5.) OF Real;
  i,j,year,month,day,felpos,radie,picindex,plindex:Integer;
  instring:str31;
  tempstring:String(.6.);
  ccc,style,oldc:Char;  
  visible, increase, eclcomp:Boolean;
  xsave,ysave:ARRAY(.0..5.) OF Real;
  plgroup:SET OF 0..5;

PROCEDURE hemta_bild;
TYPE enbild=ARRAY(.0..16002.) OF Integer;
VAR   x,y,                 
      steg,cirkelradie,pen  :Integer;
      cirkelradie_real  :Real;
      a                 :Char;
      bild:enbild;
      bildfil:FILE OF enbild;
      m:Mode;
BEGIN
  Assign(bildfil,'BILD.DAT'); Reset(bildfil);
  Read(bildfil,bild);
  Putpic(bild,0,0);
END;  

PROCEDURE nuffra(x,y,i:Integer);
BEGIN
  Penmode(Setbit);
  CASE i OF
    0:BEGIN
        Moveto(x,y); Lineto(x+2,y); Lineto(x+2,y+5);
        Lineto(x,y+5); Lineto(x,y);
      END; 
    1:BEGIN
        Moveto(x+2,y); Lineto(x+2,y+5);
      END;
    2:BEGIN
        Moveto(x+2,y); Lineto(x,y); Lineto(x,y+2);
        Lineto(x+2,y+2); Lineto(x+2,y+5); Lineto(x,y+5);
      END;         
    7:BEGIN
        Moveto(x+2,y); Lineto(x+2,y+5); Lineto(x,y+5);
      END;
    8:BEGIN
        Moveto(x,y); Lineto(x+2,y); Lineto(x+2,y+5);
        Lineto(x,y+5); Lineto(x,y); Moveto(x,y+2);
        Lineto(x+2,y+2);
      END;
    9:BEGIN
        Moveto(x,y); Lineto(x+2,y); Lineto(x+2,y+5);
        Lineto(x,y+5); Lineto(x,y+2); Lineto(x+2,y+2);
      END;
  END;
  Penmode(Reverse);
END;                      
FUNCTION tan(x:Real):Real;
BEGIN
  tan:=Sin(x)/Cos(x);
END;  
FUNCTION sign(x:Real):Integer;
  BEGIN
    IF x=0 THEN sign:=0 ELSE sign:=Round(x/Abs(x));
  END;  
FUNCTION epsilon(x:Real):Real;
  BEGIN
    epsilon:=23.4523-1.302E-2*x;
  END;
FUNCTION modulus(x,z:Real):Real;
  VAR slask:Real;
  BEGIN
    slask:=x-Int(x/z)*z;
    IF slask<0 THEN slask:=slask+z;
    modulus:=slask;
  END;               
FUNCTION mlong(i:Integer;x,jd:Real):Real;
  VAR slask:Real;
  BEGIN
    slask:=mlong0(.i.)+modulus(jd,period(.i.))/period(.i.)*360.0+
           mlong2(.i.)*Sqr(x);
    IF i=0 THEN slask:=slask+6E-4*x;
    mlong:=slask;
  END;
FUNCTION perih(i:Integer;x:Real):Real;
  BEGIN
    perih:=perih0(.i.)+x*(perih1(.i.)+x*(perih2(.i.)+x*perih3(.i.)));
  END;    
FUNCTION omega(i:Integer;x:Real):Real;
  BEGIN
    omega:=omega0(.i.)+x*(omega1(.i.)+x*omega2(.i.));
  END;      
FUNCTION incl(i:Integer;x:Real):Real;
  BEGIN
    incl:=incl0(.i.)+incl1(.i.)*x;
  END; 
FUNCTION ecc(i:Integer;x:Real):Real;
  BEGIN
    ecc:=ecc0(.i.)+ecc1(.i.)*x;
  END;      
PROCEDURE jscorr(x:Real;VAR j,s:Real);
  VAR delta,delj,dels:Real;
  BEGIN
    delta:=(134.63+modulus(jd,322618.0)/322618.0*360)*Pi/180;
    delj:=(0.3303+x*(-2.24E-3-x*1.88E-4))*Sin(delta)+
          x*(-1.28E-2+x*8.3E-5)*Cos(delta);
    dels:=(-0.8121+x*(4.3E-3+x*(6.69E-4-x*5.2E-6)))*Sin(delta)+
          (5.56E-3+x*(3.2E-2+x*(-1.64E-4-x*7E-6)))*Cos(delta);
    j:=j+delj;     s:=s+dels;
  END;              
FUNCTION eccanomali(m,e:Real):Real;
  VAR slask0,slask:Real;  i:Integer;
  BEGIN
    slask0:=m*Pi/180; slask:=slask0;
    FOR i:=1 TO 4 DO slask:=slask-(slask-slask0-e*Sin(slask))/(1-e*Cos(slask));
    eccanomali:=slask;
  END;  
PROCEDURE elements;
  VAR i:Integer;
  BEGIN
    FOR i:=0 TO 5 DO
      BEGIN
        l(.i.):=mlong(i,t,jd);   
        p(.i.):=perih(i,t);
      END;
    jscorr(t,l(.4.),l(.5.));
  END;      
PROCEDURE moon(x,jd:Real; VAR xmoon,ymoon,zmoon:Real);
  VAR amoon,slask,slask1,g0,g2,w2,w3,o1,lsun,psun,f,d:Real;
  BEGIN
    lsun:=mlong(0,x,jd); psun:=perih(0,x);
    g2:=296.108+modulus(jd,27.554550281)/27.554550281*360.0+
       x*x*(0.013682+x*0.000015);    
    w2:= 75.146+modulus(jd,2190.342)/2190.342*360.0+
       x*x*(-0.01243-x*0.000015);    
    o1:=259.183-modulus(jd,6798.372)/6798.372*360.0+
       x*x*(0.002099+x*0.000002);          
    g0:=lsun-psun;
    w3:=w2-psun+o1; f:=(g2+w2)*Pi/180;  d:=(g2-g0+w3)*Pi/180;
    g2:=g2*Pi/180;  g0:=g0*Pi/180;
    slask:=0.658*Sin(2*d)+0.053*Sin(g2+2*d)+6.289*Sin(g2)
          -1.274*Sin(g2-2*d)-0.011*Sin(g2-4*d)-0.007*Sin(g0+2*d)
          -0.186*Sin(g0)-0.046*Sin(g0-2*d)-0.035*Sin(d)
          +0.214*Sin(2*g2)-0.059*Sin(2*(g2-d))-0.009*Sin(2*(g2-2*d))
          -0.030*Sin(g2+g0)-0.057*Sin(g2+g0-2*d)+0.047*Sin(g2-g0)
          +0.008*Sin(g2-g0-2*d)-0.114*Sin(2*f)-0.015*Sin(2*(f-d))
          +0.005*(Sin(g2-d)+Sin(g0+d))+0.010*Sin(3*g2)
          -0.013*Sin(g2+2*f)+0.011*Sin(g2-2*f);
    slask1:=f+slask*Pi/180;  slask1:=5.144*Sin(slask1);
    slask1:=slask1-0.146*Sin(f-2*d)+0.012*Sin(g2+f-2*d)
           +0.006*Sin(f-g2)-0.008*Sin(f-g2-2*d)-0.007*Sin(f-2*g2)
           -0.006*Sin(g0+f-2*d);
    slask1:=slask1*Pi/180;             
    slask:=g2+(w2+o1+slask)*Pi/180; 
    WHILE slask>2*Pi DO slask:=slask-2*Pi;
    amoon:=0.9507+0.0078*Cos(2*d)+0.0518*Cos(g2)
          +0.0095*Cos(g2-2*d)+0.0028*Cos(2*g2);
    amoon:=0.9507/amoon;
    xmoon:=amoon*Cos(slask1)*Cos(slask);
    ymoon:=amoon*Cos(slask1)*Sin(slask);
    zmoon:=amoon*Sin(slask1);
 END;
PROCEDURE coordinate(i:Integer;VAR x,y,z:Real);
  VAR e,m,ea,a:Real;
  BEGIN
    IF i<>6 THEN
      BEGIN
        e:=ecc(i,t);   m:=l(.i.)-p(.i.); ea:=eccanomali(m,e);
        x:=laxis(.i.)*(Cos(ea)-e);
        y:=laxis(.i.)*Sin(ea)*Sqrt(1-e*e);
        z:=0;
      END
    ELSE moon(t,jd,x,y,z);    
  END;  
PROCEDURE rotz(angle:Real;VAR x,y,z:Real);
  VAR slask,ss,cc:Real;
  BEGIN
    ss:=Sin(angle*Pi/180); cc:=Cos(angle*Pi/180);
    slask:=x*cc+y*ss;    y:=-x*ss+y*cc; x:=slask;
  END;
PROCEDURE rotx(angle:Real;VAR x,y,z:Real);
  VAR slask,ss,cc:Real;
  BEGIN
    ss:=Sin(angle*Pi/180); cc:=Cos(angle*Pi/180);
    slask:=y*cc+z*ss;    z:=-y*ss+z*cc; y:=slask;
  END;    
PROCEDURE roty(angle:Real;VAR x,y,z:Real);
  VAR slask,ss,cc:Real;
  BEGIN
    ss:=Sin(angle*Pi/180); cc:=Cos(angle*Pi/180);
    slask:=z*cc+x*ss;    x:=-z*ss+x*cc; z:=slask;
  END;      

PROCEDURE cartopol(x,y,z:Real;VAR rectasc,delta:Real);
  VAR slask,denom:Real;
  BEGIN
    IF x<>0 THEN rectasc:=Arctan(y/x) ELSE rectasc:=Pi/2*sign(y);
    denom:=Sqrt(Sqr(x)+Sqr(y));
    IF denom<>0 THEN delta:=Arctan(z/denom) ELSE delta:=Pi/2*sign(z);
    IF x<0 THEN rectasc:=rectasc+Pi;
    IF rectasc<0 THEN rectasc:=rectasc+2*Pi;
    rectasc:=rectasc*180/Pi;  delta:=delta*180/Pi;
  END;    
PROCEDURE magnitud(i:Integer);
  VAR r0,r1,d,cc,ang,om,inc,b,x8,y8,z8,x9,y9,z9:Real;
  BEGIN
    r0:=Sqr(x0)+Sqr(y0)+Sqr(z0);
    r1:=Sqr(x)+Sqr(y)+Sqr(z);
    d:=Sqr(x+x0)+Sqr(y+y0)+Sqr(z+z0);
    IF i<>5 THEN
      BEGIN
        cc:=(d+r1-r0)/Sqrt(r1*d)/2;
        IF cc=0 THEN ang:=Pi/2
        ELSE
          BEGIN
            IF Abs(cc)>1 THEN cc:=sign(cc);
            ang:=Arctan(Sqrt(1-Sqr(cc))/cc);
          END;
        IF ang<0 THEN ang:=ang+Pi;
        magn:=mag(.i,0.)+5*0.43429*Ln(Sqrt(r1*d))+
              ang*(mag(.i,1.)+ang*(mag(.i,2.)+ang*mag(.i,3.)));
      END
    ELSE
      BEGIN
        om:=168.12+1.4*t; inc:=28.07-0.0012*t;
        x8:=x; y8:=y; z8:=z;
        x9:=x+x0; y9:=y+y0; z9:=z+z0;
        rotz(om,x8,y8,z8); rotx(inc,x8,y8,z8);
        rotz(om,x9,y9,z9); rotx(inc,x9,y9,z9);
        b:=Abs(z9/Sqrt(Sqr(x9)+Sqr(y9)+Sqr(z9)));
        cc:=(x8*x9+y8*y9)/Sqrt(Sqr(x8)+Sqr(y8))/Sqrt(Sqr(x9)+Sqr(y9));
        IF cc>1 THEN cc:=1;
        ang:=Arctan(Sqrt(1/Sqr(cc)-1));
        magn:=mag(.i,0.)+5*0.43429*Ln(Sqrt(r1*d))+
              mag(.i,1.)*Abs(ang)+b*(mag(.i,2.)+b*mag(.i,3.));
      END;
  END;            

PROCEDURE local_coord(i:Integer;VAR x,y,z:Real);
VAR xs,ys,zs:Real;
  BEGIN
    coordinate(i,x,y,z);
    IF (i<>0) AND (i<>6) THEN
      BEGIN
        rotz(-p(.i.)+omega(i,t),x,y,z);
        rotx(-incl(i,t),x,y,z);  rotz(-omega(i,t),x,y,z);
        IF i<>0 THEN magnitud(i);
        xsave(.i.):=x;  ysave(.i.):=y;
        x:=x+x0; y:=y+y0; z:=z+z0;
      END
    ELSE 
      IF i=0 THEN
        BEGIN
          rotz(-p(.i.),x,y,z);  
          x0:=x;  y0:=y; z0:=z;
          xsave(.0.):=-x; ysave(.0.):=-y;
        END;
                
    cartopol(x,y,z,longitude,latitude);
    IF i=0 THEN savelong:=longitude;
    IF i=6 THEN 
      BEGIN
        phase:=longitude-savelong;
        WHILE phase<0 DO phase:=phase+360.0;
        phase:=phase/180.0;
        IF phase>1 THEN phase:=phase-2;
      END;  
    rotx(-epsilon(t),x,y,z); 
    (*cartopol(x,y,z,ra,del);*)
    rotz(sidtime,x,y,z); 
    IF i=6 THEN dfi:=0.193*Sin(2*glatitude*Pi/180) ELSE dfi:=0;
    roty(90-glatitude+dfi,x,y,z);
    IF i=6 THEN 
      BEGIN
        z:=z-0.016592;
        roty(-dfi,x,y,z);
      END;  
    cartopol(x,y,z,azimuth,elevation);
    xs:=x; ys:=y; zs:=z;
    azimuth:=360-azimuth;
    roty(-90+glatitude,x,y,z);
    rotz(-sidtime,x,y,z);
    cartopol(x,y,z,ra,del);
    IF i=0 THEN savera:=ra;
    x:=xs; y:=ys; z:=zs;
  END;      

FUNCTION julday(y,m,d:Integer;h:Real;c:Char):Real;
  VAR slask:Real; cent,excess:Integer;
  BEGIN
    IF m>2 THEN 
      m:=m-3 
    ELSE
      BEGIN
        m:=m+9; y:=y-1;
      END;
    slask:=Int((153*m+2)/5)+d;
    cent:=y DIV 100; IF y<0 THEN cent:=cent-1;
    excess:=Round(modulus(y,100));
    slask:=slask+Int(excess*365.25);
    IF c='G' THEN
      slask:=slask+Int(cent*36524.25)-693901.0
    ELSE
      slask:=slask+Int(cent*36525.00)-693903.0;
    h:=Int(h)+Frac(h)/0.6-12;
    julday:=slask+h/24;
  END;  
PROCEDURE matrix;
  VAR i:Integer;
  BEGIN
    FOR i:=0 TO 6 DO 
      BEGIN
        Gotoxy(offsetx,4+i+offsety); Write(name(.i.):10);
      END;  
    Gotoxy(13+offsetx,2+offsety);Write('Long'); 
    Gotoxy(21+offsetx,2+offsety);Write('Lat');
    Gotoxy(29+offsetx,2+offsety);Write('R.A.'); 
    Gotoxy(36+offsetx,2+offsety);Write('Dekl');
    Gotoxy(44+offsetx,2+offsety);Write('Azimut');
    Gotoxy(52+offsetx,2+offsety);Write('H|jd');
    Gotoxy(59+offsetx,2+offsety);Write('Magnitud');
  END;
PROCEDURE forestep(VAR i:Integer);
  BEGIN
    i:=(i+1) MOD 31;
    WHILE i IN gap DO i:=(i+1) MOD 31;
    Gotoxy(i+20+offsetx,offsety);
  END;  
PROCEDURE backstep(VAR i:Integer);
  BEGIN
    i:=i-1;
    WHILE i IN gap DO i:=i-1;
    IF i<0 THEN i:=30;
    Gotoxy(i+20+offsetx,offsety);
  END;    
PROCEDURE drawtext;
  BEGIN
    Moveto(177+8*offsetx,400-offsety*16); Writestr(']r');
    Moveto(200+8*offsetx,400-offsety*16); Writestr('m}n');
    Moveto(227+8*offsetx,400-offsety*16); Writestr('dag');
    Moveto(255+8*offsetx,400-offsety*16); Writestr('kl(UT)');
    Moveto(323+8*offsetx,400-offsety*16); Writestr('long');
    Moveto(380+8*offsetx,400-offsety*16); Writestr('lat');
    Gotoxy(68,24);Write(' f|r hj{lp');
  END;  
PROCEDURE fill_matrix(i:Integer);
VAR sidh,sidm,msh,msm:Integer; ms:Real;
  BEGIN
    IF visible THEN
      BEGIN
        Penmode(Setbit);
        Rect(offsetx*8-3,383-(4+i+offsety)*16,82,16);
      END
    ELSE 
      BEGIN
        Penmode(Clearbit);
        Rect(offsetx*8-3,383-(4+i+offsety)*16,82,16);
      END;
     Penmode(Reverse);     
     Gotoxy(10+offsetx,i+4+offsety);
     Write(longitude:8:2); Write(latitude:7:2);
     Write(ra:9:2);        Write(del:7:2);
     Write(azimuth:9:2);   Write(elevation:7:2);
     IF (i<>0) AND (i<>6) THEN Write(magn:9:2);
     IF i=6 THEN 
       BEGIN
         Write('   F',phase:5:2);
         Gotoxy(10+offsetx,19); Write('                         ');
         Gotoxy(10+offsetx,19);  
         IF Abs(phase)>0.995 THEN
           BEGIN
             Write('M}nf|rm|rkelse ');
             IF Abs(latitude)<1.06 THEN 
               IF Abs(latitude)>0.89 THEN Write('m|jlig');
             IF Abs(latitude)>=1.06 THEN Write('ej m|jlig');
           END;  
         IF Abs(phase)<0.005 THEN
           BEGIN
             Write('Solf|rm|rkelse ');
             IF Abs(latitude)<1.58 THEN 
               IF Abs(latitude)>1.41 THEN Write('m|jlig');
             IF Abs(latitude)>=1.58 THEN Write('ej m|jlig');
           END;
       END;            
     IF i=0 THEN
       BEGIN
         Gotoxy(10+offsetx,15); Write('                       ');  
         Gotoxy(10+offsetx,15); 
         ms:=modulus(Trunc(hour)+Frac(hour)/0.6+glongitude*24/360,24.0);
         msh:=Trunc(ms); msm:=Round(Frac(ms)*60);
         Write('Medelsoltid:',msh:4,'h',msm:3,'m');
         Gotoxy(10+offsetx,16); Write('                       ');  
         Gotoxy(10+offsetx,16); 
         ms:=modulus((l(.0.)-savera-0.0057)*24.0*60/360.0,60);
         IF ms>30 THEN ms:=ms-60;
         msh:=Trunc(ms); msm:=Round(Abs(Frac(ms)*60));
         Write('Tidsekvation:',msh:3,'m',msm:3,'s');
         Gotoxy(10+offsetx,17); Write('                       ');  
         Gotoxy(10+offsetx,17); 
         sidh:=Trunc(sidtime*24/360);
         sidm:=Round(Frac(sidtime*24/360)*60);
         Write('Stj{rntid:',sidh:6,'h',sidm:3,'m');
       END;
   END;  
PROCEDURE drawgrid;
VAR i:Integer;  
  BEGIN
    Linetype($1111);
    Plot(320,187);
    CASE picindex OF
    1:BEGIN
        FOR i:=1 TO 8 DO Circle(320,187,i*20);
        FOR i:=0 TO 11 DO
          BEGIN
            Moveto(Round(320+20*Sin(2*Pi/12*i)),
               Round(187+20*Cos(2*Pi/12*i)));;
            Lineto(Round(320+180*Sin(2*Pi/12*i)),
               Round(187+180*Cos(2*Pi/12*i)));
          END;  
        Linetype($FFFF);
      END;
    2:BEGIN
        FOR i:=1 TO 2 DO Circle(320,187,Round(104*tan(i*Pi/12)));
        FOR i:=0 TO 11 DO
          BEGIN
            Moveto(Round(320+104*tan(Pi/12)*Sin(2*Pi/12*i)),
               Round(187+104*tan(Pi/12)*Cos(2*Pi/12*i)));;
            Lineto(Round(320+104*tan(Pi/3)*Sin(2*Pi/12*i)),
               Round(187+104*tan(Pi/3)*Cos(2*Pi/12*i)));
          END;  
        Linetype($FFFF);  
      END;    
  END; 
END;
PROCEDURE stepit(VAR y,m,d:Integer; VAR instr:str31);
VAR  dstr,mstr,ystr:String(.5.);
BEGIN
  d:=d+5;
  IF mlength(.m.)<d THEN
    BEGIN  d:=d-mlength(.m.); m:=m+1 END;
  IF m>12 THEN
    BEGIN  
      m:=1; y:=y+1 END; 
  Str(d,dstr); WHILE Len(dstr)<2 DO dstr:='0'+dstr; 
  Str(m,mstr); WHILE Len(mstr)<2 DO mstr:='0'+mstr; 
  Str(y,ystr); 
    WHILE Len(ystr)<5 DO
      IF (ystr(.1.)='-') OR (ystr(.1.)=' ') THEN 
        ystr:=ystr(.1.)+'0'+Copy(ystr,2,Len(ystr))
      ELSE  ystr:=' '+ystr;
  instr:=ystr+'-'+mstr+'-'+dstr+Copy(instr,12,Len(instr));

END;    
PROCEDURE drawecl(xx,yy,r1,r2:Integer);
VAR i:Integer;
    x01,x02,x11,x12:Integer; 
    cut0,cut1:Boolean;
PROCEDURE circlecut(ycut,x0,y0,r:Integer;VAR x1,x2:Integer;VAR cut:Boolean);
VAR slask:Real;
BEGIN
  cut:=TRUE;
  slask:=Sqr(r*1.0)-Sqr((ycut-y0)*1.0);
  IF slask<0 THEN 
    cut:=FALSE
  ELSE
    BEGIN
      x1:=Round(x0-Sqrt(slask));
      x2:=Round(x0+Sqrt(slask));
    END;
END;
BEGIN
  Penmode(Clearbit); Rectfill(170,125,469,150); Penmode(Setbit);
  FOR i:=-150 TO 150 DO
    BEGIN
      circlecut(i,0,0,r1,x01,x02,cut0);
      IF cut0 THEN
        BEGIN
          circlecut(i,xx,yy,r2,x11,x12,cut1);
          IF NOT cut1 THEN 
            BEGIN
              Moveto(x01+320,i+200);
              Lineto(x02+320,i+200);
            END
          ELSE
            IF NOT((x11<=x01) AND (x02<=x12)) THEN
            IF (x01<x11) AND (x12<x02) THEN
              BEGIN
                Moveto(x01+320,i+200);
                Lineto(x11+320,i+200);
                Moveto(x12+320,i+200);
                Lineto(x02+320,i+200);
              END
            ELSE    
            IF (x01<x11) AND (x11<x02) THEN
              BEGIN
                Moveto(x01+320,i+200);
                Lineto(x11+320,i+200);
              END
            ELSE
              IF (x01<x12) AND (x12<x02) THEN
                BEGIN
                  Moveto(x12+320,i+200);
                  Lineto(x02+320,i+200);    
                END
              ELSE
                BEGIN
                  Moveto(x01+320,i+200);
                  Lineto(x02+320,i+200);
                END;
            END;            
       END;
   
 END;


PROCEDURE compecl;
TYPE  etype=(sun,moon);
CONST  eclword:ARRAY(.sun..moon.) OF String(.3.)=('SOL','M]N');
VAR
  sazimuth,selevation,slong,mazimuth,melevation,mlong,diff:Real;
  sx,sy,sz,mx,my,mz,as,am,rcenter,rshadow,d,ksi,z,dx,dy:Real;
  ecltype:etype;
  visib:Boolean;
BEGIN
  visib:=TRUE;
  local_coord(0,x,y,z); sazimuth:=azimuth; selevation:=elevation;
  slong:=longitude; sx:=x; sy:=y; sz:=z;
  local_coord(6,x,y,z); mazimuth:=azimuth; melevation:=elevation;
  mlong:=longitude; mx:=x; my:=y; mz:=z;
  diff:=Abs(slong-mlong);  IF diff>180 THEN diff:=Abs(diff-360);
  IF diff<90 THEN ecltype:=sun ELSE ecltype:=moon;
  CASE ecltype OF
    sun: BEGIN
           Gotoxy(60,6); Write('SOLF\RM\RKELSE');
           rotz(-sazimuth,sx,sy,sz); rotz(-sazimuth,mx,my,mz);
           roty(-selevation,sx,sy,sz); roty(-selevation,mx,my,mz);
           am:=Sqrt(Sqr(mx)+Sqr(my)+Sqr(mz));
           as:=Sqrt(Sqr(sx)+Sqr(sy)+Sqr(sz));
           dx:=-200.0*180.0/Pi*(my/mx);
           dy:=200.0*180.0/Pi*(mz/mx);
           rcenter:=200.0*0.2666/as;
           rshadow:=200.0*0.2589/am;
           drawecl(Round(dx),Round(dy),Round(rcenter),Round(rshadow));
           IF selevation<-0.85 THEN visib:=FALSE;
         END;
   moon: BEGIN
           Gotoxy(60,6); Write('M]NF\RM\RKELSE');
           mz:=mz+0.0165925;  cartopol(mx,my,mz,mazimuth,melevation);
           mazimuth:=360-mazimuth;
           rotz(-mazimuth,sx,sy,sz); rotz(-mazimuth,mx,my,mz);    
           roty(-melevation,sx,sy,sz); roty(-melevation,mx,my,mz);
           am:=Sqrt(Sqr(mx)+Sqr(my)+Sqr(mz));
           as:=Sqrt(Sqr(sx)+Sqr(sy)+Sqr(sz));
           dx:=-200.0*180.0/Pi*(sy/sx);
           dy:=200.0*180.0/Pi*(sz/sx);
           rcenter:=200.0*0.2589/am;
           rshadow:=200.0*1.02*(0.9491/am-0.2641/as);
           drawecl(Round(dx),Round(dy),Round(rcenter),Round(rshadow));
           IF melevation<-0.85 THEN visib:=FALSE;
         END;
  END;
  d:=Sqrt(Sqr(dx)+Sqr(dy))/rcenter;
  ksi:=rshadow/rcenter;
  IF d<(1-ksi) THEN
    BEGIN
      z:=ksi; Gotoxy(55,8); Write('Ringformig');
    END
  ELSE 
    z:=(1+ksi-d)/2;
  IF z<0  THEN   z:=0;
  Gotoxy(53,10);
  IF z>=1 THEN 
    Write('Total f|rm|rkelse')
  ELSE
    IF z>0 THEN Write('Partiell f|rm|rkelse',100*z:6:1,'%');
  Gotoxy(53,11); 
  IF NOT visib THEN Write(eclword(.ecltype.):3,'EN under horisonten');
END;

PROCEDURE comput(instring:str31);
VAR i:Integer; rarad,delrad:Real;
BEGIN
  tempstring:=Copy(instring,1,5);
  WHILE Copy(tempstring,1,1)=' ' DO Delete(tempstring,1,1);
  Val(tempstring,year,felpos);
  Val(Copy(instring,7,2),month,felpos);
  Val(Copy(instring,10,2),day,felpos);
  Val(Copy(instring,13,5),hour,felpos);
  tempstring:=Copy(instring,20,8);
  WHILE Copy(tempstring,1,1)=' ' DO Delete(tempstring,1,1);
  Val(tempstring,glongitude,felpos);
  tempstring:=Copy(instring,27,5);
  WHILE Copy(tempstring,1,1)=' ' DO Delete(tempstring,1,1);
  Val(tempstring,glatitude,felpos);
  REPEAT
  jd:=julday(year,month,day,hour,style);
  t:=jd/36525.0;
  elements; 
  sidtime:=l(.0.)+(Int(hour)+Frac(hour)/0.6-12)/24*360+
                 glongitude-0.0057;

  sidtime:=modulus(sidtime,360.0);
  IF picindex=4 THEN compecl;
  FOR i:=0 TO 6 DO 
   IF i IN plgroup THEN
    BEGIN
      local_coord(i,x,y,z);   
      visible:=FALSE;
      CASE i OF
        1,2,3,4,5: IF elevation>-0.55 THEN visible:=TRUE;
        0,6: IF elevation>-0.85 THEN visible:=TRUE;
      END;          
      CASE picindex OF
      0:fill_matrix(i);  
      1:BEGIN
          IF i=0 THEN radie:=2 ELSE radie:=1;
          IF elevation>0 THEN
            IF i=6 THEN 
              Rectfill(319+Round((180-2*elevation)*Sin(Pi*azimuth/180)),
                   186-Round((180-2*elevation)*Cos(Pi*azimuth/180)),2,2)
            ELSE       
              BEGIN
                Circle(320+Round((180-2*elevation)*Sin(Pi*azimuth/180)),
                       187-Round((180-2*elevation)*Cos(Pi*azimuth/180)),
                       radie);
                Plot(320+Round((180-2*elevation)*Sin(Pi*azimuth/180)),
                     187-Round((180-2*elevation)*Cos(Pi*azimuth/180))) 
             END 
        END;
      2:BEGIN 
          radie:=1; rarad:=Pi*ra/180; delrad:=(90-del)*Pi/360;
          IF i=plindex THEN 
            BEGIN
              IF i=0 THEN
                Circle(320+Round(104*Sin(rarad)*tan(delrad)),
                     187-Round(104*Cos(rarad)*tan(delrad)),
                     radie);
              Plot(320+Round(104*Sin(rarad)*tan(delrad)),
                     187-Round(104*Cos(rarad)*tan(delrad)));
             END;
        END;
      3:Plot(Round(320+20*xsave(.i.)),Round(200+20*ysave(.i.)));
          
      
      END;
    END;  
    IF Keypress THEN BEGIN increase:=False; Penmode(Reverse) END;
    IF increase THEN 
      BEGIN
        stepit(year,month,day,instring);
        Gotoxy(20+offsetx,offsety); Write(instring);
      END;  
    UNTIL NOT increase;
  END;
PROCEDURE drawchar;
 BEGIN
   Moveto(322,6); Lineto(318,6);
   Lineto(318,3); Lineto(322,3);
   Lineto(322,0); Lineto(318,0);
   Moveto(134,190);Lineto(134,184);
   Moveto(135,184);Lineto(138,184);
   Moveto(135,190);Lineto(138,190);
   Moveto(135,187);Lineto(137,187);
   Moveto(502,190);Lineto(502,184);
   Moveto(503,185);Lineto(504,187);
   Moveto(505,186);Lineto(506,185);
   Moveto(507,184);Lineto(507,190);
 END;      
PROCEDURE drawdigits;
 BEGIN
   nuffra(319,0,0);
   nuffra(126,185,2); nuffra(130,185,7);nuffra(134,185,0);
   nuffra(502,185,9); nuffra(506,185,0);
 END;  

PROCEDURE help;
VAR bild:ARRAY(.0..5202.) OF Integer; c:Char;
BEGIN
  Cursoroff;  Getpic(bild,0,0,200,400);
  Gotoxy(0,0);Write(Rvson);
  Writeln('      Styrtecken        ');   Write(Rvsoff);
  Writeln('t=Tabell/rensa tabell   ');
  Writeln('h=Horisontsystem/rensa  ');
  Writeln('e=Ekliptikasystem/rensa ');
  Writeln('r=Rymdvy/rensa          ');
  Writeln('f=F|rm|rkelse           ');
  Writeln('g=Gradn{t av/p}         ');
  Writeln('(endast vid h och e)    ');
  Writeln('                        ');
  Writeln('i=automatstegning       ');
  Writeln('(vid e och r,           ');
  Writeln('avbrytes med mellanslag)');
  Writeln('                        ');
  Writeln(' =Flytta i datum/plats');
  Writeln(' =Bl{ddra (h och e)   ');
  Writeln('=G|r ber{kning         ');
  Writeln('                        ');
  Writeln('s=[ndra tider{kning     ');
  Writeln('gregoriansk-juliansk    ');
  Writeln('                        ');
  Writeln('AVBRYT=Sluta            ');
  Writeln('= ]ter fr}n denna hj{lp');
  Writeln('');
  REPEAT Read(Kbd,c) UNTIL c='';
  ccc:=oldc; 
  FOR i:=0 TO 24 DO 
    BEGIN
      Gotoxy(0,i); Write('                         ');
    END;  
  Putpic(bild,0,0); Cursoron;
END;  
  
BEGIN    
    Initturtle;
    hemta_bild; Read(Kbd,ccc);
    Initturtle; Cursoron; style:='G'; j:=1; increase:=False;
    drawtext; picindex:=0; plgroup:=(.0..6.);
    instring:=' 0000-00-00 00.00   000.0  00.0';
    matrix; Gotoxy(j+18+offsetx,offsety);Write(style,instring);
    Penmode(Reverse);  oldc:=' ';
    REPEAT 
      IF increase THEN comput(instring);
      Cursoron; Gotoxy(j+20+offsetx,offsety); Read(Kbd,ccc);
      CASE ccc OF
        ''    :IF picindex=2 THEN
                  BEGIN
                    plindex:=plindex-1;
                    IF plindex<0 THEN plindex:=6;
                    Gotoxy(5,5); Write(name(.plindex.));
                    plgroup:=(.0,plindex.);
                  END;
        ''    :IF picindex=2 THEN
                  BEGIN
                    plindex:=(plindex+1) MOD 7;
                    Gotoxy(5,5); Write(name(.plindex.));
                    plgroup:=(.0,plindex.);
                  END; 
        ''    :forestep(j);
        ''    :backstep(j);
        '-',' ':IF j IN signpos THEN  
                  BEGIN
                    instring(.j+1.):=ccc;
                    Write(ccc);
                    forestep(j);
                  END
                ELSE forestep(j);  
        '0'..'9':IF NOT(j IN signpos) THEN
                   BEGIN
                     instring(.j+1.):=ccc;
                     Write(ccc);
                     forestep(j);
                   END;  
         ''    :BEGIN
                   Cursoroff;
                   comput(instring);
                   IF oldc<>'' THEN backstep(j);
                       
                 END;  
        'S',
        's':BEGIN
              IF style='G' THEN style:='J' ELSE style:='G';
              Gotoxy(19+offsetx,offsety);Write(style);
            END;  
        'H',
        'h':BEGIN
             Initturtle; Penmode(Reverse); Gotoxy(66,0);
             Write('HORISONTSYSTEM');
             drawtext; picindex:=1; plgroup:=(.0..6.);
             Gotoxy(19+offsetx,offsety);Write(style,instring);
             Circle(320,187,180);
             drawchar;
            END;
        'T',
        't':BEGIN
             Initturtle; Penmode(Reverse);
             drawtext; picindex:=0; plgroup:=(.0..6.);
             Gotoxy(19+offsetx,offsety);Write(style,instring);
             matrix;
            END;    
        'G',
        'g':IF (picindex=1) OR (picindex=2) THEN drawgrid;
        'E',
        'e':BEGIN
              Initturtle; Penmode(Reverse);  
              Gotoxy(63,0); Write('EKLIPTISKT SYSTEM');
              drawtext; picindex:=2; plindex:=0; plgroup:=(.plindex.);
              Gotoxy(19+offsetx,offsety);Write(style,instring);
              Linetype($1111);Circle(320,187,180);
              Linetype($FFFF);Circle(320,187,104);
              drawdigits; Gotoxy(5,5); Write(name(.plindex.));
            END;  
        'R',
        'r':BEGIN
              Initturtle; plgroup:=(.0..5.);
              Gotoxy(66,0); Write('PLANETSYSTEMET');
              Penmode(Setbit); Plot(320,200); Circle(320,200,1);
              drawtext; picindex:=3;
              Gotoxy(19+offsetx,offsety);Write(style,instring); 
            END;  
        'I',
        'i':IF picindex>1 THEN
              BEGIN
                increase:=True;
                Penmode(Setbit);
              END;  
        
        'f',
        'F':BEGIN
              Initturtle;  plgroup:=(..); 
              drawtext; picindex:=4;
              Gotoxy(19+offsetx,offsety);Write(style,instring); 
            END;  
        '':help;
      END;  
      oldc:=ccc;    
    UNTIL ccc='';
    Gotoxy(0,23);
END.  
R}3                      COMPIS SCANDIS/H1IS            PY                   E