PROGRAM solcoord;
(*-----------------------------------------------------------*)
VAR
       radius,alpha,delta:Real;
       rad,alph,del,dt   :Real;
       xsol,ysol,zsol,jd:Real;
       julcent:Real;
       epsilon:Real;
       deleps,delfi:Real;
       trueeps:Real;
       ch   :Char;
(*--------------------------------------------------*)
FUNCTION moddy(x,y:Real):Real;
VAR   z:Integer;
BEGIN
  z:=Trunc(x/y); IF x<0 THEN z:=z-1; 
  moddy:=x-y*z;
END;
(*--------------------------------------------------*)
FUNCTION julday:Real;
VAR
  year,month,day:Integer;
  century,excess:Integer;
  jul,hour:Real;
  ch:Char;

BEGIN
  Write('Calendar (julian (j), gregorian(g)'); Readln(ch);
  Writeln;
  Write('Year     : '); Readln(year);
  Write('Month    : '); Readln(month);
  Write('Day      : '); Readln(day);
  IF month<3 THEN
    BEGIN
      month:=month+9;
      year:=year-1;
    END
  ELSE
    month:=month-3;
  century:=year DIV 100;
  excess:=year MOD 100;
  jul:=INT(1461.0*excess/4.0)+INT((153.0*month+2.0)/5.0)+day;
  IF ch='g' THEN
    jul:=jul+INT(146097.0*century/4.0)-693901.5  (*1721118.5*)  
  ELSE  
    jul:=jul+INT(146100.0*century/4.0)-693903.5; (*1721116.5*)      
  IF year<0 THEN jul:=jul-1;
  Write('Hour (ET): ');Readln(hour);
  julday:=jul+hour/24.0;
END;
(*-----------------------------------------------------*)
PROCEDURE sol;
VAR 
  long,anomaly:Real;
  gt,gv,gm,gj,gs,omega,d:Real;  
  pix,c,cv,a,radius_vector:Real;
  bmoon,pimoon,pisol,moonanomaly,moonlom,moonlong,lat:Real;  
  gammap:Real;

BEGIN
  pix:=Pi/180.0;
  jd:=julday;
  julcent:=jd/36525.0;
  long:=279.696678+(36000.768925+3.025E-4*julcent)*julcent;
  anomaly:=358.475833+(35999.04975+julcent*(-1.5E-4-julcent*3.3E-6))*julcent;
  long:=moddy(long,360.0); anomaly:=moddy(anomaly,360.0);  
  gt:=anomaly*pix;
  gv:=(212.60+moddy(58517.804*julcent,360.0))*pix;
  gm:=(319.53+moddy(19139.859*julcent,360.0))*pix;
  gj:=(225.34+moddy( 3034.692*julcent,360.0))*pix;
  gs:=(175.48+moddy( 1221.553*julcent,360.0))*pix;
  omega:=((1266E-25*jd+432630E-20)*jd-1.47094228332E-4)*jd+0.71995354167;
  omega:=moddy(omega,1.0);    
  d:=((1077E-25*jd-299023E-20)*jd+0.033863192198393)*jd+0.97427079475;
  d:=moddy(d,1.0);
  moonlong:=(d*360.0+long);
  gammap:=334.329556+jd*(0.11140400803+jd*(-7.739E-12-jd*2.6E-19));
  gammap:=moddy(gammap,360.0); 
  moonanomaly:=(moonlong-gammap)*pix;
  moonlom:=(moonlong-omega*360.0)*pix;
  c:=Sin(gt)*(1.9194602-julcent*(4.789E-3+julcent*1.4E-5))+
     Sin(2*gt)*(2.0093E-2-julcent*1.003E-4)+
     Sin(3*gt)*2.928E-4;
  
  cv:=4.838*Cos(299.1 *pix+  gv-  gt)+0.116*Cos(148.9 *pix+2*gv-  gt)+
      5.526*Cos(148.31*pix+2*(gv-gt))+2.497*Cos(315.94*pix+2*gv-3*gt)+
      0.666*Cos(177.71*pix+3*gv-3*gt)+1.559*Cos(345.25*pix+3*gv-4*gt)+
      1.024*Cos(318.15*pix+3*gv-5*gt)+0.210*Cos(206.2 *pix+4*gv-4*gt)+
      0.144*Cos(195.4 *pix+4*gv-5*gt)+0.123*Cos(195.3 *pix+5*gv-7*gt)+
      0.273*Cos(217.7 *pix-  gm+  gt)+2.043*Cos(343.89*pix-2*gm+2*gt)+
      1.770*Cos(200.40*pix-2*gm+  gt)+0.129*Cos(294.2 *pix-3*gm+3*gt)+
      0.425*Cos(338.88*pix-3*gm+2*gt)+0.500*Cos(105.18*pix-4*gm+3*gt)+
      0.585*Cos(334.06*pix-4*gm+2*gt)+0.154*Cos(227.4 *pix-6*gm+4*gt)+
      0.163*Cos(198.6 *pix-  gj+2*gt)+7.208*Cos(179.53*pix-  gj+  gt)+
      2.600*Cos(263.22*pix     -  gj)+2.731*Cos( 87.14*pix-2*gj+2*gt)+
      1.610*Cos(109.49*pix-2*gj+  gt)+0.164*Cos(170.5 *pix-3*gj+3*gt)+
      0.556*Cos( 82.65*pix-3*gj+2*gt)+0.210*Cos( 98.5 *pix-3*gj+  gt)+
      0.419*Cos(100.58*pix-  gs+  gt)+0.320*Cos(269.46*pix-  gs)     +
      0.108*Cos(290.6 *pix-2*gs+2*gt)+0.112*Cos(293.6 *pix-2*gs+  gt);
  c:=c+cv/3600.0;
  a:=3057.0-15.0*julcent+Cos(gt)*(-727412.0+julcent*(1814.0+julcent*5.0))+
                       Cos(2*gt)*(-9138.0+julcent*46.0)+
                       Cos(3*gt)*(-145.0 +julcent)+
     235.9*Cos(209.10*pix+  gv-  gt)+ 16.0*Cos( 58.40*pix+2*gv-  gt)+
     684.2*Cos( 58.32*pix+2*gv-2*gt)+ 86.9*Cos(226.70*pix+2*gv-3*gt)+
     104.5*Cos( 87.57*pix+3*gv-3*gt)+149.7*Cos(255.25*pix+3*gv-4*gt)+
      19.4*Cos( 49.50*pix+3*gv-5*gt)+ 37.6*Cos(116.38*pix+4*gv-4*gt)+
      19.6*Cos(105.20*pix+4*gv-5*gt)+ 16.3*Cos(145.40*pix+5*gv-5*gt)+
      14.1*Cos(105.40*pix+5*gv-7*gt)+ 15.0*Cos(127.70*pix-  gm+  gt)+
     205.7*Cos(253.83*pix-2*gm+2*gt)+ 15.1*Cos(295.00*pix-2*gm+  gt)+
      16.8*Cos(203.50*pix-3*gm+3*gt)+ 21.5*Cos(249.00*pix-3*gm+2*gt)+
      47.8*Cos( 15.17*pix-4*gm+3*gt)+ 10.5*Cos( 65.90*pix-4*gm+2*gt)+
      10.7*Cos(324.60*pix-5*gm+4*gt)+ 13.9*Cos(137.30*pix-6*gm+4*gt)+
      20.8*Cos(112.0 *pix-  gj+2*gt)+706.7*Cos( 89.55*pix-  gj+  gt)+
      24.4*Cos(338.6 *pix-  gj     )+ 10.3*Cos(350.5 *pix-2*gj+3*gt)+
     145.9*Cos( 19.47*pix-2*gj+  gt)+402.6*Cos(357.11*pix-2*gj+2*gt)+
      28.1*Cos( 81.2 *pix-3*gj+3*gt)+ 80.3*Cos(352.56*pix-3*gj+2*gt)+ 
      17.4*Cos(  8.6 *pix-3*gj+  gt)+ 11.3*Cos(347.7 *pix-4*gj+2*gt)+
      42.9*Cos( 10.60*pix-  gs+  gt)+ 16.2*Cos(200.6 *pix-2*gs+2*gt)+
      11.2*Cos(203.1 *pix-2*gs+  gt); 
  
  
  bmoon:=5.15*Sin(moonlom)*pix;
  pimoon:=3423*(1.0+0.0549*Cos(moonanomaly));
  pisol :=8.8/Exp(a*1.0E-8*Ln(10));
  lat:=2501.6*pisol/pimoon*Sin(bmoon);
  cv:=0.029*Cos(145.0*pix+  gv)+     0.092*Cos( 93.7*pix+  gv-2*gt)+
      0.023*Cos(173.0*pix+2*gv-  gt)+0.012*Cos(149.0*pix+2*gv-2*gt)+
      0.067*Cos(123.0*pix+2*gv-3*gt)+0.014*Cos(111.0*pix+2*gv-4*gt)+
      0.014*Cos(201.0*pix+3*gv-2*gt)+0.210*Cos(151.8*pix+3*gv-4*gt)+
      0.031*Cos(  1.8*pix+4*gv-5*gt)+0.012*Cos(180.0*pix+4*gv-6*gt)+
      0.019*Cos( 18.0*pix+5*gv-7*gt)+0.010*Cos( 61.0*pix+8*gv-12*gt)+
      0.017*Cos(273.0*pix-  gj+  gt)+0.016*Cos(180.0*pix-  gj)+
      0.023*Cos(268.0*pix-  gj-  gt)+0.166*Cos(265.5*pix-2*gj+  gt)+
      0.018*Cos(267.0*pix-3*gj+  gt);
  lat:=(lat+cv)/3600*pix;
  c:=c+6.454*Sin(2.0*Pi*d)/3600.0;
  a:=a+526732.0*pisol/pimoon*Cos(bmoon)*Cos(2.0*Pi*d);
  cv:=pix*(231.19+ 20.20*julcent);   c:=c+1.78E-3*Sin(cv);
  cv:=pix*( 57.24+150.27*julcent);   c:=c+(5.23E-4-4.4E-6*julcent)*Sin(cv);
  radius_vector:=Exp(a*1.0E-8*Ln(10));
  delfi :=(-17.23*Sin(2*Pi*omega)-1.257*Sin(2*long*pix))/3600.0*pix;
  deleps:=(9.21*Cos(2*Pi*omega)+0.546*Cos(2*long*pix))/3600.0*pix;
  long:=long+c-20.4/3600/radius_vector+delfi/pix;
  Writeln('Long ',long:10:6,' Lat (b}gsek) ',lat*3600/pix:5:2);
  Writeln('Radius vector ',radius_vector:8:6);
  xsol:=radius_vector*Cos(long*pix)*Cos(lat);
  ysol:=radius_vector*Sin(long*pix)*Cos(lat);
  zsol:=radius_vector*Sin(lat);
  
  
END;  
(*-------------------------------------------------------*)
PROCEDURE xyztorad(x,y,z:Real;VAR r,a,d:Real);
BEGIN
  r:=Sqrt(x*x+y*y+z*z);
  d:=Arctan(z/Sqrt(x*x+y*y));
  IF x=0 THEN a:=Pi/2.0 ELSE a:=Arctan(y/x);
  IF a<0 THEN a:=a+Pi;
  IF y<0 THEN a:=a+Pi;
END;    
(*-------------------------------------------------------*)
PROCEDURE radtoxyz(r,a,d:Real; VAR x,y,z:Real);
BEGIN
  x:=r*Cos(a)*Cos(d);
  y:=r*Sin(a)*Cos(d);
  z:=r*Sin(d);
END;    

(*----------------------------------------------------*)
PROCEDURE rotate(angle:Real;VAR x,y,z:Real);
VAR temp:Real;
BEGIN
  temp:= y*Cos(angle)+z*Sin(angle);
  z   :=-y*Sin(angle)+z*Cos(angle);
  y   :=temp;
END;

(*----------------------------------------------------*)       
PROCEDURE indata;
BEGIN
  Write(Clrhom); Initturtle; Cursoron;
  Moveto(100,350); Charsize(2);
  Writestr('Coordinates of the sun');
  Gotoxy(0,7);
  Writeln('Apparent position, true ecliptic of date.');
  sol; jd:=jd+2415020.0;
  dt:=24+julcent*(72.318+29.950*julcent);
  IF jd<2400000.0 THEN Writeln('ET-UT=',dt/60:4:0,' min');
 
END;
(*-----------------------------------------------------*)
(*-------------      MAIN PROGRAM   -------------------*)
(*-----------------------------------------------------*)
BEGIN
  Write(Clrhom);
  indata;  
  REPEAT
    epsilon:=23.452294+julcent*(-0.01301+julcent*(-1.64E-6+julcent*5.03E-7));
    epsilon:=epsilon*Pi/180.0;
    trueeps:=epsilon+deleps;
    rotate(-trueeps,xsol,ysol,zsol);
    xyztorad(xsol,ysol,zsol,rad,alph,del);
    Writeln('R A : ',alph*180.0/Pi:10:6,'  Dekl: ',del*180.0/Pi:10:6);
    Write('New date=');
    Read(KBD,ch); Writeln;
    IF ch<>'' THEN HALT;
    sol; jd:=jd+2415020.0;
  UNTIL False;
END.    
(****************************************************************));
    }3                 